/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.util.Random;
import net.minecraft.src.CodecMus;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.GameSettings;
import net.minecraft.src.MathHelper;
import net.minecraft.src.SoundPool;
import net.minecraft.src.SoundPoolEntry;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

public class SoundManager {
    private static SoundSystem sndSystem;
    private SoundPool soundPoolSounds = new SoundPool();
    private SoundPool soundPoolStreaming = new SoundPool();
    private SoundPool soundPoolMusic = new SoundPool();
    private int latestSoundID = 0;
    private GameSettings options;
    private static boolean loaded;
    private Random rand = new Random();
    private int ticksBeforeMusic = this.rand.nextInt(12000);

    public void loadSoundSettings(GameSettings par1GameSettings) {
        this.soundPoolStreaming.isGetRandomSound = false;
        this.options = par1GameSettings;
        if (!(loaded || par1GameSettings != null && par1GameSettings.soundVolume == 0.0f && par1GameSettings.musicVolume == 0.0f)) {
            this.tryToSetLibraryAndCodecs();
        }
    }

    private void tryToSetLibraryAndCodecs() {
        try {
            float f = this.options.soundVolume;
            float f1 = this.options.musicVolume;
            this.options.soundVolume = 0.0f;
            this.options.musicVolume = 0.0f;
            this.options.saveOptions();
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec("ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec("mus", CodecMus.class);
            SoundSystemConfig.setCodec("wav", CodecWav.class);
            sndSystem = new SoundSystem();
            this.options.soundVolume = f;
            this.options.musicVolume = f1;
            this.options.saveOptions();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        loaded = true;
    }

    public void onSoundOptionsChanged() {
        if (!(loaded || this.options.soundVolume == 0.0f && this.options.musicVolume == 0.0f)) {
            this.tryToSetLibraryAndCodecs();
        }
        if (loaded) {
            if (this.options.musicVolume == 0.0f) {
                sndSystem.stop("BgMusic");
            } else {
                sndSystem.setVolume("BgMusic", this.options.musicVolume);
            }
        }
    }

    public void closeMinecraft() {
        if (loaded) {
            sndSystem.cleanup();
        }
    }

    public void addSound(String par1Str, File par2File) {
        this.soundPoolSounds.addSound(par1Str, par2File);
    }

    public void addStreaming(String par1Str, File par2File) {
        this.soundPoolStreaming.addSound(par1Str, par2File);
    }

    public void addMusic(String par1Str, File par2File) {
        this.soundPoolMusic.addSound(par1Str, par2File);
    }

    public void playRandomMusicIfReady() {
        if (!loaded || this.options.musicVolume == 0.0f) {
            return;
        }
        if (!sndSystem.playing("BgMusic") && !sndSystem.playing("streaming")) {
            if (this.ticksBeforeMusic > 0) {
                --this.ticksBeforeMusic;
                return;
            }
            SoundPoolEntry soundpoolentry = this.soundPoolMusic.getRandomSound();
            if (soundpoolentry != null) {
                this.ticksBeforeMusic = this.rand.nextInt(12000) + 12000;
                sndSystem.backgroundMusic("BgMusic", soundpoolentry.soundUrl, soundpoolentry.soundName, false);
                sndSystem.setVolume("BgMusic", this.options.musicVolume);
                sndSystem.play("BgMusic");
            }
        }
    }

    public void setListener(EntityLiving par1EntityLiving, float par2) {
        if (!loaded || this.options.soundVolume == 0.0f) {
            return;
        }
        if (par1EntityLiving == null) {
            return;
        }
        float f = par1EntityLiving.prevRotationYaw + (par1EntityLiving.rotationYaw - par1EntityLiving.prevRotationYaw) * par2;
        double d = par1EntityLiving.prevPosX + (par1EntityLiving.posX - par1EntityLiving.prevPosX) * (double)par2;
        double d1 = par1EntityLiving.prevPosY + (par1EntityLiving.posY - par1EntityLiving.prevPosY) * (double)par2;
        double d2 = par1EntityLiving.prevPosZ + (par1EntityLiving.posZ - par1EntityLiving.prevPosZ) * (double)par2;
        float f1 = MathHelper.cos(-f * 0.01745329f - (float)Math.PI);
        float f2 = MathHelper.sin(-f * 0.01745329f - (float)Math.PI);
        float f3 = -f2;
        float f4 = 0.0f;
        float f5 = -f1;
        float f6 = 0.0f;
        float f7 = 1.0f;
        float f8 = 0.0f;
        sndSystem.setListenerPosition((float)d, (float)d1, (float)d2);
        sndSystem.setListenerOrientation(f3, f4, f5, f6, f7, f8);
    }

    public void playStreaming(String par1Str, float par2, float par3, float par4, float par5, float par6) {
        if (!loaded || this.options.soundVolume == 0.0f && par1Str != null) {
            return;
        }
        String s = "streaming";
        if (sndSystem.playing("streaming")) {
            sndSystem.stop("streaming");
        }
        if (par1Str == null) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolStreaming.getRandomSoundFromSoundPool(par1Str);
        if (soundpoolentry != null && par5 > 0.0f) {
            if (sndSystem.playing("BgMusic")) {
                sndSystem.stop("BgMusic");
            }
            float f = 16.0f;
            sndSystem.newStreamingSource(true, s, soundpoolentry.soundUrl, soundpoolentry.soundName, false, par2, par3, par4, 2, f * 4.0f);
            sndSystem.setVolume(s, 0.5f * this.options.soundVolume);
            sndSystem.play(s);
        }
    }

    public void playSound(String par1Str, float par2, float par3, float par4, float par5, float par6) {
        if (!loaded || this.options.soundVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolSounds.getRandomSoundFromSoundPool(par1Str);
        if (soundpoolentry != null && par5 > 0.0f) {
            this.latestSoundID = (this.latestSoundID + 1) % 256;
            String s = "sound_" + this.latestSoundID;
            float f = 16.0f;
            if (par5 > 1.0f) {
                f *= par5;
            }
            sndSystem.newSource(par5 > 1.0f, s, soundpoolentry.soundUrl, soundpoolentry.soundName, false, par2, par3, par4, 2, f);
            sndSystem.setPitch(s, par6);
            if (par5 > 1.0f) {
                par5 = 1.0f;
            }
            sndSystem.setVolume(s, par5 * this.options.soundVolume);
            sndSystem.play(s);
        }
    }

    public void playSoundFX(String par1Str, float par2, float par3) {
        if (!loaded || this.options.soundVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolSounds.getRandomSoundFromSoundPool(par1Str);
        if (soundpoolentry != null) {
            this.latestSoundID = (this.latestSoundID + 1) % 256;
            String s = "sound_" + this.latestSoundID;
            sndSystem.newSource(false, s, soundpoolentry.soundUrl, soundpoolentry.soundName, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (par2 > 1.0f) {
                par2 = 1.0f;
            }
            sndSystem.setPitch(s, par3);
            sndSystem.setVolume(s, (par2 *= 0.25f) * this.options.soundVolume);
            sndSystem.play(s);
        }
    }

    static {
        loaded = false;
    }
}

