/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityOcelot;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.WeightedRandom;
import net.minecraft.src.World;

public final class SpawnerAnimals {
    private static HashMap eligibleChunksForSpawning = new HashMap();
    protected static final Class[] nightSpawnEntities = new Class[]{EntitySpider.class, EntityZombie.class, EntitySkeleton.class};

    protected static ChunkPosition getRandomSpawningPointInChunk(World par0World, int par1, int par2) {
        Chunk chunk = par0World.getChunkFromChunkCoords(par1, par2);
        int i = par1 * 16 + par0World.rand.nextInt(16);
        int j = par0World.rand.nextInt(chunk != null ? Math.max(128, chunk.getTopFilledSegment()) : 128);
        int k = par2 * 16 + par0World.rand.nextInt(16);
        return new ChunkPosition(i, j, k);
    }

    public static final int performSpawning(World par0World, boolean par1, boolean par2) {
        int var3;
        if (!par1 && !par2) {
            return 0;
        }
        eligibleChunksForSpawning.clear();
        for (var3 = 0; var3 < par0World.playerEntities.size(); ++var3) {
            EntityPlayer var4 = (EntityPlayer)par0World.playerEntities.get(var3);
            int var5 = MathHelper.floor_double(var4.posX / 16.0);
            int var6 = MathHelper.floor_double(var4.posZ / 16.0);
            int var7 = 8;
            for (int var8 = -var7; var8 <= var7; ++var8) {
                for (int var9 = -var7; var9 <= var7; ++var9) {
                    boolean var10 = var8 == -var7 || var8 == var7 || var9 == -var7 || var9 == var7;
                    ChunkCoordIntPair var11 = new ChunkCoordIntPair(var8 + var5, var9 + var6);
                    if (!var10) {
                        eligibleChunksForSpawning.put(var11, false);
                        continue;
                    }
                    if (eligibleChunksForSpawning.containsKey(var11)) continue;
                    eligibleChunksForSpawning.put(var11, true);
                }
            }
        }
        var3 = 0;
        ChunkCoordinates var31 = par0World.getSpawnPoint();
        for (EnumCreatureType var34 : EnumCreatureType.values()) {
            if (var34.getPeacefulCreature() && !par2 || !var34.getPeacefulCreature() && !par1 || par0World.countEntities(var34.getCreatureClass()) > var34.getMaxNumberOfCreature() * eligibleChunksForSpawning.size() / 256) continue;
            block6: for (ChunkCoordIntPair var37 : eligibleChunksForSpawning.keySet()) {
                if (((Boolean)eligibleChunksForSpawning.get(var37)).booleanValue()) continue;
                ChunkPosition var36 = SpawnerAnimals.getRandomSpawningPointInChunk(par0World, var37.chunkXPos, var37.chunkZPosition);
                int var12 = var36.x;
                int var13 = var36.y;
                int var14 = var36.z;
                if (par0World.isBlockNormalCube(var12, var13, var14) || par0World.getBlockMaterial(var12, var13, var14) != var34.getCreatureMaterial()) continue;
                int var15 = 0;
                block7: for (int var16 = 0; var16 < 3; ++var16) {
                    int var17 = var12;
                    int var18 = var13;
                    int var19 = var14;
                    int var20 = 6;
                    SpawnListEntry var21 = null;
                    for (int var22 = 0; var22 < 4; ++var22) {
                        EntityLiving var38;
                        float var28;
                        float var27;
                        float var26;
                        float var29;
                        float var25;
                        float var24;
                        float var23;
                        if (!SpawnerAnimals.canCreatureTypeSpawnAtLocation(var34, par0World, var17 += par0World.rand.nextInt(var20) - par0World.rand.nextInt(var20), var18 += par0World.rand.nextInt(1) - par0World.rand.nextInt(1), var19 += par0World.rand.nextInt(var20) - par0World.rand.nextInt(var20)) || par0World.getClosestPlayer(var23 = (float)var17 + 0.5f, var24 = (float)var18, var25 = (float)var19 + 0.5f, 24.0) != null || !((var29 = (var26 = var23 - (float)var31.posX) * var26 + (var27 = var24 - (float)var31.posY) * var27 + (var28 = var25 - (float)var31.posZ) * var28) >= 576.0f)) continue;
                        if (var21 == null && (var21 = par0World.getRandomMob(var34, var17, var18, var19)) == null) continue block7;
                        try {
                            var38 = (EntityLiving)var21.entityClass.getConstructor(World.class).newInstance(par0World);
                        }
                        catch (Exception var30) {
                            var30.printStackTrace();
                            return var3;
                        }
                        var38.setLocationAndAngles(var23, var24, var25, par0World.rand.nextFloat() * 360.0f, 0.0f);
                        if (var38.getCanSpawnHere()) {
                            par0World.spawnEntityInWorld(var38);
                            SpawnerAnimals.creatureSpecificInit(var38, par0World, var23, var24, var25);
                            if (++var15 >= var38.getMaxSpawnedInChunk()) continue block6;
                        }
                        var3 += var15;
                    }
                }
            }
        }
        return var3;
    }

    public static boolean canCreatureTypeSpawnAtLocation(EnumCreatureType par0EnumCreatureType, World par1World, int par2, int par3, int par4) {
        if (par0EnumCreatureType.getCreatureMaterial() == Material.water) {
            return par1World.getBlockMaterial(par2, par3, par4).isLiquid() && !par1World.isBlockNormalCube(par2, par3 + 1, par4);
        }
        int i = par1World.getBlockId(par2, par3 - 1, par4);
        return Block.isNormalCube(i) && i != Block.bedrock.blockID && !par1World.isBlockNormalCube(par2, par3, par4) && !par1World.getBlockMaterial(par2, par3, par4).isLiquid() && !par1World.isBlockNormalCube(par2, par3 + 1, par4);
    }

    private static void creatureSpecificInit(EntityLiving par0EntityLiving, World par1World, float par2, float par3, float par4) {
        if (par0EntityLiving instanceof EntitySpider && par1World.rand.nextInt(100) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(par1World);
            entityskeleton.setLocationAndAngles(par2, par3, par4, par0EntityLiving.rotationYaw, 0.0f);
            par1World.spawnEntityInWorld(entityskeleton);
            entityskeleton.mountEntity(par0EntityLiving);
        } else if (par0EntityLiving instanceof EntitySheep) {
            ((EntitySheep)par0EntityLiving).setFleeceColor(EntitySheep.getRandomFleeceColor(par1World.rand));
        } else if (par0EntityLiving instanceof EntityOcelot && par1World.rand.nextInt(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                EntityOcelot entityocelot = new EntityOcelot(par1World);
                entityocelot.setLocationAndAngles(par2, par3, par4, par0EntityLiving.rotationYaw, 0.0f);
                entityocelot.setGrowingAge(-24000);
                par1World.spawnEntityInWorld(entityocelot);
            }
        }
    }

    public static void performWorldGenSpawning(World par0World, BiomeGenBase par1BiomeGenBase, int par2, int par3, int par4, int par5, Random par6Random) {
        List list = par1BiomeGenBase.getSpawnableList(EnumCreatureType.creature);
        if (list.isEmpty()) {
            return;
        }
        while (par6Random.nextFloat() < par1BiomeGenBase.getSpawningChance()) {
            SpawnListEntry spawnlistentry = (SpawnListEntry)WeightedRandom.getRandomItem(par0World.rand, list);
            int i = spawnlistentry.minGroupCount + par6Random.nextInt(1 + spawnlistentry.maxGroupCount - spawnlistentry.minGroupCount);
            int j = par2 + par6Random.nextInt(par4);
            int k = par3 + par6Random.nextInt(par5);
            int l = j;
            int i1 = k;
            for (int j1 = 0; j1 < i; ++j1) {
                boolean flag = false;
                for (int k1 = 0; !flag && k1 < 4; ++k1) {
                    int l1 = par0World.getTopSolidOrLiquidBlock(j, k);
                    if (SpawnerAnimals.canCreatureTypeSpawnAtLocation(EnumCreatureType.creature, par0World, j, l1, k)) {
                        EntityLiving entityliving;
                        float f = (float)j + 0.5f;
                        float f1 = l1;
                        float f2 = (float)k + 0.5f;
                        try {
                            entityliving = (EntityLiving)spawnlistentry.entityClass.getConstructor(World.class).newInstance(par0World);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        entityliving.setLocationAndAngles(f, f1, f2, par6Random.nextFloat() * 360.0f, 0.0f);
                        par0World.spawnEntityInWorld(entityliving);
                        SpawnerAnimals.creatureSpecificInit(entityliving, par0World, f, f1, f2);
                        flag = true;
                    }
                    j += par6Random.nextInt(5) - par6Random.nextInt(5);
                    k += par6Random.nextInt(5) - par6Random.nextInt(5);
                    while (j < par2 || j >= par2 + par4 || k < par3 || k >= par3 + par4) {
                        j = l + par6Random.nextInt(5) - par6Random.nextInt(5);
                        k = i1 + par6Random.nextInt(5) - par6Random.nextInt(5);
                    }
                }
            }
        }
    }
}

