/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.FurnaceRecipes;
import net.minecraft.src.IRecipe;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatBasic;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StatCrafting;

public class StatList {
    protected static Map oneShotStats = new HashMap();
    public static List allStats = new ArrayList();
    public static List generalStats = new ArrayList();
    public static List itemStats = new ArrayList();
    public static List objectMineStats = new ArrayList();
    public static StatBase startGameStat = new StatBasic(1000, "stat.startGame").initIndependentStat().registerStat();
    public static StatBase createWorldStat = new StatBasic(1001, "stat.createWorld").initIndependentStat().registerStat();
    public static StatBase loadWorldStat = new StatBasic(1002, "stat.loadWorld").initIndependentStat().registerStat();
    public static StatBase joinMultiplayerStat = new StatBasic(1003, "stat.joinMultiplayer").initIndependentStat().registerStat();
    public static StatBase leaveGameStat = new StatBasic(1004, "stat.leaveGame").initIndependentStat().registerStat();
    public static StatBase minutesPlayedStat;
    public static StatBase distanceWalkedStat;
    public static StatBase distanceSwumStat;
    public static StatBase distanceFallenStat;
    public static StatBase distanceClimbedStat;
    public static StatBase distanceFlownStat;
    public static StatBase distanceDoveStat;
    public static StatBase distanceByMinecartStat;
    public static StatBase distanceByBoatStat;
    public static StatBase distanceByPigStat;
    public static StatBase jumpStat;
    public static StatBase dropStat;
    public static StatBase damageDealtStat;
    public static StatBase damageTakenStat;
    public static StatBase deathsStat;
    public static StatBase mobKillsStat;
    public static StatBase playerKillsStat;
    public static StatBase fishCaughtStat;
    public static StatBase[] mineBlockStatArray;
    public static StatBase[] objectCraftStats;
    public static StatBase[] objectUseStats;
    public static StatBase[] objectBreakStats;
    private static boolean blockStatsInitialized;
    private static boolean itemStatsInitialized;

    public static void func_27360_a() {
    }

    public static void initBreakableStats() {
        objectUseStats = StatList.initUsableStats(objectUseStats, "stat.useItem", 0x1020000, 0, 256);
        objectBreakStats = StatList.initBreakStats(objectBreakStats, "stat.breakItem", 0x1030000, 0, 256);
        blockStatsInitialized = true;
        StatList.initCraftableStats();
    }

    public static void initStats() {
        objectUseStats = StatList.initUsableStats(objectUseStats, "stat.useItem", 0x1020000, 256, 32000);
        objectBreakStats = StatList.initBreakStats(objectBreakStats, "stat.breakItem", 0x1030000, 256, 32000);
        itemStatsInitialized = true;
        StatList.initCraftableStats();
    }

    public static void initCraftableStats() {
        if (!blockStatsInitialized || !itemStatsInitialized) {
            return;
        }
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (IRecipe irecipe : CraftingManager.getInstance().getRecipeList()) {
            hashset.add(irecipe.getRecipeOutput().itemID);
        }
        for (ItemStack itemstack : FurnaceRecipes.smelting().getSmeltingList().values()) {
            hashset.add(itemstack.itemID);
        }
        objectCraftStats = new StatBase[32000];
        for (Integer integer : hashset) {
            if (Item.itemsList[integer] == null) continue;
            String s = StatCollector.translateToLocalFormatted("stat.craftItem", new Object[]{Item.itemsList[integer].getStatName()});
            StatList.objectCraftStats[integer.intValue()] = new StatCrafting(0x1010000 + integer, s, integer).registerStat();
        }
        StatList.replaceAllSimilarBlocks(objectCraftStats);
    }

    private static StatBase[] initMinableStats(String par0Str, int par1) {
        StatBase[] astatbase = new StatBase[256];
        for (int i = 0; i < 256; ++i) {
            if (Block.blocksList[i] == null || !Block.blocksList[i].getEnableStats()) continue;
            String s = StatCollector.translateToLocalFormatted(par0Str, new Object[]{Block.blocksList[i].translateBlockName()});
            astatbase[i] = new StatCrafting(par1 + i, s, i).registerStat();
            objectMineStats.add((StatCrafting)astatbase[i]);
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static StatBase[] initUsableStats(StatBase[] par0ArrayOfStatBase, String par1Str, int par2, int par3, int par4) {
        if (par0ArrayOfStatBase == null) {
            par0ArrayOfStatBase = new StatBase[32000];
        }
        for (int i = par3; i < par4; ++i) {
            if (Item.itemsList[i] == null) continue;
            String s = StatCollector.translateToLocalFormatted(par1Str, new Object[]{Item.itemsList[i].getStatName()});
            par0ArrayOfStatBase[i] = new StatCrafting(par2 + i, s, i).registerStat();
            if (i < 256) continue;
            itemStats.add((StatCrafting)par0ArrayOfStatBase[i]);
        }
        StatList.replaceAllSimilarBlocks(par0ArrayOfStatBase);
        return par0ArrayOfStatBase;
    }

    private static StatBase[] initBreakStats(StatBase[] par0ArrayOfStatBase, String par1Str, int par2, int par3, int par4) {
        if (par0ArrayOfStatBase == null) {
            par0ArrayOfStatBase = new StatBase[32000];
        }
        for (int i = par3; i < par4; ++i) {
            if (Item.itemsList[i] == null || !Item.itemsList[i].isDamageable()) continue;
            String s = StatCollector.translateToLocalFormatted(par1Str, new Object[]{Item.itemsList[i].getStatName()});
            par0ArrayOfStatBase[i] = new StatCrafting(par2 + i, s, i).registerStat();
        }
        StatList.replaceAllSimilarBlocks(par0ArrayOfStatBase);
        return par0ArrayOfStatBase;
    }

    private static void replaceAllSimilarBlocks(StatBase[] par0ArrayOfStatBase) {
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.waterStill.blockID, Block.waterMoving.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.lavaStill.blockID, Block.lavaStill.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.pumpkinLantern.blockID, Block.pumpkin.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.stoneOvenActive.blockID, Block.stoneOvenIdle.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.oreRedstoneGlowing.blockID, Block.oreRedstone.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.redstoneRepeaterActive.blockID, Block.redstoneRepeaterIdle.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.torchRedstoneActive.blockID, Block.torchRedstoneIdle.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.mushroomRed.blockID, Block.mushroomBrown.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.stairDouble.blockID, Block.stairSingle.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.grass.blockID, Block.dirt.blockID);
        StatList.replaceSimilarBlocks(par0ArrayOfStatBase, Block.tilledField.blockID, Block.dirt.blockID);
    }

    private static void replaceSimilarBlocks(StatBase[] par0ArrayOfStatBase, int par1, int par2) {
        if (par0ArrayOfStatBase[par1] != null && par0ArrayOfStatBase[par2] == null) {
            par0ArrayOfStatBase[par2] = par0ArrayOfStatBase[par1];
            return;
        }
        allStats.remove(par0ArrayOfStatBase[par1]);
        objectMineStats.remove(par0ArrayOfStatBase[par1]);
        generalStats.remove(par0ArrayOfStatBase[par1]);
        par0ArrayOfStatBase[par1] = par0ArrayOfStatBase[par2];
    }

    public static StatBase getOneShotStat(int par0) {
        return (StatBase)oneShotStats.get(par0);
    }

    static {
        jumpStat = new StatBasic(2010, "stat.jump").initIndependentStat().registerStat();
        dropStat = new StatBasic(2011, "stat.drop").initIndependentStat().registerStat();
        damageDealtStat = new StatBasic(2020, "stat.damageDealt").registerStat();
        damageTakenStat = new StatBasic(2021, "stat.damageTaken").registerStat();
        deathsStat = new StatBasic(2022, "stat.deaths").registerStat();
        mobKillsStat = new StatBasic(2023, "stat.mobKills").registerStat();
        playerKillsStat = new StatBasic(2024, "stat.playerKills").registerStat();
        fishCaughtStat = new StatBasic(2025, "stat.fishCaught").registerStat();
        mineBlockStatArray = StatList.initMinableStats("stat.mineBlock", 0x1000000);
        blockStatsInitialized = false;
        itemStatsInitialized = false;
        minutesPlayedStat = new StatBasic(1100, "stat.playOneMinute", StatBase.timeStatType).initIndependentStat().registerStat();
        distanceWalkedStat = new StatBasic(2000, "stat.walkOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceSwumStat = new StatBasic(2001, "stat.swimOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceFallenStat = new StatBasic(2002, "stat.fallOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceClimbedStat = new StatBasic(2003, "stat.climbOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceFlownStat = new StatBasic(2004, "stat.flyOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceDoveStat = new StatBasic(2005, "stat.diveOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceByMinecartStat = new StatBasic(2006, "stat.minecartOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceByBoatStat = new StatBasic(2007, "stat.boatOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        distanceByPigStat = new StatBasic(2008, "stat.pigOneCm", StatBase.distanceStatType).initIndependentStat().registerStat();
        AchievementList.init();
    }
}

