/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.Item;
import net.minecraft.src.ItemDoor;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StructureBoundingBox;
import net.minecraft.src.StructurePieceBlockSelector;
import net.minecraft.src.StructurePieceTreasure;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.WeightedRandom;
import net.minecraft.src.World;

public abstract class StructureComponent {
    protected StructureBoundingBox boundingBox;
    protected int coordBaseMode;
    protected int componentType;

    protected StructureComponent(int par1) {
        this.componentType = par1;
        this.coordBaseMode = -1;
    }

    public void buildComponent(StructureComponent structurecomponent, List list, Random random) {
    }

    public abstract boolean addComponentParts(World var1, Random var2, StructureBoundingBox var3);

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public static StructureComponent findIntersecting(List par0List, StructureBoundingBox par1StructureBoundingBox) {
        for (StructureComponent structurecomponent : par0List) {
            if (structurecomponent.getBoundingBox() == null || !structurecomponent.getBoundingBox().intersectsWith(par1StructureBoundingBox)) continue;
            return structurecomponent;
        }
        return null;
    }

    public ChunkPosition getCenter() {
        return new ChunkPosition(this.boundingBox.getCenterX(), this.boundingBox.getCenterY(), this.boundingBox.getCenterZ());
    }

    protected boolean isLiquidInStructureBoundingBox(World par1World, StructureBoundingBox par2StructureBoundingBox) {
        int i = Math.max(this.boundingBox.minX - 1, par2StructureBoundingBox.minX);
        int j = Math.max(this.boundingBox.minY - 1, par2StructureBoundingBox.minY);
        int k = Math.max(this.boundingBox.minZ - 1, par2StructureBoundingBox.minZ);
        int l = Math.min(this.boundingBox.maxX + 1, par2StructureBoundingBox.maxX);
        int i1 = Math.min(this.boundingBox.maxY + 1, par2StructureBoundingBox.maxY);
        int j1 = Math.min(this.boundingBox.maxZ + 1, par2StructureBoundingBox.maxZ);
        for (int k1 = i; k1 <= l; ++k1) {
            for (int j2 = k; j2 <= j1; ++j2) {
                int i3 = par1World.getBlockId(k1, j, j2);
                if (i3 > 0 && Block.blocksList[i3].blockMaterial.isLiquid()) {
                    return true;
                }
                i3 = par1World.getBlockId(k1, i1, j2);
                if (i3 <= 0 || !Block.blocksList[i3].blockMaterial.isLiquid()) continue;
                return true;
            }
        }
        for (int l1 = i; l1 <= l; ++l1) {
            for (int k2 = j; k2 <= i1; ++k2) {
                int j3 = par1World.getBlockId(l1, k2, k);
                if (j3 > 0 && Block.blocksList[j3].blockMaterial.isLiquid()) {
                    return true;
                }
                j3 = par1World.getBlockId(l1, k2, j1);
                if (j3 <= 0 || !Block.blocksList[j3].blockMaterial.isLiquid()) continue;
                return true;
            }
        }
        for (int i2 = k; i2 <= j1; ++i2) {
            for (int l2 = j; l2 <= i1; ++l2) {
                int k3 = par1World.getBlockId(i, l2, i2);
                if (k3 > 0 && Block.blocksList[k3].blockMaterial.isLiquid()) {
                    return true;
                }
                k3 = par1World.getBlockId(l, l2, i2);
                if (k3 <= 0 || !Block.blocksList[k3].blockMaterial.isLiquid()) continue;
                return true;
            }
        }
        return false;
    }

    protected int getXWithOffset(int par1, int par2) {
        switch (this.coordBaseMode) {
            case 0: 
            case 2: {
                return this.boundingBox.minX + par1;
            }
            case 1: {
                return this.boundingBox.maxX - par2;
            }
            case 3: {
                return this.boundingBox.minX + par2;
            }
        }
        return par1;
    }

    protected int getYWithOffset(int par1) {
        if (this.coordBaseMode == -1) {
            return par1;
        }
        return par1 + this.boundingBox.minY;
    }

    protected int getZWithOffset(int par1, int par2) {
        switch (this.coordBaseMode) {
            case 2: {
                return this.boundingBox.maxZ - par2;
            }
            case 0: {
                return this.boundingBox.minZ + par2;
            }
            case 1: 
            case 3: {
                return this.boundingBox.minZ + par1;
            }
        }
        return par2;
    }

    protected int getMetadataWithOffset(int par1, int par2) {
        if (par1 == Block.rail.blockID) {
            if (this.coordBaseMode == 1 || this.coordBaseMode == 3) {
                return par2 != 1 ? 1 : 0;
            }
        } else if (par1 == Block.doorWood.blockID || par1 == Block.doorSteel.blockID) {
            if (this.coordBaseMode == 0) {
                if (par2 == 0) {
                    return 2;
                }
                if (par2 == 2) {
                    return 0;
                }
            } else {
                if (this.coordBaseMode == 1) {
                    return par2 + 1 & 3;
                }
                if (this.coordBaseMode == 3) {
                    return par2 + 3 & 3;
                }
            }
        } else if (par1 == Block.stairCompactCobblestone.blockID || par1 == Block.stairCompactPlanks.blockID || par1 == Block.stairsNetherBrick.blockID || par1 == Block.stairsStoneBrickSmooth.blockID) {
            if (this.coordBaseMode == 0) {
                if (par2 == 2) {
                    return 3;
                }
                if (par2 == 3) {
                    return 2;
                }
            } else if (this.coordBaseMode == 1) {
                if (par2 == 0) {
                    return 2;
                }
                if (par2 == 1) {
                    return 3;
                }
                if (par2 == 2) {
                    return 0;
                }
                if (par2 == 3) {
                    return 1;
                }
            } else if (this.coordBaseMode == 3) {
                if (par2 == 0) {
                    return 2;
                }
                if (par2 == 1) {
                    return 3;
                }
                if (par2 == 2) {
                    return 1;
                }
                if (par2 == 3) {
                    return 0;
                }
            }
        } else if (par1 == Block.ladder.blockID) {
            if (this.coordBaseMode == 0) {
                if (par2 == 2) {
                    return 3;
                }
                if (par2 == 3) {
                    return 2;
                }
            } else if (this.coordBaseMode == 1) {
                if (par2 == 2) {
                    return 4;
                }
                if (par2 == 3) {
                    return 5;
                }
                if (par2 == 4) {
                    return 2;
                }
                if (par2 == 5) {
                    return 3;
                }
            } else if (this.coordBaseMode == 3) {
                if (par2 == 2) {
                    return 5;
                }
                if (par2 == 3) {
                    return 4;
                }
                if (par2 == 4) {
                    return 2;
                }
                if (par2 == 5) {
                    return 3;
                }
            }
        } else if (par1 == Block.button.blockID) {
            if (this.coordBaseMode == 0) {
                if (par2 == 3) {
                    return 4;
                }
                if (par2 == 4) {
                    return 3;
                }
            } else if (this.coordBaseMode == 1) {
                if (par2 == 3) {
                    return 1;
                }
                if (par2 == 4) {
                    return 2;
                }
                if (par2 == 2) {
                    return 3;
                }
                if (par2 == 1) {
                    return 4;
                }
            } else if (this.coordBaseMode == 3) {
                if (par2 == 3) {
                    return 2;
                }
                if (par2 == 4) {
                    return 1;
                }
                if (par2 == 2) {
                    return 3;
                }
                if (par2 == 1) {
                    return 4;
                }
            }
        }
        return par2;
    }

    protected void placeBlockAtCurrentPosition(World par1World, int par2, int par3, int par4, int par5, int par6, StructureBoundingBox par7StructureBoundingBox) {
        int k;
        int j;
        int i = this.getXWithOffset(par4, par6);
        if (!par7StructureBoundingBox.isVecInside(i, j = this.getYWithOffset(par5), k = this.getZWithOffset(par4, par6))) {
            return;
        }
        par1World.setBlockAndMetadata(i, j, k, par2, par3);
    }

    protected int getBlockIdAtCurrentPosition(World par1World, int par2, int par3, int par4, StructureBoundingBox par5StructureBoundingBox) {
        int k;
        int j;
        int i = this.getXWithOffset(par2, par4);
        if (!par5StructureBoundingBox.isVecInside(i, j = this.getYWithOffset(par3), k = this.getZWithOffset(par2, par4))) {
            return 0;
        }
        return par1World.getBlockId(i, j, k);
    }

    protected void fillWithBlocks(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6, int par7, int par8, int par9, int par10, boolean par11) {
        for (int i = par4; i <= par7; ++i) {
            for (int j = par3; j <= par6; ++j) {
                for (int k = par5; k <= par8; ++k) {
                    if (par11 && this.getBlockIdAtCurrentPosition(par1World, j, i, k, par2StructureBoundingBox) == 0) continue;
                    if (i == par4 || i == par7 || j == par3 || j == par6 || k == par5 || k == par8) {
                        this.placeBlockAtCurrentPosition(par1World, par9, 0, j, i, k, par2StructureBoundingBox);
                        continue;
                    }
                    this.placeBlockAtCurrentPosition(par1World, par10, 0, j, i, k, par2StructureBoundingBox);
                }
            }
        }
    }

    protected void fillWithRandomizedBlocks(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6, int par7, int par8, boolean par9, Random par10Random, StructurePieceBlockSelector par11StructurePieceBlockSelector) {
        for (int i = par4; i <= par7; ++i) {
            for (int j = par3; j <= par6; ++j) {
                for (int k = par5; k <= par8; ++k) {
                    if (par9 && this.getBlockIdAtCurrentPosition(par1World, j, i, k, par2StructureBoundingBox) == 0) continue;
                    par11StructurePieceBlockSelector.selectBlocks(par10Random, j, i, k, i == par4 || i == par7 || j == par3 || j == par6 || k == par5 || k == par8);
                    this.placeBlockAtCurrentPosition(par1World, par11StructurePieceBlockSelector.getSelectedBlockId(), par11StructurePieceBlockSelector.getSelectedBlockMetaData(), j, i, k, par2StructureBoundingBox);
                }
            }
        }
    }

    protected void randomlyFillWithBlocks(World par1World, StructureBoundingBox par2StructureBoundingBox, Random par3Random, float par4, int par5, int par6, int par7, int par8, int par9, int par10, int par11, int par12, boolean par13) {
        for (int i = par6; i <= par9; ++i) {
            for (int j = par5; j <= par8; ++j) {
                for (int k = par7; k <= par10; ++k) {
                    if (par3Random.nextFloat() > par4 || par13 && this.getBlockIdAtCurrentPosition(par1World, j, i, k, par2StructureBoundingBox) == 0) continue;
                    if (i == par6 || i == par9 || j == par5 || j == par8 || k == par7 || k == par10) {
                        this.placeBlockAtCurrentPosition(par1World, par11, 0, j, i, k, par2StructureBoundingBox);
                        continue;
                    }
                    this.placeBlockAtCurrentPosition(par1World, par12, 0, j, i, k, par2StructureBoundingBox);
                }
            }
        }
    }

    protected void randomlyPlaceBlock(World par1World, StructureBoundingBox par2StructureBoundingBox, Random par3Random, float par4, int par5, int par6, int par7, int par8, int par9) {
        if (par3Random.nextFloat() < par4) {
            this.placeBlockAtCurrentPosition(par1World, par8, par9, par5, par6, par7, par2StructureBoundingBox);
        }
    }

    protected void randomlyRareFillWithBlocks(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6, int par7, int par8, int par9, boolean par10) {
        float f = par6 - par3 + 1;
        float f1 = par7 - par4 + 1;
        float f2 = par8 - par5 + 1;
        float f3 = (float)par3 + f / 2.0f;
        float f4 = (float)par5 + f2 / 2.0f;
        for (int i = par4; i <= par7; ++i) {
            float f5 = (float)(i - par4) / f1;
            for (int j = par3; j <= par6; ++j) {
                float f6 = ((float)j - f3) / (f * 0.5f);
                for (int k = par5; k <= par8; ++k) {
                    float f8;
                    float f7 = ((float)k - f4) / (f2 * 0.5f);
                    if (par10 && this.getBlockIdAtCurrentPosition(par1World, j, i, k, par2StructureBoundingBox) == 0 || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.placeBlockAtCurrentPosition(par1World, par9, 0, j, i, k, par2StructureBoundingBox);
                }
            }
        }
    }

    protected void clearCurrentPositionBlocksUpwards(World par1World, int par2, int par3, int par4, StructureBoundingBox par5StructureBoundingBox) {
        int k;
        int j;
        int i = this.getXWithOffset(par2, par4);
        if (!par5StructureBoundingBox.isVecInside(i, j = this.getYWithOffset(par3), k = this.getZWithOffset(par2, par4))) {
            return;
        }
        while (!par1World.isAirBlock(i, j, k) && j < 255) {
            par1World.setBlockAndMetadata(i, j, k, 0, 0);
            ++j;
        }
    }

    protected void fillCurrentPositionBlocksDownwards(World par1World, int par2, int par3, int par4, int par5, int par6, StructureBoundingBox par7StructureBoundingBox) {
        int k;
        int j;
        int i = this.getXWithOffset(par4, par6);
        if (!par7StructureBoundingBox.isVecInside(i, j = this.getYWithOffset(par5), k = this.getZWithOffset(par4, par6))) {
            return;
        }
        while ((par1World.isAirBlock(i, j, k) || par1World.getBlockMaterial(i, j, k).isLiquid()) && j > 1) {
            par1World.setBlockAndMetadata(i, j, k, par2, par3);
            --j;
        }
    }

    protected void createTreasureChestAtCurrentPosition(World par1World, StructureBoundingBox par2StructureBoundingBox, Random par3Random, int par4, int par5, int par6, StructurePieceTreasure[] par7ArrayOfStructurePieceTreasure, int par8) {
        int k;
        int j;
        int i = this.getXWithOffset(par4, par6);
        if (par2StructureBoundingBox.isVecInside(i, j = this.getYWithOffset(par5), k = this.getZWithOffset(par4, par6)) && par1World.getBlockId(i, j, k) != Block.chest.blockID) {
            par1World.setBlockWithNotify(i, j, k, Block.chest.blockID);
            TileEntityChest tileentitychest = (TileEntityChest)par1World.getBlockTileEntity(i, j, k);
            if (tileentitychest != null) {
                StructureComponent.fillTreasureChestWithLoot(par3Random, par7ArrayOfStructurePieceTreasure, tileentitychest, par8);
            }
        }
    }

    private static void fillTreasureChestWithLoot(Random par0Random, StructurePieceTreasure[] par1ArrayOfStructurePieceTreasure, TileEntityChest par2TileEntityChest, int par3) {
        for (int i = 0; i < par3; ++i) {
            StructurePieceTreasure structurepiecetreasure = (StructurePieceTreasure)WeightedRandom.getRandomItem(par0Random, par1ArrayOfStructurePieceTreasure);
            int j = structurepiecetreasure.minItemStack + par0Random.nextInt(structurepiecetreasure.maxItemStack - structurepiecetreasure.minItemStack + 1);
            if (Item.itemsList[structurepiecetreasure.itemID].getItemStackLimit() >= j) {
                par2TileEntityChest.setInventorySlotContents(par0Random.nextInt(par2TileEntityChest.getSizeInventory()), new ItemStack(structurepiecetreasure.itemID, j, structurepiecetreasure.itemMetadata));
                continue;
            }
            for (int k = 0; k < j; ++k) {
                par2TileEntityChest.setInventorySlotContents(par0Random.nextInt(par2TileEntityChest.getSizeInventory()), new ItemStack(structurepiecetreasure.itemID, 1, structurepiecetreasure.itemMetadata));
            }
        }
    }

    protected void placeDoorAtCurrentPosition(World par1World, StructureBoundingBox par2StructureBoundingBox, Random par3Random, int par4, int par5, int par6, int par7) {
        int k;
        int j;
        int i = this.getXWithOffset(par4, par6);
        if (par2StructureBoundingBox.isVecInside(i, j = this.getYWithOffset(par5), k = this.getZWithOffset(par4, par6))) {
            ItemDoor.placeDoorBlock(par1World, i, j, k, par7, Block.doorWood);
        }
    }
}

