/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.src.StructureBoundingBox;
import net.minecraft.src.StructureComponent;
import net.minecraft.src.World;

public abstract class StructureStart {
    protected LinkedList components = new LinkedList();
    protected StructureBoundingBox boundingBox;

    protected StructureStart() {
    }

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public LinkedList getComponents() {
        return this.components;
    }

    public void generateStructure(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            StructureComponent structurecomponent = (StructureComponent)iterator.next();
            if (!structurecomponent.getBoundingBox().intersectsWith(par3StructureBoundingBox) || structurecomponent.addComponentParts(par1World, par2Random, par3StructureBoundingBox)) continue;
            iterator.remove();
        }
    }

    protected void updateBoundingBox() {
        this.boundingBox = StructureBoundingBox.getNewBoundingBox();
        for (StructureComponent structurecomponent : this.components) {
            this.boundingBox.expandTo(structurecomponent.getBoundingBox());
        }
    }

    protected void markAvailableHeight(World par1World, Random par2Random, int par3) {
        int i = 63 - par3;
        int j = this.boundingBox.getYSize() + 1;
        if (j < i) {
            j += par2Random.nextInt(i - j);
        }
        int k = j - this.boundingBox.maxY;
        this.boundingBox.offset(0, k, 0);
        for (StructureComponent structurecomponent : this.components) {
            structurecomponent.getBoundingBox().offset(0, k, 0);
        }
    }

    protected void setRandomHeight(World par1World, Random par2Random, int par3, int par4) {
        int i = par4 - par3 + 1 - this.boundingBox.getYSize();
        int j = 1;
        j = i > 1 ? par3 + par2Random.nextInt(i) : par3;
        int k = j - this.boundingBox.minY;
        this.boundingBox.offset(0, k, 0);
        for (StructureComponent structurecomponent : this.components) {
            structurecomponent.getBoundingBox().offset(0, k, 0);
        }
    }

    public boolean isSizeableStructure() {
        return true;
    }
}

