/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.src.ComponentVillage;
import net.minecraft.src.ComponentVillageChurch;
import net.minecraft.src.ComponentVillageField;
import net.minecraft.src.ComponentVillageField2;
import net.minecraft.src.ComponentVillageHall;
import net.minecraft.src.ComponentVillageHouse1;
import net.minecraft.src.ComponentVillageHouse2;
import net.minecraft.src.ComponentVillageHouse3;
import net.minecraft.src.ComponentVillageHouse4_Garden;
import net.minecraft.src.ComponentVillagePathGen;
import net.minecraft.src.ComponentVillageStartPiece;
import net.minecraft.src.ComponentVillageTorch;
import net.minecraft.src.ComponentVillageWoodHut;
import net.minecraft.src.MapGenVillage;
import net.minecraft.src.MathHelper;
import net.minecraft.src.StructureBoundingBox;
import net.minecraft.src.StructureComponent;
import net.minecraft.src.StructureVillagePieceWeight;

public class StructureVillagePieces {
    public static ArrayList getStructureVillageWeightedPieceList(Random par0Random, int par1) {
        ArrayList<StructureVillagePieceWeight> arraylist = new ArrayList<StructureVillagePieceWeight>();
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageHouse4_Garden.class, 4, MathHelper.getRandomIntegerInRange(par0Random, 2 + par1, 4 + par1 * 2)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageChurch.class, 20, MathHelper.getRandomIntegerInRange(par0Random, 0 + par1, 1 + par1)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageHouse1.class, 20, MathHelper.getRandomIntegerInRange(par0Random, 0 + par1, 2 + par1)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageWoodHut.class, 3, MathHelper.getRandomIntegerInRange(par0Random, 2 + par1, 5 + par1 * 3)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageHall.class, 15, MathHelper.getRandomIntegerInRange(par0Random, 0 + par1, 2 + par1)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageField.class, 3, MathHelper.getRandomIntegerInRange(par0Random, 1 + par1, 4 + par1)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageField2.class, 3, MathHelper.getRandomIntegerInRange(par0Random, 2 + par1, 4 + par1 * 2)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageHouse2.class, 15, MathHelper.getRandomIntegerInRange(par0Random, 0, 1 + par1)));
        arraylist.add(new StructureVillagePieceWeight(ComponentVillageHouse3.class, 8, MathHelper.getRandomIntegerInRange(par0Random, 0 + par1, 3 + par1 * 2)));
        Iterator iterator = arraylist.iterator();
        while (iterator.hasNext()) {
            if (((StructureVillagePieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return arraylist;
    }

    private static int getAvailablePieceWeight(ArrayList par0ArrayList) {
        boolean flag = false;
        int i = 0;
        for (StructureVillagePieceWeight structurevillagepieceweight : par0ArrayList) {
            if (structurevillagepieceweight.villagePiecesLimit > 0 && structurevillagepieceweight.villagePiecesSpawned < structurevillagepieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += structurevillagepieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static ComponentVillage getVillageComponentFromWeightedPiece(StructureVillagePieceWeight par0StructureVillagePieceWeight, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        Class class1 = par0StructureVillagePieceWeight.villagePieceClass;
        ComponentVillage obj = null;
        if (class1 == ComponentVillageHouse4_Garden.class) {
            obj = ComponentVillageHouse4_Garden.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageChurch.class) {
            obj = ComponentVillageChurch.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageHouse1.class) {
            obj = ComponentVillageHouse1.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageWoodHut.class) {
            obj = ComponentVillageWoodHut.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageHall.class) {
            obj = ComponentVillageHall.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageField.class) {
            obj = ComponentVillageField.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageField2.class) {
            obj = ComponentVillageField2.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageHouse2.class) {
            obj = ComponentVillageHouse2.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (class1 == ComponentVillageHouse3.class) {
            obj = ComponentVillageHouse3.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        }
        return obj;
    }

    private static ComponentVillage getNextVillageComponent(ComponentVillageStartPiece par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        int var8 = StructureVillagePieces.getAvailablePieceWeight(par0ComponentVillageStartPiece.structureVillageWeightedPieceList);
        if (var8 <= 0) {
            return null;
        }
        int var9 = 0;
        block0: while (var9 < 5) {
            ++var9;
            int var10 = par2Random.nextInt(var8);
            for (StructureVillagePieceWeight var12 : par0ComponentVillageStartPiece.structureVillageWeightedPieceList) {
                if ((var10 -= var12.villagePieceWeight) >= 0) continue;
                if (!var12.canSpawnMoreVillagePiecesOfType(par7) || var12 == par0ComponentVillageStartPiece.structVillagePieceWeight && par0ComponentVillageStartPiece.structureVillageWeightedPieceList.size() > 1) continue block0;
                ComponentVillage var13 = StructureVillagePieces.getVillageComponentFromWeightedPiece(var12, par1List, par2Random, par3, par4, par5, par6, par7);
                if (var13 == null) continue;
                ++var12.villagePiecesSpawned;
                par0ComponentVillageStartPiece.structVillagePieceWeight = var12;
                if (!var12.canSpawnMoreVillagePieces()) {
                    par0ComponentVillageStartPiece.structureVillageWeightedPieceList.remove(var12);
                }
                return var13;
            }
        }
        StructureBoundingBox var14 = ComponentVillageTorch.findValidPlacement(par1List, par2Random, par3, par4, par5, par6);
        if (var14 != null) {
            return new ComponentVillageTorch(par7, par2Random, var14, par6);
        }
        return null;
    }

    private static StructureComponent getNextVillageStructureComponent(ComponentVillageStartPiece par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 50) {
            return null;
        }
        if (Math.abs(par3 - par0ComponentVillageStartPiece.getBoundingBox().minX) > 112 || Math.abs(par5 - par0ComponentVillageStartPiece.getBoundingBox().minZ) > 112) {
            return null;
        }
        ComponentVillage componentvillage = StructureVillagePieces.getNextVillageComponent(par0ComponentVillageStartPiece, par1List, par2Random, par3, par4, par5, par6, par7 + 1);
        if (componentvillage != null) {
            int i1;
            int i = (componentvillage.boundingBox.minX + componentvillage.boundingBox.maxX) / 2;
            int j = (componentvillage.boundingBox.minZ + componentvillage.boundingBox.maxZ) / 2;
            int k = componentvillage.boundingBox.maxX - componentvillage.boundingBox.minX;
            int l = componentvillage.boundingBox.maxZ - componentvillage.boundingBox.minZ;
            int n = i1 = k <= l ? l : k;
            if (par0ComponentVillageStartPiece.getWorldChunkManager().areBiomesViable(i, j, i1 / 2 + 4, MapGenVillage.villageSpawnBiomes)) {
                par1List.add(componentvillage);
                par0ComponentVillageStartPiece.field_35108_e.add(componentvillage);
                return componentvillage;
            }
        }
        return null;
    }

    private static StructureComponent getNextComponentVillagePath(ComponentVillageStartPiece par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 3 + par0ComponentVillageStartPiece.terrainType) {
            return null;
        }
        if (Math.abs(par3 - par0ComponentVillageStartPiece.getBoundingBox().minX) > 112 || Math.abs(par5 - par0ComponentVillageStartPiece.getBoundingBox().minZ) > 112) {
            return null;
        }
        StructureBoundingBox structureboundingbox = ComponentVillagePathGen.func_35087_a(par0ComponentVillageStartPiece, par1List, par2Random, par3, par4, par5, par6);
        if (structureboundingbox != null && structureboundingbox.minY > 10) {
            int i1;
            ComponentVillagePathGen componentvillagepathgen = new ComponentVillagePathGen(par7, par2Random, structureboundingbox, par6);
            int i = (componentvillagepathgen.boundingBox.minX + componentvillagepathgen.boundingBox.maxX) / 2;
            int j = (componentvillagepathgen.boundingBox.minZ + componentvillagepathgen.boundingBox.maxZ) / 2;
            int k = componentvillagepathgen.boundingBox.maxX - componentvillagepathgen.boundingBox.minX;
            int l = componentvillagepathgen.boundingBox.maxZ - componentvillagepathgen.boundingBox.minZ;
            int n = i1 = k <= l ? l : k;
            if (par0ComponentVillageStartPiece.getWorldChunkManager().areBiomesViable(i, j, i1 / 2 + 4, MapGenVillage.villageSpawnBiomes)) {
                par1List.add(componentvillagepathgen);
                par0ComponentVillageStartPiece.field_35106_f.add(componentvillagepathgen);
                return componentvillagepathgen;
            }
        }
        return null;
    }

    static StructureComponent getNextStructureComponent(ComponentVillageStartPiece par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        return StructureVillagePieces.getNextVillageStructureComponent(par0ComponentVillageStartPiece, par1List, par2Random, par3, par4, par5, par6, par7);
    }

    static StructureComponent getNextStructureComponentVillagePath(ComponentVillageStartPiece par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        return StructureVillagePieces.getNextComponentVillagePath(par0ComponentVillageStartPiece, par1List, par2Random, par3, par4, par5, par6, par7);
    }
}

