/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.TextureFX;

public class TextureWaterFlowFX
extends TextureFX {
    protected float[] field_1138_g = new float[256];
    protected float[] field_1137_h = new float[256];
    protected float[] field_1136_i = new float[256];
    protected float[] field_1135_j = new float[256];
    private int tickCounter = 0;

    public TextureWaterFlowFX() {
        super(Block.waterMoving.blockIndexInTexture + 1);
        this.tileSize = 2;
    }

    @Override
    public void onTick() {
        ++this.tickCounter;
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                float f = 0.0f;
                for (int j1 = k - 2; j1 <= k; ++j1) {
                    int k1 = i & 0xF;
                    int i2 = j1 & 0xF;
                    f += this.field_1138_g[k1 + i2 * 16];
                }
                this.field_1137_h[i + k * 16] = f / 3.2f + this.field_1136_i[i + k * 16] * 0.8f;
            }
        }
        for (int j = 0; j < 16; ++j) {
            for (int l = 0; l < 16; ++l) {
                int n = j + l * 16;
                this.field_1136_i[n] = this.field_1136_i[n] + this.field_1135_j[j + l * 16] * 0.05f;
                if (this.field_1136_i[j + l * 16] < 0.0f) {
                    this.field_1136_i[j + l * 16] = 0.0f;
                }
                int n2 = j + l * 16;
                this.field_1135_j[n2] = this.field_1135_j[n2] - 0.3f;
                if (!(Math.random() < 0.2)) continue;
                this.field_1135_j[j + l * 16] = 0.5f;
            }
        }
        float[] af = this.field_1137_h;
        this.field_1137_h = this.field_1138_g;
        this.field_1138_g = af;
        for (int i1 = 0; i1 < 256; ++i1) {
            float f1 = this.field_1138_g[i1 - this.tickCounter * 16 & 0xFF];
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            float f2 = f1 * f1;
            int l1 = (int)(32.0f + f2 * 32.0f);
            int j2 = (int)(50.0f + f2 * 64.0f);
            int k2 = 255;
            int l2 = (int)(146.0f + f2 * 50.0f);
            if (this.anaglyphEnabled) {
                int i3 = (l1 * 30 + j2 * 59 + k2 * 11) / 100;
                int j3 = (l1 * 30 + j2 * 70) / 100;
                int k3 = (l1 * 30 + k2 * 70) / 100;
                l1 = i3;
                j2 = j3;
                k2 = k3;
            }
            this.imageData[i1 * 4 + 0] = (byte)l1;
            this.imageData[i1 * 4 + 1] = (byte)j2;
            this.imageData[i1 * 4 + 2] = (byte)k2;
            this.imageData[i1 * 4 + 3] = (byte)l2;
        }
    }
}

