/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import net.minecraft.src.GuiMultiplayer;
import net.minecraft.src.GuiSlotServer;
import net.minecraft.src.ServerNBTStorage;

class ThreadPollServers
extends Thread {
    final ServerNBTStorage server;
    final GuiSlotServer serverSlotContainer;

    ThreadPollServers(GuiSlotServer par1GuiSlotServer, ServerNBTStorage par2ServerNBTStorage) {
        this.serverSlotContainer = par1GuiSlotServer;
        this.server = par2ServerNBTStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.server.motd = "\u00a78Polling..";
            long l = System.nanoTime();
            GuiMultiplayer.pollServer(this.serverSlotContainer.parentGui, this.server);
            long l1 = System.nanoTime();
            this.server.lag = (l1 - l) / 1000000L;
        }
        catch (UnknownHostException unknownhostexception) {
            this.server.lag = -1L;
            this.server.motd = "\u00a74Can't resolve hostname";
        }
        catch (SocketTimeoutException sockettimeoutexception) {
            this.server.lag = -1L;
            this.server.motd = "\u00a74Can't reach server";
        }
        catch (ConnectException connectexception) {
            this.server.lag = -1L;
            this.server.motd = "\u00a74Can't reach server";
        }
        catch (IOException ioexception) {
            this.server.lag = -1L;
            this.server.motd = "\u00a74Communication error";
        }
        catch (Exception exception) {
            this.server.lag = -1L;
            this.server.motd = "ERROR: " + exception.getClass();
        }
        finally {
            Object unknownhostexception = GuiMultiplayer.getLock();
            synchronized (unknownhostexception) {
                GuiMultiplayer.decrementThreadsPending();
            }
        }
    }
}

