/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.TileEntity;

public class TileEntityChest
extends TileEntity
implements IInventory {
    private ItemStack[] chestContents = new ItemStack[36];
    public boolean adjacentChestChecked = false;
    public TileEntityChest adjacentChestZNeg;
    public TileEntityChest adjacentChestXPos;
    public TileEntityChest adjacentChestXNeg;
    public TileEntityChest adjacentChestZPosition;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    private int ticksSinceSync;

    @Override
    public int getSizeInventory() {
        return 27;
    }

    @Override
    public ItemStack getStackInSlot(int par1) {
        return this.chestContents[par1];
    }

    @Override
    public ItemStack decrStackSize(int par1, int par2) {
        if (this.chestContents[par1] != null) {
            if (this.chestContents[par1].stackSize <= par2) {
                ItemStack itemstack = this.chestContents[par1];
                this.chestContents[par1] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.chestContents[par1].splitStack(par2);
            if (this.chestContents[par1].stackSize == 0) {
                this.chestContents[par1] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.chestContents[par1] != null) {
            ItemStack itemstack = this.chestContents[par1];
            this.chestContents[par1] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        this.chestContents[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit()) {
            par2ItemStack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return "container.chest";
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items");
        this.chestContents = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.chestContents.length) continue;
            this.chestContents[j] = ItemStack.loadItemStackFromNBT(nbttagcompound);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i);
            this.chestContents[i].writeToNBT(nbttagcompound);
            nbttaglist.appendTag(nbttagcompound);
        }
        par1NBTTagCompound.setTag("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void updateContainingBlockInfo() {
        super.updateContainingBlockInfo();
        this.adjacentChestChecked = false;
    }

    public void checkForAdjacentChests() {
        if (this.adjacentChestChecked) {
            return;
        }
        this.adjacentChestChecked = true;
        this.adjacentChestZNeg = null;
        this.adjacentChestXPos = null;
        this.adjacentChestXNeg = null;
        this.adjacentChestZPosition = null;
        if (this.worldObj.getBlockId(this.xCoord - 1, this.yCoord, this.zCoord) == Block.chest.blockID) {
            this.adjacentChestXNeg = (TileEntityChest)this.worldObj.getBlockTileEntity(this.xCoord - 1, this.yCoord, this.zCoord);
        }
        if (this.worldObj.getBlockId(this.xCoord + 1, this.yCoord, this.zCoord) == Block.chest.blockID) {
            this.adjacentChestXPos = (TileEntityChest)this.worldObj.getBlockTileEntity(this.xCoord + 1, this.yCoord, this.zCoord);
        }
        if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord - 1) == Block.chest.blockID) {
            this.adjacentChestZNeg = (TileEntityChest)this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord - 1);
        }
        if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord + 1) == Block.chest.blockID) {
            this.adjacentChestZPosition = (TileEntityChest)this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord + 1);
        }
        if (this.adjacentChestZNeg != null) {
            this.adjacentChestZNeg.updateContainingBlockInfo();
        }
        if (this.adjacentChestZPosition != null) {
            this.adjacentChestZPosition.updateContainingBlockInfo();
        }
        if (this.adjacentChestXPos != null) {
            this.adjacentChestXPos.updateContainingBlockInfo();
        }
        if (this.adjacentChestXNeg != null) {
            this.adjacentChestXNeg.updateContainingBlockInfo();
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.checkForAdjacentChests();
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.worldObj.playNoteAt(this.xCoord, this.yCoord, this.zCoord, 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
            double d = (double)this.xCoord + 0.5;
            double d1 = (double)this.zCoord + 0.5;
            if (this.adjacentChestZPosition != null) {
                d1 += 0.5;
            }
            if (this.adjacentChestXPos != null) {
                d += 0.5;
            }
            this.worldObj.playSoundEffect(d, (double)this.yCoord + 0.5, d1, "random.chestopen", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2 && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
                double d2 = (double)this.xCoord + 0.5;
                double d3 = (double)this.zCoord + 0.5;
                if (this.adjacentChestZPosition != null) {
                    d3 += 0.5;
                }
                if (this.adjacentChestXPos != null) {
                    d2 += 0.5;
                }
                this.worldObj.playSoundEffect(d2, (double)this.yCoord + 0.5, d3, "random.chestclosed", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public void onTileEntityPowered(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
        }
    }

    @Override
    public void openChest() {
        ++this.numUsingPlayers;
        this.worldObj.playNoteAt(this.xCoord, this.yCoord, this.zCoord, 1, this.numUsingPlayers);
    }

    @Override
    public void closeChest() {
        --this.numUsingPlayers;
        this.worldObj.playNoteAt(this.xCoord, this.yCoord, this.zCoord, 1, this.numUsingPlayers);
    }

    @Override
    public void invalidate() {
        this.updateContainingBlockInfo();
        this.checkForAdjacentChests();
        super.invalidate();
    }
}

