/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class TileEntityMobSpawner
extends TileEntity {
    public int delay = 20;
    private String mobID = "Pig";
    public double yaw;
    public double yaw2 = 0.0;

    public String getMobID() {
        return this.mobID;
    }

    public void setMobID(String par1Str) {
        this.mobID = par1Str;
    }

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    @Override
    public void updateEntity() {
        this.yaw2 = this.yaw;
        if (!this.anyPlayerInRange()) {
            return;
        }
        double d = (float)this.xCoord + this.worldObj.rand.nextFloat();
        double d1 = (float)this.yCoord + this.worldObj.rand.nextFloat();
        double d2 = (float)this.zCoord + this.worldObj.rand.nextFloat();
        this.worldObj.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
        this.worldObj.spawnParticle("flame", d, d1, d2, 0.0, 0.0, 0.0);
        this.yaw += (double)(1000.0f / ((float)this.delay + 200.0f));
        while (this.yaw > 360.0) {
            this.yaw -= 360.0;
            this.yaw2 -= 360.0;
        }
        if (!this.worldObj.isRemote) {
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            int byte0 = 4;
            for (int i = 0; i < byte0; ++i) {
                EntityLiving entityliving = (EntityLiving)EntityList.createEntityByName(this.mobID, this.worldObj);
                if (entityliving == null) {
                    return;
                }
                int j = this.worldObj.getEntitiesWithinAABB(entityliving.getClass(), AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(8.0, 4.0, 8.0)).size();
                if (j >= 6) {
                    this.updateDelay();
                    return;
                }
                if (entityliving == null) continue;
                double d3 = (double)this.xCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                double d4 = this.yCoord + this.worldObj.rand.nextInt(3) - 1;
                double d5 = (double)this.zCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                entityliving.setLocationAndAngles(d3, d4, d5, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                if (!entityliving.getCanSpawnHere()) continue;
                this.worldObj.spawnEntityInWorld(entityliving);
                this.worldObj.playAuxSFX(2004, this.xCoord, this.yCoord, this.zCoord, 0);
                entityliving.spawnExplosionParticle();
                this.updateDelay();
            }
        }
        super.updateEntity();
    }

    private void updateDelay() {
        this.delay = 200 + this.worldObj.rand.nextInt(600);
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        this.mobID = par1NBTTagCompound.getString("EntityId");
        this.delay = par1NBTTagCompound.getShort("Delay");
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setString("EntityId", this.mobID);
        par1NBTTagCompound.setShort("Delay", (short)this.delay);
    }
}

