/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Material;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class TileEntityNote
extends TileEntity {
    public byte note = 0;
    public boolean previousRedstoneState = false;

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setByte("note", this.note);
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        this.note = par1NBTTagCompound.getByte("note");
        if (this.note < 0) {
            this.note = 0;
        }
        if (this.note > 24) {
            this.note = (byte)24;
        }
    }

    public void changePitch() {
        this.note = (byte)((this.note + 1) % 25);
        this.onInventoryChanged();
    }

    public void triggerNote(World par1World, int par2, int par3, int par4) {
        if (par1World.getBlockMaterial(par2, par3 + 1, par4) != Material.air) {
            return;
        }
        Material material = par1World.getBlockMaterial(par2, par3 - 1, par4);
        int byte0 = 0;
        if (material == Material.rock) {
            byte0 = 1;
        }
        if (material == Material.sand) {
            byte0 = 2;
        }
        if (material == Material.glass) {
            byte0 = 3;
        }
        if (material == Material.wood) {
            byte0 = 4;
        }
        par1World.playNoteAt(par2, par3, par4, byte0, this.note);
    }
}

