/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.Facing;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class TileEntityPiston
extends TileEntity {
    private int storedBlockID;
    private int storedMetadata;
    private int storedOrientation;
    private boolean extending;
    private boolean shouldHeadBeRendered;
    private float progress;
    private float lastProgress;
    private static List pushedObjects = new ArrayList();

    public TileEntityPiston() {
    }

    public TileEntityPiston(int par1, int par2, int par3, boolean par4, boolean par5) {
        this.storedBlockID = par1;
        this.storedMetadata = par2;
        this.storedOrientation = par3;
        this.extending = par4;
        this.shouldHeadBeRendered = par5;
    }

    public int getStoredBlockID() {
        return this.storedBlockID;
    }

    @Override
    public int getBlockMetadata() {
        return this.storedMetadata;
    }

    public boolean isExtending() {
        return this.extending;
    }

    public int getPistonOrientation() {
        return this.storedOrientation;
    }

    public boolean shouldRenderHead() {
        return this.shouldHeadBeRendered;
    }

    public float getProgress(float par1) {
        if (par1 > 1.0f) {
            par1 = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * par1;
    }

    public float getOffsetX(float par1) {
        if (this.extending) {
            return (this.getProgress(par1) - 1.0f) * (float)Facing.offsetsXForSide[this.storedOrientation];
        }
        return (1.0f - this.getProgress(par1)) * (float)Facing.offsetsXForSide[this.storedOrientation];
    }

    public float getOffsetY(float par1) {
        if (this.extending) {
            return (this.getProgress(par1) - 1.0f) * (float)Facing.offsetsYForSide[this.storedOrientation];
        }
        return (1.0f - this.getProgress(par1)) * (float)Facing.offsetsYForSide[this.storedOrientation];
    }

    public float getOffsetZ(float par1) {
        if (this.extending) {
            return (this.getProgress(par1) - 1.0f) * (float)Facing.offsetsZForSide[this.storedOrientation];
        }
        return (1.0f - this.getProgress(par1)) * (float)Facing.offsetsZForSide[this.storedOrientation];
    }

    private void updatePushedObjects(float par1, float par2) {
        List list;
        par1 = !this.extending ? (par1 -= 1.0f) : 1.0f - par1;
        AxisAlignedBB axisalignedbb = Block.pistonMoving.getAxisAlignedBB(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, par1, this.storedOrientation);
        if (axisalignedbb != null && !(list = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb)).isEmpty()) {
            pushedObjects.addAll(list);
            for (Entity entity : pushedObjects) {
                entity.moveEntity(par2 * (float)Facing.offsetsXForSide[this.storedOrientation], par2 * (float)Facing.offsetsYForSide[this.storedOrientation], par2 * (float)Facing.offsetsZForSide[this.storedOrientation]);
            }
            pushedObjects.clear();
        }
    }

    public void clearPistonTileEntity() {
        if (this.lastProgress < 1.0f && this.worldObj != null) {
            this.progress = 1.0f;
            this.lastProgress = 1.0f;
            this.worldObj.removeBlockTileEntity(this.xCoord, this.yCoord, this.zCoord);
            this.invalidate();
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.pistonMoving.blockID) {
                this.worldObj.setBlockAndMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, this.storedMetadata);
            }
        }
    }

    @Override
    public void updateEntity() {
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.updatePushedObjects(1.0f, 0.25f);
            this.worldObj.removeBlockTileEntity(this.xCoord, this.yCoord, this.zCoord);
            this.invalidate();
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.pistonMoving.blockID) {
                this.worldObj.setBlockAndMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, this.storedMetadata);
            }
            return;
        }
        this.progress += 0.5f;
        if (this.progress >= 1.0f) {
            this.progress = 1.0f;
        }
        if (this.extending) {
            this.updatePushedObjects(this.progress, this.progress - this.lastProgress + 0.0625f);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        this.storedBlockID = par1NBTTagCompound.getInteger("blockId");
        this.storedMetadata = par1NBTTagCompound.getInteger("blockData");
        this.storedOrientation = par1NBTTagCompound.getInteger("facing");
        this.lastProgress = this.progress = par1NBTTagCompound.getFloat("progress");
        this.extending = par1NBTTagCompound.getBoolean("extending");
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("blockId", this.storedBlockID);
        par1NBTTagCompound.setInteger("blockData", this.storedMetadata);
        par1NBTTagCompound.setInteger("facing", this.storedOrientation);
        par1NBTTagCompound.setFloat("progress", this.lastProgress);
        par1NBTTagCompound.setBoolean("extending", this.extending);
    }
}

