/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityIronGolem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityVillager;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.VillageAgressor;
import net.minecraft.src.VillageDoorInfo;
import net.minecraft.src.World;

public class Village {
    private final World worldObj;
    private final List villageDoorInfoList = new ArrayList();
    private final ChunkCoordinates centerHelper = new ChunkCoordinates(0, 0, 0);
    private final ChunkCoordinates center = new ChunkCoordinates(0, 0, 0);
    private int villageRadius = 0;
    private int lastAddDoorTimestamp = 0;
    private int tickCounter = 0;
    private int numVillagers = 0;
    private List villageAgressors = new ArrayList();
    private int numIronGolems = 0;

    public Village(World par1World) {
        this.worldObj = par1World;
    }

    public void tick(int par1) {
        Vec3D vec3d;
        int i;
        this.tickCounter = par1;
        this.removeDeadAndOutOfRangeDoors();
        this.removeDeadAndOldAgressors();
        if (par1 % 20 == 0) {
            this.updateNumVillagers();
        }
        if (par1 % 30 == 0) {
            this.updateNumIronGolems();
        }
        if (this.numIronGolems < (i = this.numVillagers / 16) && this.villageDoorInfoList.size() > 20 && this.worldObj.rand.nextInt(7000) == 0 && (vec3d = this.tryGetIronGolemSpawningLocation(MathHelper.floor_float(this.center.posX), MathHelper.floor_float(this.center.posY), MathHelper.floor_float(this.center.posZ), 2, 4, 2)) != null) {
            EntityIronGolem entityirongolem = new EntityIronGolem(this.worldObj);
            entityirongolem.setPosition(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            this.worldObj.spawnEntityInWorld(entityirongolem);
            ++this.numIronGolems;
        }
    }

    private Vec3D tryGetIronGolemSpawningLocation(int par1, int par2, int par3, int par4, int par5, int par6) {
        for (int i = 0; i < 10; ++i) {
            int l;
            int k;
            int j = par1 + this.worldObj.rand.nextInt(16) - 8;
            if (!this.isInRange(j, k = par2 + this.worldObj.rand.nextInt(6) - 3, l = par3 + this.worldObj.rand.nextInt(16) - 8) || !this.isValidIronGolemSpawningLocation(j, k, l, par4, par5, par6)) continue;
            return Vec3D.createVector(j, k, l);
        }
        return null;
    }

    private boolean isValidIronGolemSpawningLocation(int par1, int par2, int par3, int par4, int par5, int par6) {
        if (!this.worldObj.isBlockNormalCube(par1, par2 - 1, par3)) {
            return false;
        }
        int i = par1 - par4 / 2;
        int j = par3 - par6 / 2;
        for (int k = i; k < i + par4; ++k) {
            for (int l = par2; l < par2 + par5; ++l) {
                for (int i1 = j; i1 < j + par6; ++i1) {
                    if (!this.worldObj.isBlockNormalCube(k, l, i1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void updateNumIronGolems() {
        List list = this.worldObj.getEntitiesWithinAABB(EntityIronGolem.class, AxisAlignedBB.getBoundingBoxFromPool(this.center.posX - this.villageRadius, this.center.posY - 4, this.center.posZ - this.villageRadius, this.center.posX + this.villageRadius, this.center.posY + 4, this.center.posZ + this.villageRadius));
        this.numIronGolems = list.size();
    }

    private void updateNumVillagers() {
        List list = this.worldObj.getEntitiesWithinAABB(EntityVillager.class, AxisAlignedBB.getBoundingBoxFromPool(this.center.posX - this.villageRadius, this.center.posY - 4, this.center.posZ - this.villageRadius, this.center.posX + this.villageRadius, this.center.posY + 4, this.center.posZ + this.villageRadius));
        this.numVillagers = list.size();
    }

    public ChunkCoordinates getCenter() {
        return this.center;
    }

    public int getVillageRadius() {
        return this.villageRadius;
    }

    public int getNumVillageDoors() {
        return this.villageDoorInfoList.size();
    }

    public int getTicksSinceLastDoorAdding() {
        return this.tickCounter - this.lastAddDoorTimestamp;
    }

    public int getNumVillagers() {
        return this.numVillagers;
    }

    public boolean isInRange(int par1, int par2, int par3) {
        return this.center.getDistanceSquared(par1, par2, par3) < (float)(this.villageRadius * this.villageRadius);
    }

    public List getVillageDoorInfoList() {
        return this.villageDoorInfoList;
    }

    public VillageDoorInfo findNearestDoor(int par1, int par2, int par3) {
        VillageDoorInfo villagedoorinfo = null;
        int i = Integer.MAX_VALUE;
        for (VillageDoorInfo villagedoorinfo1 : this.villageDoorInfoList) {
            int j = villagedoorinfo1.getDistanceSquared(par1, par2, par3);
            if (j >= i) continue;
            villagedoorinfo = villagedoorinfo1;
            i = j;
        }
        return villagedoorinfo;
    }

    public VillageDoorInfo findNearestDoorUnrestricted(int par1, int par2, int par3) {
        VillageDoorInfo villagedoorinfo = null;
        int i = Integer.MAX_VALUE;
        for (VillageDoorInfo villagedoorinfo1 : this.villageDoorInfoList) {
            int j = villagedoorinfo1.getDistanceSquared(par1, par2, par3);
            j = j > 256 ? (j *= 1000) : villagedoorinfo1.getDoorOpeningRestrictionCounter();
            if (j >= i) continue;
            villagedoorinfo = villagedoorinfo1;
            i = j;
        }
        return villagedoorinfo;
    }

    public VillageDoorInfo getVillageDoorAt(int par1, int par2, int par3) {
        if (this.center.getDistanceSquared(par1, par2, par3) > (float)(this.villageRadius * this.villageRadius)) {
            return null;
        }
        for (VillageDoorInfo villagedoorinfo : this.villageDoorInfoList) {
            if (villagedoorinfo.posX != par1 || villagedoorinfo.posZ != par3 || Math.abs(villagedoorinfo.posY - par2) > 1) continue;
            return villagedoorinfo;
        }
        return null;
    }

    public void addVillageDoorInfo(VillageDoorInfo par1VillageDoorInfo) {
        this.villageDoorInfoList.add(par1VillageDoorInfo);
        this.centerHelper.posX += par1VillageDoorInfo.posX;
        this.centerHelper.posY += par1VillageDoorInfo.posY;
        this.centerHelper.posZ += par1VillageDoorInfo.posZ;
        this.updateVillageRadiusAndCenter();
        this.lastAddDoorTimestamp = par1VillageDoorInfo.lastActivityTimestamp;
    }

    public boolean isAnnihilated() {
        return this.villageDoorInfoList.isEmpty();
    }

    public void addOrRenewAgressor(EntityLiving par1EntityLiving) {
        for (VillageAgressor villageagressor : this.villageAgressors) {
            if (villageagressor.agressor != par1EntityLiving) continue;
            villageagressor.agressionTime = this.tickCounter;
            return;
        }
        this.villageAgressors.add(new VillageAgressor(this, par1EntityLiving, this.tickCounter));
    }

    public EntityLiving findNearestVillageAggressor(EntityLiving par1EntityLiving) {
        double d = Double.MAX_VALUE;
        VillageAgressor villageagressor = null;
        for (int i = 0; i < this.villageAgressors.size(); ++i) {
            VillageAgressor villageagressor1 = (VillageAgressor)this.villageAgressors.get(i);
            double d1 = villageagressor1.agressor.getDistanceSqToEntity(par1EntityLiving);
            if (!(d1 <= d)) continue;
            villageagressor = villageagressor1;
            d = d1;
        }
        return villageagressor == null ? null : villageagressor.agressor;
    }

    private void removeDeadAndOldAgressors() {
        Iterator iterator = this.villageAgressors.iterator();
        while (iterator.hasNext()) {
            VillageAgressor villageagressor = (VillageAgressor)iterator.next();
            if (villageagressor.agressor.isEntityAlive() && Math.abs(this.tickCounter - villageagressor.agressionTime) <= 300) continue;
            iterator.remove();
        }
    }

    private void removeDeadAndOutOfRangeDoors() {
        boolean flag = false;
        boolean flag1 = this.worldObj.rand.nextInt(50) == 0;
        Iterator iterator = this.villageDoorInfoList.iterator();
        while (iterator.hasNext()) {
            VillageDoorInfo villagedoorinfo = (VillageDoorInfo)iterator.next();
            if (flag1) {
                villagedoorinfo.resetDoorOpeningRestrictionCounter();
            }
            if (this.isBlockDoor(villagedoorinfo.posX, villagedoorinfo.posY, villagedoorinfo.posZ) && Math.abs(this.tickCounter - villagedoorinfo.lastActivityTimestamp) <= 1200) continue;
            this.centerHelper.posX -= villagedoorinfo.posX;
            this.centerHelper.posY -= villagedoorinfo.posY;
            this.centerHelper.posZ -= villagedoorinfo.posZ;
            flag = true;
            villagedoorinfo.isDetachedFromVillageFlag = true;
            iterator.remove();
        }
        if (flag) {
            this.updateVillageRadiusAndCenter();
        }
    }

    private boolean isBlockDoor(int par1, int par2, int par3) {
        int i = this.worldObj.getBlockId(par1, par2, par3);
        if (i <= 0) {
            return false;
        }
        return i == Block.doorWood.blockID;
    }

    private void updateVillageRadiusAndCenter() {
        int i = this.villageDoorInfoList.size();
        if (i == 0) {
            this.center.set(0, 0, 0);
            this.villageRadius = 0;
            return;
        }
        this.center.set(this.centerHelper.posX / i, this.centerHelper.posY / i, this.centerHelper.posZ / i);
        int j = 0;
        for (VillageDoorInfo villagedoorinfo : this.villageDoorInfoList) {
            j = Math.max(villagedoorinfo.getDistanceSquared(this.center.posX, this.center.posY, this.center.posZ), j);
        }
        this.villageRadius = Math.max(32, (int)Math.sqrt(j) + 1);
    }
}

