/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCache;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.ChunkProvider;
import net.minecraft.src.ChunkProviderLoadOrGenerate;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.EnumSkyBlock;
import net.minecraft.src.Explosion;
import net.minecraft.src.ExtendedBlockStorage;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.IWorldAccess;
import net.minecraft.src.MapStorage;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NextTickListEntry;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathFinder;
import net.minecraft.src.Profiler;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.SpawnerAnimals;
import net.minecraft.src.ThreadedFileIOBase;
import net.minecraft.src.TileEntity;
import net.minecraft.src.Vec3D;
import net.minecraft.src.VillageCollection;
import net.minecraft.src.VillageSiege;
import net.minecraft.src.WeightedRandom;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.WorldInfo;
import net.minecraft.src.WorldProvider;
import net.minecraft.src.WorldSavedData;
import net.minecraft.src.WorldSettings;
import net.minecraft.src.WorldType;

public class World
implements IBlockAccess {
    public boolean scheduledUpdatesAreImmediate = false;
    public List loadedEntityList = new ArrayList();
    private List unloadedEntityList = new ArrayList();
    private TreeSet scheduledTickTreeSet = new TreeSet();
    private Set scheduledTickSet = new HashSet();
    public List loadedTileEntityList = new ArrayList();
    private List addedTileEntityList = new ArrayList();
    private List entityRemoval = new ArrayList();
    public List playerEntities = new ArrayList();
    public List weatherEffects = new ArrayList();
    private long cloudColour = 0xFFFFFFL;
    public int skylightSubtracted = 0;
    protected int updateLCG = new Random().nextInt();
    protected final int DIST_HASH_MAGIC = 1013904223;
    protected float prevRainingStrength;
    protected float rainingStrength;
    protected float prevThunderingStrength;
    protected float thunderingStrength;
    protected int lastLightningBolt = 0;
    public int lightningFlash = 0;
    public boolean editingBlocks = false;
    private long lockTimestamp = System.currentTimeMillis();
    protected int autosavePeriod = 40;
    public int difficultySetting;
    public Random rand = new Random();
    public boolean isNewWorld = false;
    public final WorldProvider worldProvider;
    protected List worldAccesses = new ArrayList();
    protected IChunkProvider chunkProvider;
    protected final ISaveHandler saveHandler;
    protected WorldInfo worldInfo;
    public boolean findingSpawnPoint;
    private boolean allPlayersSleeping;
    public MapStorage mapStorage;
    public final VillageCollection villageCollectionObj = new VillageCollection(this);
    private final VillageSiege villageSiegeObj = new VillageSiege(this);
    private ArrayList collidingBoundingBoxes = new ArrayList();
    private boolean scanningTileEntities;
    protected boolean spawnHostileMobs = true;
    protected boolean spawnPeacefulMobs = true;
    protected Set activeChunkSet = new HashSet();
    private int ambientTickCountdown = this.rand.nextInt(12000);
    int[] lightUpdateBlockList = new int[32768];
    private List entitiesWithinAABBExcludingEntity = new ArrayList();
    public boolean isRemote = false;

    @Override
    public BiomeGenBase getBiomeGenForCoords(int par1, int par2) {
        Chunk chunk;
        if (this.blockExists(par1, 0, par2) && (chunk = this.getChunkFromBlockCoords(par1, par2)) != null) {
            return chunk.func_48490_a(par1 & 0xF, par2 & 0xF, this.worldProvider.worldChunkMgr);
        }
        return this.worldProvider.worldChunkMgr.getBiomeGenAt(par1, par2);
    }

    public WorldChunkManager getWorldChunkManager() {
        return this.worldProvider.worldChunkMgr;
    }

    public World(ISaveHandler par1ISaveHandler, String par2Str, WorldProvider par3WorldProvider, WorldSettings par4WorldSettings) {
        this.saveHandler = par1ISaveHandler;
        this.worldInfo = new WorldInfo(par4WorldSettings, par2Str);
        this.worldProvider = par3WorldProvider;
        this.mapStorage = new MapStorage(par1ISaveHandler);
        par3WorldProvider.registerWorld(this);
        this.chunkProvider = this.createChunkProvider();
        this.calculateInitialSkylight();
        this.calculateInitialWeather();
    }

    public World(World par1World, WorldProvider par2WorldProvider) {
        this.lockTimestamp = par1World.lockTimestamp;
        this.saveHandler = par1World.saveHandler;
        this.worldInfo = new WorldInfo(par1World.worldInfo);
        this.mapStorage = new MapStorage(this.saveHandler);
        this.worldProvider = par2WorldProvider;
        par2WorldProvider.registerWorld(this);
        this.chunkProvider = this.createChunkProvider();
        this.calculateInitialSkylight();
        this.calculateInitialWeather();
    }

    public World(ISaveHandler par1ISaveHandler, String par2Str, WorldSettings par3WorldSettings) {
        this(par1ISaveHandler, par2Str, par3WorldSettings, (WorldProvider)null);
    }

    public World(ISaveHandler par1ISaveHandler, String par2Str, WorldSettings par3WorldSettings, WorldProvider par4WorldProvider) {
        this.saveHandler = par1ISaveHandler;
        this.mapStorage = new MapStorage(par1ISaveHandler);
        this.worldInfo = par1ISaveHandler.loadWorldInfo();
        boolean bl = this.isNewWorld = this.worldInfo == null;
        this.worldProvider = par4WorldProvider != null ? par4WorldProvider : (this.worldInfo != null && this.worldInfo.getDimension() != 0 ? WorldProvider.getProviderForDimension(this.worldInfo.getDimension()) : WorldProvider.getProviderForDimension(0));
        boolean flag = false;
        if (this.worldInfo == null) {
            this.worldInfo = new WorldInfo(par3WorldSettings, par2Str);
            flag = true;
        } else {
            this.worldInfo.setWorldName(par2Str);
        }
        this.worldProvider.registerWorld(this);
        this.chunkProvider = this.createChunkProvider();
        if (flag) {
            this.generateSpawnPoint();
        }
        this.calculateInitialSkylight();
        this.calculateInitialWeather();
    }

    protected IChunkProvider createChunkProvider() {
        IChunkLoader ichunkloader = this.saveHandler.getChunkLoader(this.worldProvider);
        return new ChunkProvider(this, ichunkloader, this.worldProvider.getChunkProvider());
    }

    protected void generateSpawnPoint() {
        if (!this.worldProvider.canRespawnHere()) {
            this.worldInfo.setSpawnPosition(0, this.worldProvider.getAverageGroundLevel(), 0);
            return;
        }
        this.findingSpawnPoint = true;
        WorldChunkManager worldchunkmanager = this.worldProvider.worldChunkMgr;
        List list = worldchunkmanager.getBiomesToSpawnIn();
        Random random = new Random(this.getSeed());
        ChunkPosition chunkposition = worldchunkmanager.findBiomePosition(0, 0, 256, list, random);
        int i = 0;
        int j = this.worldProvider.getAverageGroundLevel();
        int k = 0;
        if (chunkposition != null) {
            i = chunkposition.x;
            k = chunkposition.z;
        } else {
            System.out.println("Unable to find spawn biome");
        }
        int l = 0;
        while (!this.worldProvider.canCoordinateBeSpawn(i, k)) {
            i += random.nextInt(64) - random.nextInt(64);
            k += random.nextInt(64) - random.nextInt(64);
            if (++l != 1000) continue;
        }
        this.worldInfo.setSpawnPosition(i, j, k);
        this.findingSpawnPoint = false;
    }

    public ChunkCoordinates getEntrancePortalLocation() {
        return this.worldProvider.getEntrancePortalLocation();
    }

    public void setSpawnLocation() {
        if (this.worldInfo.getSpawnY() <= 0) {
            this.worldInfo.setSpawnY(64);
        }
        int i = this.worldInfo.getSpawnX();
        int j = this.worldInfo.getSpawnZ();
        int k = 0;
        while (this.getFirstUncoveredBlock(i, j) == 0) {
            i += this.rand.nextInt(8) - this.rand.nextInt(8);
            j += this.rand.nextInt(8) - this.rand.nextInt(8);
            if (++k != 10000) continue;
        }
        this.worldInfo.setSpawnX(i);
        this.worldInfo.setSpawnZ(j);
    }

    public int getFirstUncoveredBlock(int par1, int par2) {
        int i = 63;
        while (!this.isAirBlock(par1, i + 1, par2)) {
            ++i;
        }
        return this.getBlockId(par1, i, par2);
    }

    public void func_6464_c() {
    }

    public void spawnPlayerWithLoadedChunks(EntityPlayer par1EntityPlayer) {
        try {
            NBTTagCompound nbttagcompound = this.worldInfo.getPlayerNBTTagCompound();
            if (nbttagcompound != null) {
                par1EntityPlayer.readFromNBT(nbttagcompound);
                this.worldInfo.setPlayerNBTTagCompound(null);
            }
            if (this.chunkProvider instanceof ChunkProviderLoadOrGenerate) {
                ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)this.chunkProvider;
                int i = MathHelper.floor_float((int)par1EntityPlayer.posX) >> 4;
                int j = MathHelper.floor_float((int)par1EntityPlayer.posZ) >> 4;
                chunkproviderloadorgenerate.setCurrentChunkOver(i, j);
            }
            this.spawnEntityInWorld(par1EntityPlayer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveWorld(boolean par1, IProgressUpdate par2IProgressUpdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (par2IProgressUpdate != null) {
            par2IProgressUpdate.displaySavingString("Saving level");
        }
        this.saveLevel();
        if (par2IProgressUpdate != null) {
            par2IProgressUpdate.displayLoadingString("Saving chunks");
        }
        this.chunkProvider.saveChunks(par1, par2IProgressUpdate);
    }

    private void saveLevel() {
        this.checkSessionLock();
        this.saveHandler.saveWorldInfoAndPlayer(this.worldInfo, this.playerEntities);
        this.mapStorage.saveAllData();
    }

    public boolean quickSaveWorld(int par1) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (par1 == 0) {
            this.saveLevel();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    @Override
    public int getBlockId(int par1, int par2, int par3) {
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return 0;
        }
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            return 0;
        }
        return this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4).getBlockID(par1 & 0xF, par2, par3 & 0xF);
    }

    public int func_48462_d(int par1, int par2, int par3) {
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return 0;
        }
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            return 0;
        }
        return this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4).getBlockLightOpacity(par1 & 0xF, par2, par3 & 0xF);
    }

    @Override
    public boolean isAirBlock(int par1, int par2, int par3) {
        return this.getBlockId(par1, par2, par3) == 0;
    }

    public boolean blockExists(int par1, int par2, int par3) {
        if (par2 < 0 || par2 >= 256) {
            return false;
        }
        return this.chunkExists(par1 >> 4, par3 >> 4);
    }

    public boolean doChunksNearChunkExist(int par1, int par2, int par3, int par4) {
        return this.checkChunksExist(par1 - par4, par2 - par4, par3 - par4, par1 + par4, par2 + par4, par3 + par4);
    }

    public boolean checkChunksExist(int par1, int par2, int par3, int par4, int par5, int par6) {
        if (par5 < 0 || par2 >= 256) {
            return false;
        }
        par3 >>= 4;
        par4 >>= 4;
        par6 >>= 4;
        for (int i = par1 >>= 4; i <= par4; ++i) {
            for (int j = par3; j <= par6; ++j) {
                if (this.chunkExists(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean chunkExists(int par1, int par2) {
        return this.chunkProvider.chunkExists(par1, par2);
    }

    public Chunk getChunkFromBlockCoords(int par1, int par2) {
        return this.getChunkFromChunkCoords(par1 >> 4, par2 >> 4);
    }

    public Chunk getChunkFromChunkCoords(int par1, int par2) {
        return this.chunkProvider.provideChunk(par1, par2);
    }

    public boolean setBlockAndMetadata(int par1, int par2, int par3, int par4, int par5) {
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return false;
        }
        if (par2 < 0) {
            return false;
        }
        if (par2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4);
        boolean flag = chunk.setBlockIDWithMetadata(par1 & 0xF, par2, par3 & 0xF, par4, par5);
        Profiler.startSection("checkLight");
        this.updateAllLightTypes(par1, par2, par3);
        Profiler.endSection();
        return flag;
    }

    public boolean setBlock(int par1, int par2, int par3, int par4) {
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return false;
        }
        if (par2 < 0) {
            return false;
        }
        if (par2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4);
        boolean flag = chunk.setBlockID(par1 & 0xF, par2, par3 & 0xF, par4);
        Profiler.startSection("checkLight");
        this.updateAllLightTypes(par1, par2, par3);
        Profiler.endSection();
        return flag;
    }

    @Override
    public Material getBlockMaterial(int par1, int par2, int par3) {
        int i = this.getBlockId(par1, par2, par3);
        if (i == 0) {
            return Material.air;
        }
        return Block.blocksList[i].blockMaterial;
    }

    @Override
    public int getBlockMetadata(int par1, int par2, int par3) {
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return 0;
        }
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4);
        return chunk.getBlockMetadata(par1 &= 0xF, par2, par3 &= 0xF);
    }

    public void setBlockMetadataWithNotify(int par1, int par2, int par3, int par4) {
        if (this.setBlockMetadata(par1, par2, par3, par4)) {
            int i = this.getBlockId(par1, par2, par3);
            if (Block.requiresSelfNotify[i & 0xFFF]) {
                this.notifyBlockChange(par1, par2, par3, i);
            } else {
                this.notifyBlocksOfNeighborChange(par1, par2, par3, i);
            }
        }
    }

    public boolean setBlockMetadata(int par1, int par2, int par3, int par4) {
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return false;
        }
        if (par2 < 0) {
            return false;
        }
        if (par2 >= 256) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4);
        return chunk.setBlockMetadata(par1 &= 0xF, par2, par3 &= 0xF, par4);
    }

    public boolean setBlockWithNotify(int par1, int par2, int par3, int par4) {
        if (this.setBlock(par1, par2, par3, par4)) {
            this.notifyBlockChange(par1, par2, par3, par4);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int par1, int par2, int par3, int par4, int par5) {
        if (this.setBlockAndMetadata(par1, par2, par3, par4, par5)) {
            this.notifyBlockChange(par1, par2, par3, par4);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int par1, int par2, int par3) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).markBlockNeedsUpdate(par1, par2, par3);
        }
    }

    public void notifyBlockChange(int par1, int par2, int par3, int par4) {
        this.markBlockNeedsUpdate(par1, par2, par3);
        this.notifyBlocksOfNeighborChange(par1, par2, par3, par4);
    }

    public void markBlocksDirtyVertical(int par1, int par2, int par3, int par4) {
        if (par3 > par4) {
            int i = par4;
            par4 = par3;
            par3 = i;
        }
        if (!this.worldProvider.hasNoSky) {
            for (int j = par3; j <= par4; ++j) {
                this.updateLightByType(EnumSkyBlock.Sky, par1, j, par2);
            }
        }
        this.markBlocksDirty(par1, par3, par2, par1, par4, par2);
    }

    public void markBlockAsNeedsUpdate(int par1, int par2, int par3) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).markBlockRangeNeedsUpdate(par1, par2, par3, par1, par2, par3);
        }
    }

    public void markBlocksDirty(int par1, int par2, int par3, int par4, int par5, int par6) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).markBlockRangeNeedsUpdate(par1, par2, par3, par4, par5, par6);
        }
    }

    public void notifyBlocksOfNeighborChange(int par1, int par2, int par3, int par4) {
        this.notifyBlockOfNeighborChange(par1 - 1, par2, par3, par4);
        this.notifyBlockOfNeighborChange(par1 + 1, par2, par3, par4);
        this.notifyBlockOfNeighborChange(par1, par2 - 1, par3, par4);
        this.notifyBlockOfNeighborChange(par1, par2 + 1, par3, par4);
        this.notifyBlockOfNeighborChange(par1, par2, par3 - 1, par4);
        this.notifyBlockOfNeighborChange(par1, par2, par3 + 1, par4);
    }

    private void notifyBlockOfNeighborChange(int par1, int par2, int par3, int par4) {
        if (this.editingBlocks || this.isRemote) {
            return;
        }
        Block block = Block.blocksList[this.getBlockId(par1, par2, par3)];
        if (block != null) {
            block.onNeighborBlockChange(this, par1, par2, par3, par4);
        }
    }

    public boolean canBlockSeeTheSky(int par1, int par2, int par3) {
        return this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4).canBlockSeeTheSky(par1 & 0xF, par2, par3 & 0xF);
    }

    public int getFullBlockLightValue(int par1, int par2, int par3) {
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            par2 = 255;
        }
        return this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4).getBlockLightValue(par1 & 0xF, par2, par3 & 0xF, 0);
    }

    public int getBlockLightValue(int par1, int par2, int par3) {
        return this.getBlockLightValue_do(par1, par2, par3, true);
    }

    public int getBlockLightValue_do(int par1, int par2, int par3, boolean par4) {
        int i;
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return 15;
        }
        if (par4 && ((i = this.getBlockId(par1, par2, par3)) == Block.stairSingle.blockID || i == Block.tilledField.blockID || i == Block.stairCompactCobblestone.blockID || i == Block.stairCompactPlanks.blockID)) {
            int j = this.getBlockLightValue_do(par1, par2 + 1, par3, false);
            int k = this.getBlockLightValue_do(par1 + 1, par2, par3, false);
            int l = this.getBlockLightValue_do(par1 - 1, par2, par3, false);
            int i1 = this.getBlockLightValue_do(par1, par2, par3 + 1, false);
            int j1 = this.getBlockLightValue_do(par1, par2, par3 - 1, false);
            if (k > j) {
                j = k;
            }
            if (l > j) {
                j = l;
            }
            if (i1 > j) {
                j = i1;
            }
            if (j1 > j) {
                j = j1;
            }
            return j;
        }
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            par2 = 255;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4);
        return chunk.getBlockLightValue(par1 &= 0xF, par2, par3 &= 0xF, this.skylightSubtracted);
    }

    public int getHeightValue(int par1, int par2) {
        if (par1 < -30000000 || par2 < -30000000 || par1 >= 30000000 || par2 >= 30000000) {
            return 0;
        }
        if (!this.chunkExists(par1 >> 4, par2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par2 >> 4);
        return chunk.getHeightValue(par1 & 0xF, par2 & 0xF);
    }

    public int getSkyBlockTypeBrightness(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (this.worldProvider.hasNoSky && par1EnumSkyBlock == EnumSkyBlock.Sky) {
            return 0;
        }
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        if (par2 < -30000000 || par4 < -30000000 || par2 >= 30000000 || par4 >= 30000000) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        int i = par2 >> 4;
        int j = par4 >> 4;
        if (!this.chunkExists(i, j)) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        if (Block.useNeighborBrightness[this.getBlockId(par2, par3, par4)]) {
            int k = this.getSavedLightValue(par1EnumSkyBlock, par2, par3 + 1, par4);
            int l = this.getSavedLightValue(par1EnumSkyBlock, par2 + 1, par3, par4);
            int i1 = this.getSavedLightValue(par1EnumSkyBlock, par2 - 1, par3, par4);
            int j1 = this.getSavedLightValue(par1EnumSkyBlock, par2, par3, par4 + 1);
            int k1 = this.getSavedLightValue(par1EnumSkyBlock, par2, par3, par4 - 1);
            if (l > k) {
                k = l;
            }
            if (i1 > k) {
                k = i1;
            }
            if (j1 > k) {
                k = j1;
            }
            if (k1 > k) {
                k = k1;
            }
            return k;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i, j);
        return chunk.getSavedLightValue(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
    }

    public int getSavedLightValue(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            par3 = 255;
        }
        if (par2 < -30000000 || par4 < -30000000 || par2 >= 30000000 || par4 >= 30000000) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        int i = par2 >> 4;
        int j = par4 >> 4;
        if (!this.chunkExists(i, j)) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i, j);
        return chunk.getSavedLightValue(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
    }

    public void setLightValue(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4, int par5) {
        if (par2 < -30000000 || par4 < -30000000 || par2 >= 30000000 || par4 >= 30000000) {
            return;
        }
        if (par3 < 0) {
            return;
        }
        if (par3 >= 256) {
            return;
        }
        if (!this.chunkExists(par2 >> 4, par4 >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par2 >> 4, par4 >> 4);
        chunk.setLightValue(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF, par5);
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).markBlockNeedsUpdate2(par2, par3, par4);
        }
    }

    public void func_48464_p(int par1, int par2, int par3) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).markBlockNeedsUpdate2(par1, par2, par3);
        }
    }

    @Override
    public int getLightBrightnessForSkyBlocks(int par1, int par2, int par3, int par4) {
        int i = this.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, par1, par2, par3);
        int j = this.getSkyBlockTypeBrightness(EnumSkyBlock.Block, par1, par2, par3);
        if (j < par4) {
            j = par4;
        }
        return i << 20 | j << 4;
    }

    @Override
    public float getBrightness(int par1, int par2, int par3, int par4) {
        int i = this.getBlockLightValue(par1, par2, par3);
        if (i < par4) {
            i = par4;
        }
        return this.worldProvider.lightBrightnessTable[i];
    }

    @Override
    public float getLightBrightness(int par1, int par2, int par3) {
        return this.worldProvider.lightBrightnessTable[this.getBlockLightValue(par1, par2, par3)];
    }

    public boolean isDaytime() {
        return this.skylightSubtracted < 4;
    }

    public MovingObjectPosition rayTraceBlocks(Vec3D par1Vec3D, Vec3D par2Vec3D) {
        return this.rayTraceBlocks_do_do(par1Vec3D, par2Vec3D, false, false);
    }

    public MovingObjectPosition rayTraceBlocks_do(Vec3D par1Vec3D, Vec3D par2Vec3D, boolean par3) {
        return this.rayTraceBlocks_do_do(par1Vec3D, par2Vec3D, par3, false);
    }

    public MovingObjectPosition rayTraceBlocks_do_do(Vec3D par1Vec3D, Vec3D par2Vec3D, boolean par3, boolean par4) {
        MovingObjectPosition movingobjectposition;
        if (Double.isNaN(par1Vec3D.xCoord) || Double.isNaN(par1Vec3D.yCoord) || Double.isNaN(par1Vec3D.zCoord)) {
            return null;
        }
        if (Double.isNaN(par2Vec3D.xCoord) || Double.isNaN(par2Vec3D.yCoord) || Double.isNaN(par2Vec3D.zCoord)) {
            return null;
        }
        int i = MathHelper.floor_double(par2Vec3D.xCoord);
        int j = MathHelper.floor_double(par2Vec3D.yCoord);
        int k = MathHelper.floor_double(par2Vec3D.zCoord);
        int l = MathHelper.floor_double(par1Vec3D.xCoord);
        int i1 = MathHelper.floor_double(par1Vec3D.yCoord);
        int j1 = MathHelper.floor_double(par1Vec3D.zCoord);
        int k1 = this.getBlockId(l, i1, j1);
        int i2 = this.getBlockMetadata(l, i1, j1);
        Block block = Block.blocksList[k1];
        if ((!par4 || block == null || block.getCollisionBoundingBoxFromPool(this, l, i1, j1) != null) && k1 > 0 && block.canCollideCheck(i2, par3) && (movingobjectposition = block.collisionRayTrace(this, l, i1, j1, par1Vec3D, par2Vec3D)) != null) {
            return movingobjectposition;
        }
        int l1 = 200;
        while (l1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            if (Double.isNaN(par1Vec3D.xCoord) || Double.isNaN(par1Vec3D.yCoord) || Double.isNaN(par1Vec3D.zCoord)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            boolean flag = true;
            boolean flag1 = true;
            boolean flag2 = true;
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d = (double)l + 1.0;
            } else if (i < l) {
                d = (double)l + 0.0;
            } else {
                flag = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag1 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag2 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = par2Vec3D.xCoord - par1Vec3D.xCoord;
            double d7 = par2Vec3D.yCoord - par1Vec3D.yCoord;
            double d8 = par2Vec3D.zCoord - par1Vec3D.zCoord;
            if (flag) {
                d3 = (d - par1Vec3D.xCoord) / d6;
            }
            if (flag1) {
                d4 = (d1 - par1Vec3D.yCoord) / d7;
            }
            if (flag2) {
                d5 = (d2 - par1Vec3D.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i > l ? 4 : 5;
                par1Vec3D.xCoord = d;
                par1Vec3D.yCoord += d7 * d3;
                par1Vec3D.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j > i1 ? 0 : 1;
                par1Vec3D.xCoord += d6 * d4;
                par1Vec3D.yCoord = d1;
                par1Vec3D.zCoord += d8 * d4;
            } else {
                byte0 = k > j1 ? 2 : 3;
                par1Vec3D.xCoord += d6 * d5;
                par1Vec3D.yCoord += d7 * d5;
                par1Vec3D.zCoord = d2;
            }
            Vec3D vec3d = Vec3D.createVector(par1Vec3D.xCoord, par1Vec3D.yCoord, par1Vec3D.zCoord);
            vec3d.xCoord = MathHelper.floor_double(par1Vec3D.xCoord);
            l = (int)vec3d.xCoord;
            if (byte0 == 5) {
                --l;
                vec3d.xCoord += 1.0;
            }
            vec3d.yCoord = MathHelper.floor_double(par1Vec3D.yCoord);
            i1 = (int)vec3d.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d.yCoord += 1.0;
            }
            vec3d.zCoord = MathHelper.floor_double(par1Vec3D.zCoord);
            j1 = (int)vec3d.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d.zCoord += 1.0;
            }
            int j2 = this.getBlockId(l, i1, j1);
            int k2 = this.getBlockMetadata(l, i1, j1);
            Block block1 = Block.blocksList[j2];
            if (par4 && block1 != null && block1.getCollisionBoundingBoxFromPool(this, l, i1, j1) == null || j2 <= 0 || !block1.canCollideCheck(k2, par3) || (movingobjectposition1 = block1.collisionRayTrace(this, l, i1, j1, par1Vec3D, par2Vec3D)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public void playSoundAtEntity(Entity par1Entity, String par2Str, float par3, float par4) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).playSound(par2Str, par1Entity.posX, par1Entity.posY - (double)par1Entity.yOffset, par1Entity.posZ, par3, par4);
        }
    }

    public void playSoundEffect(double par1, double par3, double par5, String par7Str, float par8, float par9) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).playSound(par7Str, par1, par3, par5, par8, par9);
        }
    }

    public void playRecord(String par1Str, int par2, int par3, int par4) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).playRecord(par1Str, par2, par3, par4);
        }
    }

    public void spawnParticle(String par1Str, double par2, double par4, double par6, double par8, double par10, double par12) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).spawnParticle(par1Str, par2, par4, par6, par8, par10, par12);
        }
    }

    public boolean addWeatherEffect(Entity par1Entity) {
        this.weatherEffects.add(par1Entity);
        return true;
    }

    public boolean spawnEntityInWorld(Entity par1Entity) {
        int i = MathHelper.floor_double(par1Entity.posX / 16.0);
        int j = MathHelper.floor_double(par1Entity.posZ / 16.0);
        boolean flag = false;
        if (par1Entity instanceof EntityPlayer) {
            flag = true;
        }
        if (flag || this.chunkExists(i, j)) {
            if (par1Entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)par1Entity;
                this.playerEntities.add(entityplayer);
                this.updateAllPlayersSleepingFlag();
            }
            this.getChunkFromChunkCoords(i, j).addEntity(par1Entity);
            this.loadedEntityList.add(par1Entity);
            this.obtainEntitySkin(par1Entity);
            return true;
        }
        return false;
    }

    protected void obtainEntitySkin(Entity par1Entity) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).obtainEntitySkin(par1Entity);
        }
    }

    protected void releaseEntitySkin(Entity par1Entity) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).releaseEntitySkin(par1Entity);
        }
    }

    public void setEntityDead(Entity par1Entity) {
        if (par1Entity.riddenByEntity != null) {
            par1Entity.riddenByEntity.mountEntity(null);
        }
        if (par1Entity.ridingEntity != null) {
            par1Entity.mountEntity(null);
        }
        par1Entity.setDead();
        if (par1Entity instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)par1Entity);
            this.updateAllPlayersSleepingFlag();
        }
    }

    public void addWorldAccess(IWorldAccess par1IWorldAccess) {
        this.worldAccesses.add(par1IWorldAccess);
    }

    public void removeWorldAccess(IWorldAccess par1IWorldAccess) {
        this.worldAccesses.remove(par1IWorldAccess);
    }

    public List getCollidingBoundingBoxes(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB) {
        this.collidingBoundingBoxes.clear();
        int i = MathHelper.floor_double(par2AxisAlignedBB.minX);
        int j = MathHelper.floor_double(par2AxisAlignedBB.maxX + 1.0);
        int k = MathHelper.floor_double(par2AxisAlignedBB.minY);
        int l = MathHelper.floor_double(par2AxisAlignedBB.maxY + 1.0);
        int i1 = MathHelper.floor_double(par2AxisAlignedBB.minZ);
        int j1 = MathHelper.floor_double(par2AxisAlignedBB.maxZ + 1.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.blockExists(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, i2, l1)];
                    if (block == null) continue;
                    block.getCollidingBoundingBoxes(this, k1, i2, l1, par2AxisAlignedBB, this.collidingBoundingBoxes);
                }
            }
        }
        double d = 0.25;
        List list = this.getEntitiesWithinAABBExcludingEntity(par1Entity, par2AxisAlignedBB.expand(d, d, d));
        for (int j2 = 0; j2 < list.size(); ++j2) {
            AxisAlignedBB axisalignedbb = ((Entity)list.get(j2)).getBoundingBox();
            if (axisalignedbb != null && axisalignedbb.intersectsWith(par2AxisAlignedBB)) {
                this.collidingBoundingBoxes.add(axisalignedbb);
            }
            if ((axisalignedbb = par1Entity.getCollisionBox((Entity)list.get(j2))) == null || !axisalignedbb.intersectsWith(par2AxisAlignedBB)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb);
        }
        return this.collidingBoundingBoxes;
    }

    public int calculateSkylightSubtracted(float par1) {
        float f = this.getCelestialAngle(par1);
        float f1 = 1.0f - (MathHelper.cos(f * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.getRainStrength(par1) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.getWeightedThunderStrength(par1) * 5.0f) / 16.0));
        f1 = 1.0f - f1;
        return (int)(f1 * 11.0f);
    }

    public float func_35464_b(float par1) {
        float f = this.getCelestialAngle(par1);
        float f1 = 1.0f - (MathHelper.cos(f * (float)Math.PI * 2.0f) * 2.0f + 0.2f);
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.getRainStrength(par1) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.getWeightedThunderStrength(par1) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    public Vec3D getSkyColor(Entity par1Entity, float par2) {
        float f8;
        float f = this.getCelestialAngle(par2);
        float f1 = MathHelper.cos(f * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = MathHelper.floor_double(par1Entity.posX);
        int j = MathHelper.floor_double(par1Entity.posZ);
        BiomeGenBase biomegenbase = this.getBiomeGenForCoords(i, j);
        float f2 = biomegenbase.getFloatTemperature();
        int k = biomegenbase.getSkyColorByTemp(f2);
        float f3 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(k & 0xFF) / 255.0f;
        f3 *= f1;
        f4 *= f1;
        f5 *= f1;
        float f6 = this.getRainStrength(par2);
        if (f6 > 0.0f) {
            float f7 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.6f;
            float f9 = 1.0f - f6 * 0.75f;
            f3 = f3 * f9 + f7 * (1.0f - f9);
            f4 = f4 * f9 + f7 * (1.0f - f9);
            f5 = f5 * f9 + f7 * (1.0f - f9);
        }
        if ((f8 = this.getWeightedThunderStrength(par2)) > 0.0f) {
            float f10 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.2f;
            float f12 = 1.0f - f8 * 0.75f;
            f3 = f3 * f12 + f10 * (1.0f - f12);
            f4 = f4 * f12 + f10 * (1.0f - f12);
            f5 = f5 * f12 + f10 * (1.0f - f12);
        }
        if (this.lightningFlash > 0) {
            float f11 = (float)this.lightningFlash - par2;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f3 = f3 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + 0.8f * f11;
            f5 = f5 * (1.0f - f11) + 1.0f * f11;
        }
        return Vec3D.createVector(f3, f4, f5);
    }

    public float getCelestialAngle(float par1) {
        return this.worldProvider.calculateCelestialAngle(this.worldInfo.getWorldTime(), par1);
    }

    public int getMoonPhase(float par1) {
        return this.worldProvider.getMoonPhase(this.worldInfo.getWorldTime(), par1);
    }

    public float getCelestialAngleRadians(float par1) {
        float f = this.getCelestialAngle(par1);
        return f * (float)Math.PI * 2.0f;
    }

    public Vec3D drawClouds(float par1) {
        float f = this.getCelestialAngle(par1);
        float f1 = MathHelper.cos(f * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        float f2 = (float)(this.cloudColour >> 16 & 0xFFL) / 255.0f;
        float f3 = (float)(this.cloudColour >> 8 & 0xFFL) / 255.0f;
        float f4 = (float)(this.cloudColour & 0xFFL) / 255.0f;
        float f5 = this.getRainStrength(par1);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f8 = 1.0f - f5 * 0.95f;
            f2 = f2 * f8 + f6 * (1.0f - f8);
            f3 = f3 * f8 + f6 * (1.0f - f8);
            f4 = f4 * f8 + f6 * (1.0f - f8);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f7 = this.getWeightedThunderStrength(par1);
        if (f7 > 0.0f) {
            float f9 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f10 = 1.0f - f7 * 0.95f;
            f2 = f2 * f10 + f9 * (1.0f - f10);
            f3 = f3 * f10 + f9 * (1.0f - f10);
            f4 = f4 * f10 + f9 * (1.0f - f10);
        }
        return Vec3D.createVector(f2, f3, f4);
    }

    public Vec3D getFogColor(float par1) {
        float f = this.getCelestialAngle(par1);
        return this.worldProvider.getFogColor(f, par1);
    }

    public int getPrecipitationHeight(int par1, int par2) {
        return this.getChunkFromBlockCoords(par1, par2).getPrecipitationHeight(par1 & 0xF, par2 & 0xF);
    }

    public int getTopSolidOrLiquidBlock(int par1, int par2) {
        Chunk chunk = this.getChunkFromBlockCoords(par1, par2);
        par1 &= 0xF;
        par2 &= 0xF;
        for (int i = chunk.getTopFilledSegment() + 16; i > 0; --i) {
            int j = chunk.getBlockID(par1, i, par2);
            if (j == 0 || !Block.blocksList[j].blockMaterial.blocksMovement() || Block.blocksList[j].blockMaterial == Material.leaves) {
                continue;
            }
            return i + 1;
        }
        return -1;
    }

    public float getStarBrightness(float par1) {
        float f = this.getCelestialAngle(par1);
        float f1 = 1.0f - (MathHelper.cos(f * (float)Math.PI * 2.0f) * 2.0f + 0.75f);
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        return f1 * f1 * 0.5f;
    }

    public void scheduleBlockUpdate(int par1, int par2, int par3, int par4, int par5) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(par1, par2, par3, par4);
        int byte0 = 8;
        if (this.scheduledUpdatesAreImmediate) {
            int i;
            if (this.checkChunksExist(nextticklistentry.xCoord - byte0, nextticklistentry.yCoord - byte0, nextticklistentry.zCoord - byte0, nextticklistentry.xCoord + byte0, nextticklistentry.yCoord + byte0, nextticklistentry.zCoord + byte0) && (i = this.getBlockId(nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord)) == nextticklistentry.blockID && i > 0) {
                Block.blocksList[i].updateTick(this, nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord, this.rand);
            }
            return;
        }
        if (this.checkChunksExist(par1 - byte0, par2 - byte0, par3 - byte0, par1 + byte0, par2 + byte0, par3 + byte0)) {
            if (par4 > 0) {
                nextticklistentry.setScheduledTime((long)par5 + this.worldInfo.getWorldTime());
            }
            if (!this.scheduledTickSet.contains(nextticklistentry)) {
                this.scheduledTickSet.add(nextticklistentry);
                this.scheduledTickTreeSet.add(nextticklistentry);
            }
        }
    }

    public void scheduleBlockUpdateFromLoad(int par1, int par2, int par3, int par4, int par5) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(par1, par2, par3, par4);
        if (par4 > 0) {
            nextticklistentry.setScheduledTime((long)par5 + this.worldInfo.getWorldTime());
        }
        if (!this.scheduledTickSet.contains(nextticklistentry)) {
            this.scheduledTickSet.add(nextticklistentry);
            this.scheduledTickTreeSet.add(nextticklistentry);
        }
    }

    public void updateEntities() {
        Profiler.startSection("entities");
        Profiler.startSection("global");
        for (int i = 0; i < this.weatherEffects.size(); ++i) {
            Entity entity = (Entity)this.weatherEffects.get(i);
            entity.onUpdate();
            if (!entity.isDead) continue;
            this.weatherEffects.remove(i--);
        }
        Profiler.endStartSection("remove");
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int j = 0; j < this.unloadedEntityList.size(); ++j) {
            Entity entity1 = (Entity)this.unloadedEntityList.get(j);
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (!entity1.addedToChunk || !this.chunkExists(i1, k1)) continue;
            this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
        }
        for (int k = 0; k < this.unloadedEntityList.size(); ++k) {
            this.releaseEntitySkin((Entity)this.unloadedEntityList.get(k));
        }
        this.unloadedEntityList.clear();
        Profiler.endStartSection("regular");
        for (int l = 0; l < this.loadedEntityList.size(); ++l) {
            Entity entity2 = (Entity)this.loadedEntityList.get(l);
            if (entity2.ridingEntity != null) {
                if (!entity2.ridingEntity.isDead && entity2.ridingEntity.riddenByEntity == entity2) continue;
                entity2.ridingEntity.riddenByEntity = null;
                entity2.ridingEntity = null;
            }
            if (!entity2.isDead) {
                this.updateEntity(entity2);
            }
            Profiler.startSection("remove");
            if (entity2.isDead) {
                int j1 = entity2.chunkCoordX;
                int l1 = entity2.chunkCoordZ;
                if (entity2.addedToChunk && this.chunkExists(j1, l1)) {
                    this.getChunkFromChunkCoords(j1, l1).removeEntity(entity2);
                }
                this.loadedEntityList.remove(l--);
                this.releaseEntitySkin(entity2);
            }
            Profiler.endSection();
        }
        Profiler.endStartSection("tileEntities");
        this.scanningTileEntities = true;
        Iterator iterator = this.loadedTileEntityList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            TileEntity tileentity = (TileEntity)iterator.next();
            if (!tileentity.isInvalid() && tileentity.worldObj != null && this.blockExists(tileentity.xCoord, tileentity.yCoord, tileentity.zCoord)) {
                tileentity.updateEntity();
            }
            if (!tileentity.isInvalid()) continue;
            iterator.remove();
            if (!this.chunkExists(tileentity.xCoord >> 4, tileentity.zCoord >> 4) || (chunk = this.getChunkFromChunkCoords(tileentity.xCoord >> 4, tileentity.zCoord >> 4)) == null) continue;
            chunk.removeChunkBlockTileEntity(tileentity.xCoord & 0xF, tileentity.yCoord, tileentity.zCoord & 0xF);
        }
        this.scanningTileEntities = false;
        if (!this.entityRemoval.isEmpty()) {
            this.loadedTileEntityList.removeAll(this.entityRemoval);
            this.entityRemoval.clear();
        }
        Profiler.endStartSection("pendingTileEntities");
        if (!this.addedTileEntityList.isEmpty()) {
            for (TileEntity tileentity1 : this.addedTileEntityList) {
                Chunk chunk1;
                if (tileentity1.isInvalid()) continue;
                if (!this.loadedTileEntityList.contains(tileentity1)) {
                    this.loadedTileEntityList.add(tileentity1);
                }
                if (this.chunkExists(tileentity1.xCoord >> 4, tileentity1.zCoord >> 4) && (chunk1 = this.getChunkFromChunkCoords(tileentity1.xCoord >> 4, tileentity1.zCoord >> 4)) != null) {
                    chunk1.setChunkBlockTileEntity(tileentity1.xCoord & 0xF, tileentity1.yCoord, tileentity1.zCoord & 0xF, tileentity1);
                }
                this.markBlockNeedsUpdate(tileentity1.xCoord, tileentity1.yCoord, tileentity1.zCoord);
            }
            this.addedTileEntityList.clear();
        }
        Profiler.endSection();
        Profiler.endSection();
    }

    public void addTileEntity(Collection par1Collection) {
        if (this.scanningTileEntities) {
            this.addedTileEntityList.addAll(par1Collection);
        } else {
            this.loadedTileEntityList.addAll(par1Collection);
        }
    }

    public void updateEntity(Entity par1Entity) {
        this.updateEntityWithOptionalForce(par1Entity, true);
    }

    public void updateEntityWithOptionalForce(Entity par1Entity, boolean par2) {
        int i = MathHelper.floor_double(par1Entity.posX);
        int j = MathHelper.floor_double(par1Entity.posZ);
        int byte0 = 32;
        if (par2 && !this.checkChunksExist(i - byte0, 0, j - byte0, i + byte0, 0, j + byte0)) {
            return;
        }
        par1Entity.lastTickPosX = par1Entity.posX;
        par1Entity.lastTickPosY = par1Entity.posY;
        par1Entity.lastTickPosZ = par1Entity.posZ;
        par1Entity.prevRotationYaw = par1Entity.rotationYaw;
        par1Entity.prevRotationPitch = par1Entity.rotationPitch;
        if (par2 && par1Entity.addedToChunk) {
            if (par1Entity.ridingEntity != null) {
                par1Entity.updateRidden();
            } else {
                par1Entity.onUpdate();
            }
        }
        Profiler.startSection("chunkCheck");
        if (Double.isNaN(par1Entity.posX) || Double.isInfinite(par1Entity.posX)) {
            par1Entity.posX = par1Entity.lastTickPosX;
        }
        if (Double.isNaN(par1Entity.posY) || Double.isInfinite(par1Entity.posY)) {
            par1Entity.posY = par1Entity.lastTickPosY;
        }
        if (Double.isNaN(par1Entity.posZ) || Double.isInfinite(par1Entity.posZ)) {
            par1Entity.posZ = par1Entity.lastTickPosZ;
        }
        if (Double.isNaN(par1Entity.rotationPitch) || Double.isInfinite(par1Entity.rotationPitch)) {
            par1Entity.rotationPitch = par1Entity.prevRotationPitch;
        }
        if (Double.isNaN(par1Entity.rotationYaw) || Double.isInfinite(par1Entity.rotationYaw)) {
            par1Entity.rotationYaw = par1Entity.prevRotationYaw;
        }
        int k = MathHelper.floor_double(par1Entity.posX / 16.0);
        int l = MathHelper.floor_double(par1Entity.posY / 16.0);
        int i1 = MathHelper.floor_double(par1Entity.posZ / 16.0);
        if (!par1Entity.addedToChunk || par1Entity.chunkCoordX != k || par1Entity.chunkCoordY != l || par1Entity.chunkCoordZ != i1) {
            if (par1Entity.addedToChunk && this.chunkExists(par1Entity.chunkCoordX, par1Entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(par1Entity.chunkCoordX, par1Entity.chunkCoordZ).removeEntityAtIndex(par1Entity, par1Entity.chunkCoordY);
            }
            if (this.chunkExists(k, i1)) {
                par1Entity.addedToChunk = true;
                this.getChunkFromChunkCoords(k, i1).addEntity(par1Entity);
            } else {
                par1Entity.addedToChunk = false;
            }
        }
        Profiler.endSection();
        if (par2 && par1Entity.addedToChunk && par1Entity.riddenByEntity != null) {
            if (par1Entity.riddenByEntity.isDead || par1Entity.riddenByEntity.ridingEntity != par1Entity) {
                par1Entity.riddenByEntity.ridingEntity = null;
                par1Entity.riddenByEntity = null;
            } else {
                this.updateEntity(par1Entity.riddenByEntity);
            }
        }
    }

    public boolean checkIfAABBIsClear(AxisAlignedBB par1AxisAlignedBB) {
        List list = this.getEntitiesWithinAABBExcludingEntity(null, par1AxisAlignedBB);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity.isDead || !entity.preventEntitySpawning) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyLiquid(AxisAlignedBB par1AxisAlignedBB) {
        int i = MathHelper.floor_double(par1AxisAlignedBB.minX);
        int j = MathHelper.floor_double(par1AxisAlignedBB.maxX + 1.0);
        int k = MathHelper.floor_double(par1AxisAlignedBB.minY);
        int l = MathHelper.floor_double(par1AxisAlignedBB.maxY + 1.0);
        int i1 = MathHelper.floor_double(par1AxisAlignedBB.minZ);
        int j1 = MathHelper.floor_double(par1AxisAlignedBB.maxZ + 1.0);
        if (par1AxisAlignedBB.minX < 0.0) {
            --i;
        }
        if (par1AxisAlignedBB.minY < 0.0) {
            --k;
        }
        if (par1AxisAlignedBB.minZ < 0.0) {
            --i1;
        }
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || !block.blockMaterial.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AxisAlignedBB par1AxisAlignedBB) {
        int j1;
        int i = MathHelper.floor_double(par1AxisAlignedBB.minX);
        int j = MathHelper.floor_double(par1AxisAlignedBB.maxX + 1.0);
        int k = MathHelper.floor_double(par1AxisAlignedBB.minY);
        int l = MathHelper.floor_double(par1AxisAlignedBB.maxY + 1.0);
        int i1 = MathHelper.floor_double(par1AxisAlignedBB.minZ);
        if (this.checkChunksExist(i, k, i1, j, l, j1 = MathHelper.floor_double(par1AxisAlignedBB.maxZ + 1.0))) {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        int j2 = this.getBlockId(k1, l1, i2);
                        if (j2 != Block.fire.blockID && j2 != Block.lavaMoving.blockID && j2 != Block.lavaStill.blockID) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AxisAlignedBB par1AxisAlignedBB, Material par2Material, Entity par3Entity) {
        int j1;
        int i = MathHelper.floor_double(par1AxisAlignedBB.minX);
        int j = MathHelper.floor_double(par1AxisAlignedBB.maxX + 1.0);
        int k = MathHelper.floor_double(par1AxisAlignedBB.minY);
        int l = MathHelper.floor_double(par1AxisAlignedBB.maxY + 1.0);
        int i1 = MathHelper.floor_double(par1AxisAlignedBB.minZ);
        if (!this.checkChunksExist(i, k, i1, j, l, j1 = MathHelper.floor_double(par1AxisAlignedBB.maxZ + 1.0))) {
            return false;
        }
        boolean flag = false;
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d1;
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || block.blockMaterial != par2Material || !((double)l >= (d1 = (double)((float)(l1 + 1) - BlockFluid.getFluidHeightPercent(this.getBlockMetadata(k1, l1, i2)))))) continue;
                    flag = true;
                    block.velocityToAddToEntity(this, k1, l1, i2, par3Entity, vec3d);
                }
            }
        }
        if (vec3d.lengthVector() > 0.0) {
            vec3d = vec3d.normalize();
            double d = 0.014;
            par3Entity.motionX += vec3d.xCoord * d;
            par3Entity.motionY += vec3d.yCoord * d;
            par3Entity.motionZ += vec3d.zCoord * d;
        }
        return flag;
    }

    public boolean isMaterialInBB(AxisAlignedBB par1AxisAlignedBB, Material par2Material) {
        int i = MathHelper.floor_double(par1AxisAlignedBB.minX);
        int j = MathHelper.floor_double(par1AxisAlignedBB.maxX + 1.0);
        int k = MathHelper.floor_double(par1AxisAlignedBB.minY);
        int l = MathHelper.floor_double(par1AxisAlignedBB.maxY + 1.0);
        int i1 = MathHelper.floor_double(par1AxisAlignedBB.minZ);
        int j1 = MathHelper.floor_double(par1AxisAlignedBB.maxZ + 1.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || block.blockMaterial != par2Material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAABBInMaterial(AxisAlignedBB par1AxisAlignedBB, Material par2Material) {
        int i = MathHelper.floor_double(par1AxisAlignedBB.minX);
        int j = MathHelper.floor_double(par1AxisAlignedBB.maxX + 1.0);
        int k = MathHelper.floor_double(par1AxisAlignedBB.minY);
        int l = MathHelper.floor_double(par1AxisAlignedBB.maxY + 1.0);
        int i1 = MathHelper.floor_double(par1AxisAlignedBB.minZ);
        int j1 = MathHelper.floor_double(par1AxisAlignedBB.maxZ + 1.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || block.blockMaterial != par2Material) continue;
                    int j2 = this.getBlockMetadata(k1, l1, i2);
                    double d = l1 + 1;
                    if (j2 < 8) {
                        d = (double)(l1 + 1) - (double)j2 / 8.0;
                    }
                    if (!(d >= par1AxisAlignedBB.minY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion createExplosion(Entity par1Entity, double par2, double par4, double par6, float par8) {
        return this.newExplosion(par1Entity, par2, par4, par6, par8, false);
    }

    public Explosion newExplosion(Entity par1Entity, double par2, double par4, double par6, float par8, boolean par9) {
        Explosion explosion = new Explosion(this, par1Entity, par2, par4, par6, par8);
        explosion.isFlaming = par9;
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        return explosion;
    }

    public float getBlockDensity(Vec3D par1Vec3D, AxisAlignedBB par2AxisAlignedBB) {
        double d = 1.0 / ((par2AxisAlignedBB.maxX - par2AxisAlignedBB.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((par2AxisAlignedBB.maxY - par2AxisAlignedBB.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((par2AxisAlignedBB.maxZ - par2AxisAlignedBB.minZ) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double d3 = par2AxisAlignedBB.minX + (par2AxisAlignedBB.maxX - par2AxisAlignedBB.minX) * (double)f;
                    double d4 = par2AxisAlignedBB.minY + (par2AxisAlignedBB.maxY - par2AxisAlignedBB.minY) * (double)f1;
                    double d5 = par2AxisAlignedBB.minZ + (par2AxisAlignedBB.maxZ - par2AxisAlignedBB.minZ) * (double)f2;
                    if (this.rayTraceBlocks(Vec3D.createVector(d3, d4, d5), par1Vec3D) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d);
        }
        return (float)i / (float)j;
    }

    public boolean func_48457_a(EntityPlayer par1EntityPlayer, int par2, int par3, int par4, int par5) {
        if (par5 == 0) {
            --par3;
        }
        if (par5 == 1) {
            ++par3;
        }
        if (par5 == 2) {
            --par4;
        }
        if (par5 == 3) {
            ++par4;
        }
        if (par5 == 4) {
            --par2;
        }
        if (par5 == 5) {
            ++par2;
        }
        if (this.getBlockId(par2, par3, par4) == Block.fire.blockID) {
            this.playAuxSFXAtEntity(par1EntityPlayer, 1004, par2, par3, par4, 0);
            this.setBlockWithNotify(par2, par3, par4, 0);
            return true;
        }
        return false;
    }

    public Entity func_4085_a(Class par1Class) {
        return null;
    }

    public String getDebugLoadedEntities() {
        return "All: " + this.loadedEntityList.size();
    }

    public String getProviderName() {
        return this.chunkProvider.makeString();
    }

    @Override
    public TileEntity getBlockTileEntity(int par1, int par2, int par3) {
        if (par2 >= 256) {
            return null;
        }
        Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4);
        if (chunk != null) {
            TileEntity tileentity = chunk.getChunkBlockTileEntity(par1 & 0xF, par2, par3 & 0xF);
            if (tileentity == null) {
                for (TileEntity tileentity1 : this.addedTileEntityList) {
                    if (tileentity1.isInvalid() || tileentity1.xCoord != par1 || tileentity1.yCoord != par2 || tileentity1.zCoord != par3) continue;
                    tileentity = tileentity1;
                    break;
                }
            }
            return tileentity;
        }
        return null;
    }

    public void setBlockTileEntity(int par1, int par2, int par3, TileEntity par4TileEntity) {
        if (par4TileEntity != null && !par4TileEntity.isInvalid()) {
            if (this.scanningTileEntities) {
                par4TileEntity.xCoord = par1;
                par4TileEntity.yCoord = par2;
                par4TileEntity.zCoord = par3;
                this.addedTileEntityList.add(par4TileEntity);
            } else {
                this.loadedTileEntityList.add(par4TileEntity);
                Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4);
                if (chunk != null) {
                    chunk.setChunkBlockTileEntity(par1 & 0xF, par2, par3 & 0xF, par4TileEntity);
                }
            }
        }
    }

    public void removeBlockTileEntity(int par1, int par2, int par3) {
        TileEntity tileentity = this.getBlockTileEntity(par1, par2, par3);
        if (tileentity != null && this.scanningTileEntities) {
            tileentity.invalidate();
            this.addedTileEntityList.remove(tileentity);
        } else {
            Chunk chunk;
            if (tileentity != null) {
                this.addedTileEntityList.remove(tileentity);
                this.loadedTileEntityList.remove(tileentity);
            }
            if ((chunk = this.getChunkFromChunkCoords(par1 >> 4, par3 >> 4)) != null) {
                chunk.removeChunkBlockTileEntity(par1 & 0xF, par2, par3 & 0xF);
            }
        }
    }

    public void markTileEntityForDespawn(TileEntity par1TileEntity) {
        this.entityRemoval.add(par1TileEntity);
    }

    @Override
    public boolean isBlockOpaqueCube(int par1, int par2, int par3) {
        Block block = Block.blocksList[this.getBlockId(par1, par2, par3)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    @Override
    public boolean isBlockNormalCube(int par1, int par2, int par3) {
        return Block.isNormalCube(this.getBlockId(par1, par2, par3));
    }

    public boolean isBlockNormalCubeDefault(int par1, int par2, int par3, boolean par4) {
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 >= 30000000) {
            return par4;
        }
        Chunk chunk = this.chunkProvider.provideChunk(par1 >> 4, par3 >> 4);
        if (chunk == null || chunk.isEmpty()) {
            return par4;
        }
        Block block = Block.blocksList[this.getBlockId(par1, par2, par3)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.isOpaque() && block.renderAsNormalBlock();
    }

    public void saveWorldIndirectly(IProgressUpdate par1IProgressUpdate) {
        this.saveWorld(true, par1IProgressUpdate);
        try {
            ThreadedFileIOBase.threadedIOInstance.waitForFinish();
        }
        catch (InterruptedException interruptedexception) {
            interruptedexception.printStackTrace();
        }
    }

    public void calculateInitialSkylight() {
        int i = this.calculateSkylightSubtracted(1.0f);
        if (i != this.skylightSubtracted) {
            this.skylightSubtracted = i;
        }
    }

    public void setAllowedSpawnTypes(boolean par1, boolean par2) {
        this.spawnHostileMobs = par1;
        this.spawnPeacefulMobs = par2;
    }

    public void tick() {
        long l1;
        if (this.getWorldInfo().isHardcoreModeEnabled() && this.difficultySetting < 3) {
            this.difficultySetting = 3;
        }
        this.worldProvider.worldChunkMgr.cleanupCache();
        this.updateWeather();
        if (this.isAllPlayersFullyAsleep()) {
            boolean flag = false;
            if (!this.spawnHostileMobs || this.difficultySetting < 1) {
                // empty if block
            }
            if (!flag) {
                long l = this.worldInfo.getWorldTime() + 24000L;
                this.worldInfo.setWorldTime(l - l % 24000L);
                this.wakeUpAllPlayers();
            }
        }
        Profiler.startSection("mobSpawner");
        SpawnerAnimals.performSpawning(this, this.spawnHostileMobs, this.spawnPeacefulMobs && this.worldInfo.getWorldTime() % 400L == 0L);
        Profiler.endStartSection("chunkSource");
        this.chunkProvider.unload100OldestChunks();
        int i = this.calculateSkylightSubtracted(1.0f);
        if (i != this.skylightSubtracted) {
            this.skylightSubtracted = i;
        }
        if ((l1 = this.worldInfo.getWorldTime() + 1L) % (long)this.autosavePeriod == 0L) {
            Profiler.endStartSection("save");
            this.saveWorld(false, null);
        }
        this.worldInfo.setWorldTime(l1);
        Profiler.endStartSection("tickPending");
        this.tickUpdates(false);
        Profiler.endStartSection("tickTiles");
        this.tickBlocksAndAmbiance();
        Profiler.endStartSection("village");
        this.villageCollectionObj.tick();
        this.villageSiegeObj.tick();
        Profiler.endSection();
    }

    private void calculateInitialWeather() {
        if (this.worldInfo.isRaining()) {
            this.rainingStrength = 1.0f;
            if (this.worldInfo.isThundering()) {
                this.thunderingStrength = 1.0f;
            }
        }
    }

    protected void updateWeather() {
        int i;
        if (this.worldProvider.hasNoSky) {
            return;
        }
        if (this.lastLightningBolt > 0) {
            --this.lastLightningBolt;
        }
        if ((i = this.worldInfo.getThunderTime()) <= 0) {
            if (this.worldInfo.isThundering()) {
                this.worldInfo.setThunderTime(this.rand.nextInt(12000) + 3600);
            } else {
                this.worldInfo.setThunderTime(this.rand.nextInt(168000) + 12000);
            }
        } else {
            this.worldInfo.setThunderTime(--i);
            if (i <= 0) {
                this.worldInfo.setThundering(!this.worldInfo.isThundering());
            }
        }
        int j = this.worldInfo.getRainTime();
        if (j <= 0) {
            if (this.worldInfo.isRaining()) {
                this.worldInfo.setRainTime(this.rand.nextInt(12000) + 12000);
            } else {
                this.worldInfo.setRainTime(this.rand.nextInt(168000) + 12000);
            }
        } else {
            this.worldInfo.setRainTime(--j);
            if (j <= 0) {
                this.worldInfo.setRaining(!this.worldInfo.isRaining());
            }
        }
        this.prevRainingStrength = this.rainingStrength;
        this.rainingStrength = this.worldInfo.isRaining() ? (float)((double)this.rainingStrength + 0.01) : (float)((double)this.rainingStrength - 0.01);
        if (this.rainingStrength < 0.0f) {
            this.rainingStrength = 0.0f;
        }
        if (this.rainingStrength > 1.0f) {
            this.rainingStrength = 1.0f;
        }
        this.prevThunderingStrength = this.thunderingStrength;
        this.thunderingStrength = this.worldInfo.isThundering() ? (float)((double)this.thunderingStrength + 0.01) : (float)((double)this.thunderingStrength - 0.01);
        if (this.thunderingStrength < 0.0f) {
            this.thunderingStrength = 0.0f;
        }
        if (this.thunderingStrength > 1.0f) {
            this.thunderingStrength = 1.0f;
        }
    }

    private void clearWeather() {
        this.worldInfo.setRainTime(0);
        this.worldInfo.setRaining(false);
        this.worldInfo.setThunderTime(0);
        this.worldInfo.setThundering(false);
    }

    protected void func_48461_r() {
        this.activeChunkSet.clear();
        Profiler.startSection("buildList");
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)this.playerEntities.get(i);
            int k = MathHelper.floor_double(entityplayer.posX / 16.0);
            int i1 = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int byte0 = 7;
            for (int l1 = -byte0; l1 <= byte0; ++l1) {
                for (int i2 = -byte0; i2 <= byte0; ++i2) {
                    this.activeChunkSet.add(new ChunkCoordIntPair(l1 + k, i2 + i1));
                }
            }
        }
        Profiler.endSection();
        if (this.ambientTickCountdown > 0) {
            --this.ambientTickCountdown;
        }
        Profiler.startSection("playerCheckLight");
        if (!this.playerEntities.isEmpty()) {
            int j = this.rand.nextInt(this.playerEntities.size());
            EntityPlayer entityplayer1 = (EntityPlayer)this.playerEntities.get(j);
            int l = MathHelper.floor_double(entityplayer1.posX) + this.rand.nextInt(11) - 5;
            int j1 = MathHelper.floor_double(entityplayer1.posY) + this.rand.nextInt(11) - 5;
            int k1 = MathHelper.floor_double(entityplayer1.posZ) + this.rand.nextInt(11) - 5;
            this.updateAllLightTypes(l, j1, k1);
        }
        Profiler.endSection();
    }

    protected void func_48458_a(int par1, int par2, Chunk par3Chunk) {
        Profiler.endStartSection("tickChunk");
        par3Chunk.updateSkylight();
        Profiler.endStartSection("moodSound");
        if (this.ambientTickCountdown == 0) {
            EntityPlayer entityplayer;
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int i = this.updateLCG >> 2;
            int j = i & 0xF;
            int k = i >> 8 & 0xF;
            int l = i >> 16 & 0x7F;
            int i1 = par3Chunk.getBlockID(j, l, k);
            if (i1 == 0 && this.getFullBlockLightValue(j += par1, l, k += par2) <= this.rand.nextInt(8) && this.getSavedLightValue(EnumSkyBlock.Sky, j, l, k) <= 0 && (entityplayer = this.getClosestPlayer((double)j + 0.5, (double)l + 0.5, (double)k + 0.5, 8.0)) != null && entityplayer.getDistanceSq((double)j + 0.5, (double)l + 0.5, (double)k + 0.5) > 4.0) {
                this.playSoundEffect((double)j + 0.5, (double)l + 0.5, (double)k + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                this.ambientTickCountdown = this.rand.nextInt(12000) + 6000;
            }
        }
        Profiler.endStartSection("checkLight");
        par3Chunk.enqueueRelightChecks();
    }

    protected void tickBlocksAndAmbiance() {
        this.func_48461_r();
        int i = 0;
        int j = 0;
        for (ChunkCoordIntPair chunkcoordintpair : this.activeChunkSet) {
            int k = chunkcoordintpair.chunkXPos * 16;
            int l = chunkcoordintpair.chunkZPosition * 16;
            Profiler.startSection("getChunk");
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.chunkXPos, chunkcoordintpair.chunkZPosition);
            this.func_48458_a(k, l, chunk);
            Profiler.endStartSection("thunder");
            if (this.rand.nextInt(100000) == 0 && this.isRaining() && this.isThundering()) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int i1 = this.updateLCG >> 2;
                int k1 = k + (i1 & 0xF);
                int j2 = l + (i1 >> 8 & 0xF);
                int i3 = this.getPrecipitationHeight(k1, j2);
                if (this.canLightningStrikeAt(k1, i3, j2)) {
                    this.addWeatherEffect(new EntityLightningBolt(this, k1, i3, j2));
                    this.lastLightningBolt = 2;
                }
            }
            Profiler.endStartSection("iceandsnow");
            if (this.rand.nextInt(16) == 0) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int j1 = this.updateLCG >> 2;
                int l1 = j1 & 0xF;
                int k2 = j1 >> 8 & 0xF;
                int j3 = this.getPrecipitationHeight(l1 + k, k2 + l);
                if (this.isBlockFreezableNaturally(l1 + k, j3 - 1, k2 + l)) {
                    this.setBlockWithNotify(l1 + k, j3 - 1, k2 + l, Block.ice.blockID);
                }
                if (this.isRaining() && this.canSnowAt(l1 + k, j3, k2 + l)) {
                    this.setBlockWithNotify(l1 + k, j3, k2 + l, Block.snow.blockID);
                }
            }
            Profiler.endStartSection("tickTiles");
            for (ExtendedBlockStorage extendedblockstorage : chunk.getBlockStorageArray()) {
                if (extendedblockstorage == null || !extendedblockstorage.getNeedsRandomTick()) continue;
                for (int k3 = 0; k3 < 3; ++k3) {
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int l3 = this.updateLCG >> 2;
                    int i4 = l3 & 0xF;
                    int j4 = l3 >> 8 & 0xF;
                    int k4 = l3 >> 16 & 0xF;
                    int l4 = extendedblockstorage.getExtBlockID(i4, k4, j4);
                    ++j;
                    Block block = Block.blocksList[l4];
                    if (block == null || !block.getTickRandomly()) continue;
                    ++i;
                    block.updateTick(this, i4 + k, k4 + extendedblockstorage.getYLocation(), j4 + l, this.rand);
                }
            }
            Profiler.endSection();
        }
    }

    public boolean isBlockFreezable(int par1, int par2, int par3) {
        return this.canBlockFreeze(par1, par2, par3, false);
    }

    public boolean isBlockFreezableNaturally(int par1, int par2, int par3) {
        return this.canBlockFreeze(par1, par2, par3, true);
    }

    public boolean canBlockFreeze(int par1, int par2, int par3, boolean par4) {
        int i;
        BiomeGenBase biomegenbase = this.getBiomeGenForCoords(par1, par3);
        float f = biomegenbase.getFloatTemperature();
        if (f > 0.15f) {
            return false;
        }
        if (par2 >= 0 && par2 < 256 && this.getSavedLightValue(EnumSkyBlock.Block, par1, par2, par3) < 10 && ((i = this.getBlockId(par1, par2, par3)) == Block.waterStill.blockID || i == Block.waterMoving.blockID) && this.getBlockMetadata(par1, par2, par3) == 0) {
            if (!par4) {
                return true;
            }
            boolean flag = true;
            if (flag && this.getBlockMaterial(par1 - 1, par2, par3) != Material.water) {
                flag = false;
            }
            if (flag && this.getBlockMaterial(par1 + 1, par2, par3) != Material.water) {
                flag = false;
            }
            if (flag && this.getBlockMaterial(par1, par2, par3 - 1) != Material.water) {
                flag = false;
            }
            if (flag && this.getBlockMaterial(par1, par2, par3 + 1) != Material.water) {
                flag = false;
            }
            if (!flag) {
                return true;
            }
        }
        return false;
    }

    public boolean canSnowAt(int par1, int par2, int par3) {
        BiomeGenBase biomegenbase = this.getBiomeGenForCoords(par1, par3);
        float f = biomegenbase.getFloatTemperature();
        if (f > 0.15f) {
            return false;
        }
        if (par2 >= 0 && par2 < 256 && this.getSavedLightValue(EnumSkyBlock.Block, par1, par2, par3) < 10) {
            int i = this.getBlockId(par1, par2 - 1, par3);
            int j = this.getBlockId(par1, par2, par3);
            if (j == 0 && Block.snow.canPlaceBlockAt(this, par1, par2, par3) && i != 0 && i != Block.ice.blockID && Block.blocksList[i].blockMaterial.blocksMovement()) {
                return true;
            }
        }
        return false;
    }

    public void updateAllLightTypes(int par1, int par2, int par3) {
        if (!this.worldProvider.hasNoSky) {
            this.updateLightByType(EnumSkyBlock.Sky, par1, par2, par3);
        }
        this.updateLightByType(EnumSkyBlock.Block, par1, par2, par3);
    }

    private int computeSkyLightValue(int par1, int par2, int par3, int par4, int par5, int par6) {
        int i = 0;
        if (this.canBlockSeeTheSky(par2, par3, par4)) {
            i = 15;
        } else {
            if (par6 == 0) {
                par6 = 1;
            }
            int j = this.getSavedLightValue(EnumSkyBlock.Sky, par2 - 1, par3, par4) - par6;
            int k = this.getSavedLightValue(EnumSkyBlock.Sky, par2 + 1, par3, par4) - par6;
            int l = this.getSavedLightValue(EnumSkyBlock.Sky, par2, par3 - 1, par4) - par6;
            int i1 = this.getSavedLightValue(EnumSkyBlock.Sky, par2, par3 + 1, par4) - par6;
            int j1 = this.getSavedLightValue(EnumSkyBlock.Sky, par2, par3, par4 - 1) - par6;
            int k1 = this.getSavedLightValue(EnumSkyBlock.Sky, par2, par3, par4 + 1) - par6;
            if (j > i) {
                i = j;
            }
            if (k > i) {
                i = k;
            }
            if (l > i) {
                i = l;
            }
            if (i1 > i) {
                i = i1;
            }
            if (j1 > i) {
                i = j1;
            }
            if (k1 > i) {
                i = k1;
            }
        }
        return i;
    }

    private int computeBlockLightValue(int par1, int par2, int par3, int par4, int par5, int par6) {
        int i = Block.lightValue[par5];
        int j = this.getSavedLightValue(EnumSkyBlock.Block, par2 - 1, par3, par4) - par6;
        int k = this.getSavedLightValue(EnumSkyBlock.Block, par2 + 1, par3, par4) - par6;
        int l = this.getSavedLightValue(EnumSkyBlock.Block, par2, par3 - 1, par4) - par6;
        int i1 = this.getSavedLightValue(EnumSkyBlock.Block, par2, par3 + 1, par4) - par6;
        int j1 = this.getSavedLightValue(EnumSkyBlock.Block, par2, par3, par4 - 1) - par6;
        int k1 = this.getSavedLightValue(EnumSkyBlock.Block, par2, par3, par4 + 1) - par6;
        if (j > i) {
            i = j;
        }
        if (k > i) {
            i = k;
        }
        if (l > i) {
            i = l;
        }
        if (i1 > i) {
            i = i1;
        }
        if (j1 > i) {
            i = j1;
        }
        if (k1 > i) {
            i = k1;
        }
        return i;
    }

    public void updateLightByType(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (!this.doChunksNearChunkExist(par2, par3, par4, 17)) {
            return;
        }
        int i = 0;
        int j = 0;
        Profiler.startSection("getBrightness");
        int k = this.getSavedLightValue(par1EnumSkyBlock, par2, par3, par4);
        int i1 = 0;
        int k1 = k;
        int j2 = this.getBlockId(par2, par3, par4);
        int i3 = this.func_48462_d(par2, par3, par4);
        if (i3 == 0) {
            i3 = 1;
        }
        int l3 = 0;
        l3 = par1EnumSkyBlock == EnumSkyBlock.Sky ? this.computeSkyLightValue(k1, par2, par3, par4, j2, i3) : this.computeBlockLightValue(k1, par2, par3, par4, j2, i3);
        i1 = l3;
        if (i1 > k) {
            this.lightUpdateBlockList[j++] = 133152;
        } else if (i1 < k) {
            if (par1EnumSkyBlock == EnumSkyBlock.Block) {
                // empty if block
            }
            this.lightUpdateBlockList[j++] = 133152 + (k << 18);
            while (i < j) {
                int l1 = this.lightUpdateBlockList[i++];
                int k2 = (l1 & 0x3F) - 32 + par2;
                int j3 = (l1 >> 6 & 0x3F) - 32 + par3;
                int i4 = (l1 >> 12 & 0x3F) - 32 + par4;
                int k4 = l1 >> 18 & 0xF;
                int i5 = this.getSavedLightValue(par1EnumSkyBlock, k2, j3, i4);
                if (i5 != k4) continue;
                this.setLightValue(par1EnumSkyBlock, k2, j3, i4, 0);
                if (k4 <= 0) continue;
                int l5 = k2 - par2;
                int j6 = j3 - par3;
                int l6 = i4 - par4;
                if (l5 < 0) {
                    l5 = -l5;
                }
                if (j6 < 0) {
                    j6 = -j6;
                }
                if (l6 < 0) {
                    l6 = -l6;
                }
                if (l5 + j6 + l6 >= 17) continue;
                for (int j7 = 0; j7 < 6; ++j7) {
                    int k7 = j7 % 2 * 2 - 1;
                    int l7 = k2 + j7 / 2 % 3 / 2 * k7;
                    int i8 = j3 + (j7 / 2 + 1) % 3 / 2 * k7;
                    int j8 = i4 + (j7 / 2 + 2) % 3 / 2 * k7;
                    int j5 = this.getSavedLightValue(par1EnumSkyBlock, l7, i8, j8);
                    int k8 = Block.lightOpacity[this.getBlockId(l7, i8, j8)];
                    if (k8 == 0) {
                        k8 = 1;
                    }
                    if (j5 != k4 - k8 || j >= this.lightUpdateBlockList.length) continue;
                    this.lightUpdateBlockList[j++] = l7 - par2 + 32 + (i8 - par3 + 32 << 6) + (j8 - par4 + 32 << 12) + (k4 - k8 << 18);
                }
            }
            i = 0;
        }
        Profiler.endSection();
        Profiler.startSection("tcp < tcc");
        while (i < j) {
            int l = this.lightUpdateBlockList[i++];
            int j1 = (l & 0x3F) - 32 + par2;
            int i2 = (l >> 6 & 0x3F) - 32 + par3;
            int l2 = (l >> 12 & 0x3F) - 32 + par4;
            int k3 = this.getSavedLightValue(par1EnumSkyBlock, j1, i2, l2);
            int j4 = this.getBlockId(j1, i2, l2);
            int l4 = Block.lightOpacity[j4];
            if (l4 == 0) {
                l4 = 1;
            }
            int k5 = 0;
            k5 = par1EnumSkyBlock == EnumSkyBlock.Sky ? this.computeSkyLightValue(k3, j1, i2, l2, j4, l4) : this.computeBlockLightValue(k3, j1, i2, l2, j4, l4);
            if (k5 == k3) continue;
            this.setLightValue(par1EnumSkyBlock, j1, i2, l2, k5);
            if (k5 <= k3) continue;
            int i6 = j1 - par2;
            int k6 = i2 - par3;
            int i7 = l2 - par4;
            if (i6 < 0) {
                i6 = -i6;
            }
            if (k6 < 0) {
                k6 = -k6;
            }
            if (i7 < 0) {
                i7 = -i7;
            }
            if (i6 + k6 + i7 >= 17 || j >= this.lightUpdateBlockList.length - 6) continue;
            if (this.getSavedLightValue(par1EnumSkyBlock, j1 - 1, i2, l2) < k5) {
                this.lightUpdateBlockList[j++] = j1 - 1 - par2 + 32 + (i2 - par3 + 32 << 6) + (l2 - par4 + 32 << 12);
            }
            if (this.getSavedLightValue(par1EnumSkyBlock, j1 + 1, i2, l2) < k5) {
                this.lightUpdateBlockList[j++] = j1 + 1 - par2 + 32 + (i2 - par3 + 32 << 6) + (l2 - par4 + 32 << 12);
            }
            if (this.getSavedLightValue(par1EnumSkyBlock, j1, i2 - 1, l2) < k5) {
                this.lightUpdateBlockList[j++] = j1 - par2 + 32 + (i2 - 1 - par3 + 32 << 6) + (l2 - par4 + 32 << 12);
            }
            if (this.getSavedLightValue(par1EnumSkyBlock, j1, i2 + 1, l2) < k5) {
                this.lightUpdateBlockList[j++] = j1 - par2 + 32 + (i2 + 1 - par3 + 32 << 6) + (l2 - par4 + 32 << 12);
            }
            if (this.getSavedLightValue(par1EnumSkyBlock, j1, i2, l2 - 1) < k5) {
                this.lightUpdateBlockList[j++] = j1 - par2 + 32 + (i2 - par3 + 32 << 6) + (l2 - 1 - par4 + 32 << 12);
            }
            if (this.getSavedLightValue(par1EnumSkyBlock, j1, i2, l2 + 1) >= k5) continue;
            this.lightUpdateBlockList[j++] = j1 - par2 + 32 + (i2 - par3 + 32 << 6) + (l2 + 1 - par4 + 32 << 12);
        }
        Profiler.endSection();
    }

    public boolean tickUpdates(boolean par1) {
        int i = this.scheduledTickTreeSet.size();
        if (i != this.scheduledTickSet.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (i > 1000) {
            i = 1000;
        }
        for (int j = 0; j < i; ++j) {
            int k;
            NextTickListEntry nextticklistentry = (NextTickListEntry)this.scheduledTickTreeSet.first();
            if (!par1 && nextticklistentry.scheduledTime > this.worldInfo.getWorldTime()) break;
            this.scheduledTickTreeSet.remove(nextticklistentry);
            this.scheduledTickSet.remove(nextticklistentry);
            int byte0 = 8;
            if (!this.checkChunksExist(nextticklistentry.xCoord - byte0, nextticklistentry.yCoord - byte0, nextticklistentry.zCoord - byte0, nextticklistentry.xCoord + byte0, nextticklistentry.yCoord + byte0, nextticklistentry.zCoord + byte0) || (k = this.getBlockId(nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord)) != nextticklistentry.blockID || k <= 0) continue;
            Block.blocksList[k].updateTick(this, nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord, this.rand);
        }
        return this.scheduledTickTreeSet.size() != 0;
    }

    public List getPendingBlockUpdates(Chunk par1Chunk, boolean par2) {
        ArrayList<NextTickListEntry> arraylist = null;
        ChunkCoordIntPair chunkcoordintpair = par1Chunk.getChunkCoordIntPair();
        int i = chunkcoordintpair.chunkXPos << 4;
        int j = i + 16;
        int k = chunkcoordintpair.chunkZPosition << 4;
        int l = k + 16;
        Iterator iterator = this.scheduledTickSet.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry nextticklistentry = (NextTickListEntry)iterator.next();
            if (nextticklistentry.xCoord < i || nextticklistentry.xCoord >= j || nextticklistentry.zCoord < k || nextticklistentry.zCoord >= l) continue;
            if (par2) {
                this.scheduledTickTreeSet.remove(nextticklistentry);
                iterator.remove();
            }
            if (arraylist == null) {
                arraylist = new ArrayList<NextTickListEntry>();
            }
            arraylist.add(nextticklistentry);
        }
        return arraylist;
    }

    public void randomDisplayUpdates(int par1, int par2, int par3) {
        int byte0 = 16;
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int l;
            int k;
            int j = par1 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0);
            int i1 = this.getBlockId(j, k = par2 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0), l = par3 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0));
            if (i1 == 0 && this.rand.nextInt(8) > k && this.worldProvider.getWorldHasNoSky()) {
                this.spawnParticle("depthsuspend", (float)j + this.rand.nextFloat(), (float)k + this.rand.nextFloat(), (float)l + this.rand.nextFloat(), 0.0, 0.0, 0.0);
                continue;
            }
            if (i1 <= 0) continue;
            Block.blocksList[i1].randomDisplayTick(this, j, k, l, random);
        }
    }

    public List getEntitiesWithinAABBExcludingEntity(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB) {
        this.entitiesWithinAABBExcludingEntity.clear();
        int i = MathHelper.floor_double((par2AxisAlignedBB.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((par2AxisAlignedBB.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((par2AxisAlignedBB.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((par2AxisAlignedBB.maxZ + 2.0) / 16.0);
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.chunkExists(i1, j1)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesWithinAABBForEntity(par1Entity, par2AxisAlignedBB, this.entitiesWithinAABBExcludingEntity);
            }
        }
        return this.entitiesWithinAABBExcludingEntity;
    }

    public List getEntitiesWithinAABB(Class par1Class, AxisAlignedBB par2AxisAlignedBB) {
        int i = MathHelper.floor_double((par2AxisAlignedBB.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((par2AxisAlignedBB.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((par2AxisAlignedBB.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((par2AxisAlignedBB.maxZ + 2.0) / 16.0);
        ArrayList arraylist = new ArrayList();
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.chunkExists(i1, j1)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesOfTypeWithinAAAB(par1Class, par2AxisAlignedBB, arraylist);
            }
        }
        return arraylist;
    }

    public Entity findNearestEntityWithinAABB(Class par1Class, AxisAlignedBB par2AxisAlignedBB, Entity par3Entity) {
        List list = this.getEntitiesWithinAABB(par1Class, par2AxisAlignedBB);
        Entity entity = null;
        double d = Double.MAX_VALUE;
        for (Entity entity1 : list) {
            double d1;
            if (entity1 == par3Entity || !((d1 = par3Entity.getDistanceSqToEntity(entity1)) <= d)) continue;
            entity = entity1;
            d = d1;
        }
        return entity;
    }

    public List getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void updateTileEntityChunkAndDoNothing(int par1, int par2, int par3, TileEntity par4TileEntity) {
        if (this.blockExists(par1, par2, par3)) {
            this.getChunkFromBlockCoords(par1, par3).setChunkModified();
        }
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).doNothingWithTileEntity(par1, par2, par3, par4TileEntity);
        }
    }

    public int countEntities(Class par1Class) {
        int i = 0;
        for (int j = 0; j < this.loadedEntityList.size(); ++j) {
            Entity entity = (Entity)this.loadedEntityList.get(j);
            if (!par1Class.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public void addLoadedEntities(List par1List) {
        this.loadedEntityList.addAll(par1List);
        for (int i = 0; i < par1List.size(); ++i) {
            this.obtainEntitySkin((Entity)par1List.get(i));
        }
    }

    public void unloadEntities(List par1List) {
        this.unloadedEntityList.addAll(par1List);
    }

    public void dropOldChunks() {
        while (this.chunkProvider.unload100OldestChunks()) {
        }
    }

    public boolean canBlockBePlacedAt(int par1, int par2, int par3, int par4, boolean par5, int par6) {
        int i = this.getBlockId(par2, par3, par4);
        Block block = Block.blocksList[i];
        Block block1 = Block.blocksList[par1];
        AxisAlignedBB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, par2, par3, par4);
        if (par5) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.checkIfAABBIsClear(axisalignedbb)) {
            return false;
        }
        if (block != null && (block == Block.waterMoving || block == Block.waterStill || block == Block.lavaMoving || block == Block.lavaStill || block == Block.fire || block.blockMaterial.isGroundCover())) {
            block = null;
        }
        return par1 > 0 && block == null && block1.canPlaceBlockOnSide(this, par2, par3, par4, par6);
    }

    public PathEntity getPathEntityToEntity(Entity par1Entity, Entity par2Entity, float par3, boolean par4, boolean par5, boolean par6, boolean par7) {
        Profiler.startSection("pathfind");
        int i = MathHelper.floor_double(par1Entity.posX);
        int j = MathHelper.floor_double(par1Entity.posY + 1.0);
        int k = MathHelper.floor_double(par1Entity.posZ);
        int l = (int)(par3 + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i2, j2);
        PathEntity pathentity = new PathFinder(chunkcache, par4, par5, par6, par7).createEntityPathTo(par1Entity, par2Entity, par3);
        Profiler.endSection();
        return pathentity;
    }

    public PathEntity getEntityPathToXYZ(Entity par1Entity, int par2, int par3, int par4, float par5, boolean par6, boolean par7, boolean par8, boolean par9) {
        Profiler.startSection("pathfind");
        int i = MathHelper.floor_double(par1Entity.posX);
        int j = MathHelper.floor_double(par1Entity.posY);
        int k = MathHelper.floor_double(par1Entity.posZ);
        int l = (int)(par5 + 8.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i2, j2);
        PathEntity pathentity = new PathFinder(chunkcache, par6, par7, par8, par9).createEntityPathTo(par1Entity, par2, par3, par4, par5);
        Profiler.endSection();
        return pathentity;
    }

    public boolean isBlockProvidingPowerTo(int par1, int par2, int par3, int par4) {
        int i = this.getBlockId(par1, par2, par3);
        if (i == 0) {
            return false;
        }
        return Block.blocksList[i].isIndirectlyPoweringTo(this, par1, par2, par3, par4);
    }

    public boolean isBlockGettingPowered(int par1, int par2, int par3) {
        if (this.isBlockProvidingPowerTo(par1, par2 - 1, par3, 0)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(par1, par2 + 1, par3, 1)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(par1, par2, par3 - 1, 2)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(par1, par2, par3 + 1, 3)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(par1 - 1, par2, par3, 4)) {
            return true;
        }
        return this.isBlockProvidingPowerTo(par1 + 1, par2, par3, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int par1, int par2, int par3, int par4) {
        if (this.isBlockNormalCube(par1, par2, par3)) {
            return this.isBlockGettingPowered(par1, par2, par3);
        }
        int i = this.getBlockId(par1, par2, par3);
        if (i == 0) {
            return false;
        }
        return Block.blocksList[i].isPoweringTo(this, par1, par2, par3, par4);
    }

    public boolean isBlockIndirectlyGettingPowered(int par1, int par2, int par3) {
        if (this.isBlockIndirectlyProvidingPowerTo(par1, par2 - 1, par3, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(par1, par2 + 1, par3, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(par1, par2, par3 - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(par1, par2, par3 + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(par1 - 1, par2, par3, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(par1 + 1, par2, par3, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity par1Entity, double par2) {
        return this.getClosestPlayer(par1Entity.posX, par1Entity.posY, par1Entity.posZ, par2);
    }

    public EntityPlayer getClosestPlayer(double par1, double par3, double par5, double par7) {
        double d = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)this.playerEntities.get(i);
            double d1 = entityplayer1.getDistanceSq(par1, par3, par5);
            if (!(par7 < 0.0) && !(d1 < par7 * par7) || d != -1.0 && !(d1 < d)) continue;
            d = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public EntityPlayer func_48456_a(double par1, double par3, double par5) {
        double d = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)this.playerEntities.get(i);
            double d1 = entityplayer1.getDistanceSq(par1, entityplayer1.posY, par3);
            if (!(par5 < 0.0) && !(d1 < par5 * par5) || d != -1.0 && !(d1 < d)) continue;
            d = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public EntityPlayer getClosestVulnerablePlayerToEntity(Entity par1Entity, double par2) {
        return this.getClosestVulnerablePlayer(par1Entity.posX, par1Entity.posY, par1Entity.posZ, par2);
    }

    public EntityPlayer getClosestVulnerablePlayer(double par1, double par3, double par5, double par7) {
        double d = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)this.playerEntities.get(i);
            if (entityplayer1.capabilities.disableDamage) continue;
            double d1 = entityplayer1.getDistanceSq(par1, par3, par5);
            if (!(par7 < 0.0) && !(d1 < par7 * par7) || d != -1.0 && !(d1 < d)) continue;
            d = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public EntityPlayer getPlayerEntityByName(String par1Str) {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            if (!par1Str.equals(((EntityPlayer)this.playerEntities.get((int)i)).username)) continue;
            return (EntityPlayer)this.playerEntities.get(i);
        }
        return null;
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        this.saveHandler.checkSessionLock();
    }

    public void setWorldTime(long par1) {
        this.worldInfo.setWorldTime(par1);
    }

    public long getSeed() {
        return this.worldInfo.getSeed();
    }

    public long getWorldTime() {
        return this.worldInfo.getWorldTime();
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.worldInfo.getSpawnX(), this.worldInfo.getSpawnY(), this.worldInfo.getSpawnZ());
    }

    public void setSpawnPoint(ChunkCoordinates par1ChunkCoordinates) {
        this.worldInfo.setSpawnPosition(par1ChunkCoordinates.posX, par1ChunkCoordinates.posY, par1ChunkCoordinates.posZ);
    }

    public void joinEntityInSurroundings(Entity par1Entity) {
        int i = MathHelper.floor_double(par1Entity.posX / 16.0);
        int j = MathHelper.floor_double(par1Entity.posZ / 16.0);
        int byte0 = 2;
        for (int k = i - byte0; k <= i + byte0; ++k) {
            for (int l = j - byte0; l <= j + byte0; ++l) {
                this.getChunkFromChunkCoords(k, l);
            }
        }
        if (!this.loadedEntityList.contains(par1Entity)) {
            this.loadedEntityList.add(par1Entity);
        }
    }

    public boolean canMineBlock(EntityPlayer par1EntityPlayer, int par2, int par3, int i) {
        return true;
    }

    public void setEntityState(Entity entity, byte byte0) {
    }

    public void updateEntityList() {
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int i = 0; i < this.unloadedEntityList.size(); ++i) {
            Entity entity = (Entity)this.unloadedEntityList.get(i);
            int l = entity.chunkCoordX;
            int j1 = entity.chunkCoordZ;
            if (!entity.addedToChunk || !this.chunkExists(l, j1)) continue;
            this.getChunkFromChunkCoords(l, j1).removeEntity(entity);
        }
        for (int j = 0; j < this.unloadedEntityList.size(); ++j) {
            this.releaseEntitySkin((Entity)this.unloadedEntityList.get(j));
        }
        this.unloadedEntityList.clear();
        for (int k = 0; k < this.loadedEntityList.size(); ++k) {
            Entity entity1 = (Entity)this.loadedEntityList.get(k);
            if (entity1.ridingEntity != null) {
                if (!entity1.ridingEntity.isDead && entity1.ridingEntity.riddenByEntity == entity1) continue;
                entity1.ridingEntity.riddenByEntity = null;
                entity1.ridingEntity = null;
            }
            if (!entity1.isDead) continue;
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (entity1.addedToChunk && this.chunkExists(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
            }
            this.loadedEntityList.remove(k--);
            this.releaseEntitySkin(entity1);
        }
    }

    public IChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public void playNoteAt(int par1, int par2, int par3, int par4, int par5) {
        int i = this.getBlockId(par1, par2, par3);
        if (i > 0) {
            Block.blocksList[i].powerBlock(this, par1, par2, par3, par4, par5);
        }
    }

    public ISaveHandler getSaveHandler() {
        return this.saveHandler;
    }

    public WorldInfo getWorldInfo() {
        return this.worldInfo;
    }

    public void updateAllPlayersSleepingFlag() {
        this.allPlayersSleeping = !this.playerEntities.isEmpty();
        for (EntityPlayer entityplayer : this.playerEntities) {
            if (entityplayer.isPlayerSleeping()) continue;
            this.allPlayersSleeping = false;
            break;
        }
    }

    protected void wakeUpAllPlayers() {
        this.allPlayersSleeping = false;
        for (EntityPlayer entityplayer : this.playerEntities) {
            if (!entityplayer.isPlayerSleeping()) continue;
            entityplayer.wakeUpPlayer(false, false, true);
        }
        this.clearWeather();
    }

    public boolean isAllPlayersFullyAsleep() {
        if (this.allPlayersSleeping && !this.isRemote) {
            for (EntityPlayer entityplayer : this.playerEntities) {
                if (entityplayer.isPlayerFullyAsleep()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public float getWeightedThunderStrength(float par1) {
        return (this.prevThunderingStrength + (this.thunderingStrength - this.prevThunderingStrength) * par1) * this.getRainStrength(par1);
    }

    public float getRainStrength(float par1) {
        return this.prevRainingStrength + (this.rainingStrength - this.prevRainingStrength) * par1;
    }

    public void setRainStrength(float par1) {
        this.prevRainingStrength = par1;
        this.rainingStrength = par1;
    }

    public boolean isThundering() {
        return (double)this.getWeightedThunderStrength(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return (double)this.getRainStrength(1.0f) > 0.2;
    }

    public boolean canLightningStrikeAt(int par1, int par2, int par3) {
        if (!this.isRaining()) {
            return false;
        }
        if (!this.canBlockSeeTheSky(par1, par2, par3)) {
            return false;
        }
        if (this.getPrecipitationHeight(par1, par3) > par2) {
            return false;
        }
        BiomeGenBase biomegenbase = this.getBiomeGenForCoords(par1, par3);
        if (biomegenbase.getEnableSnow()) {
            return false;
        }
        return biomegenbase.canSpawnLightningBolt();
    }

    public boolean isBlockHighHumidity(int par1, int par2, int par3) {
        BiomeGenBase biomegenbase = this.getBiomeGenForCoords(par1, par3);
        return biomegenbase.isHighHumidity();
    }

    public void setItemData(String par1Str, WorldSavedData par2WorldSavedData) {
        this.mapStorage.setData(par1Str, par2WorldSavedData);
    }

    public WorldSavedData loadItemData(Class par1Class, String par2Str) {
        return this.mapStorage.loadData(par1Class, par2Str);
    }

    public int getUniqueDataId(String par1Str) {
        return this.mapStorage.getUniqueDataId(par1Str);
    }

    public void playAuxSFX(int par1, int par2, int par3, int par4, int par5) {
        this.playAuxSFXAtEntity(null, par1, par2, par3, par4, par5);
    }

    public void playAuxSFXAtEntity(EntityPlayer par1EntityPlayer, int par2, int par3, int par4, int par5, int par6) {
        for (int i = 0; i < this.worldAccesses.size(); ++i) {
            ((IWorldAccess)this.worldAccesses.get(i)).playAuxSFX(par1EntityPlayer, par2, par3, par4, par5, par6);
        }
    }

    @Override
    public int getHeight() {
        return 256;
    }

    public Random setRandomSeed(int par1, int par2, int par3) {
        long l = (long)par1 * 341873128712L + (long)par2 * 132897987541L + this.getWorldInfo().getSeed() + (long)par3;
        this.rand.setSeed(l);
        return this.rand;
    }

    public boolean updatingLighting() {
        return false;
    }

    public SpawnListEntry getRandomMob(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        List list = this.getChunkProvider().getPossibleCreatures(par1EnumCreatureType, par2, par3, par4);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (SpawnListEntry)WeightedRandom.getRandomItem(this.rand, list);
    }

    public ChunkPosition findClosestStructure(String par1Str, int par2, int par3, int par4) {
        return this.getChunkProvider().findClosestStructure(this, par1Str, par2, par3, par4);
    }

    @Override
    public boolean func_48452_a() {
        return false;
    }

    public double getSeaLevel() {
        return this.worldInfo.getTerrainType() != WorldType.FLAT ? 63.0 : 0.0;
    }
}

