/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkProviderClient;
import net.minecraft.src.Entity;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.IntHashMap;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Profiler;
import net.minecraft.src.SaveHandlerMP;
import net.minecraft.src.World;
import net.minecraft.src.WorldBlockPositionType;
import net.minecraft.src.WorldProvider;
import net.minecraft.src.WorldSettings;

public class WorldClient
extends World {
    private LinkedList blocksToReceive = new LinkedList();
    private NetClientHandler sendQueue;
    private ChunkProviderClient field_20915_C;
    private IntHashMap entityHashSet = new IntHashMap();
    private Set entityList = new HashSet();
    private Set entitySpawnQueue = new HashSet();

    public WorldClient(NetClientHandler par1NetClientHandler, WorldSettings par2WorldSettings, int par3, int par4) {
        super((ISaveHandler)new SaveHandlerMP(), "MpServer", WorldProvider.getProviderForDimension(par3), par2WorldSettings);
        this.sendQueue = par1NetClientHandler;
        this.difficultySetting = par4;
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
        this.mapStorage = par1NetClientHandler.mapStorage;
    }

    @Override
    public void tick() {
        this.setWorldTime(this.getWorldTime() + 1L);
        for (int i = 0; i < 10 && !this.entitySpawnQueue.isEmpty(); ++i) {
            Entity entity = (Entity)this.entitySpawnQueue.iterator().next();
            this.entitySpawnQueue.remove(entity);
            if (this.loadedEntityList.contains(entity)) continue;
            this.spawnEntityInWorld(entity);
        }
        this.sendQueue.processReadPackets();
        for (int j = 0; j < this.blocksToReceive.size(); ++j) {
            WorldBlockPositionType worldblockpositiontype = (WorldBlockPositionType)this.blocksToReceive.get(j);
            if (--worldblockpositiontype.acceptCountdown != 0) continue;
            super.setBlockAndMetadata(worldblockpositiontype.posX, worldblockpositiontype.posY, worldblockpositiontype.posZ, worldblockpositiontype.blockID, worldblockpositiontype.metadata);
            super.markBlockNeedsUpdate(worldblockpositiontype.posX, worldblockpositiontype.posY, worldblockpositiontype.posZ);
            this.blocksToReceive.remove(j--);
        }
        this.field_20915_C.unload100OldestChunks();
        this.tickBlocksAndAmbiance();
    }

    public void invalidateBlockReceiveRegion(int par1, int par2, int par3, int par4, int par5, int par6) {
        for (int i = 0; i < this.blocksToReceive.size(); ++i) {
            WorldBlockPositionType worldblockpositiontype = (WorldBlockPositionType)this.blocksToReceive.get(i);
            if (worldblockpositiontype.posX < par1 || worldblockpositiontype.posY < par2 || worldblockpositiontype.posZ < par3 || worldblockpositiontype.posX > par4 || worldblockpositiontype.posY > par5 || worldblockpositiontype.posZ > par6) continue;
            this.blocksToReceive.remove(i--);
        }
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        this.field_20915_C = new ChunkProviderClient(this);
        return this.field_20915_C;
    }

    @Override
    public void setSpawnLocation() {
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    protected void tickBlocksAndAmbiance() {
        this.func_48461_r();
        for (ChunkCoordIntPair chunkcoordintpair : this.activeChunkSet) {
            int i = chunkcoordintpair.chunkXPos * 16;
            int j = chunkcoordintpair.chunkZPosition * 16;
            Profiler.startSection("getChunk");
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.chunkXPos, chunkcoordintpair.chunkZPosition);
            this.func_48458_a(i, j, chunk);
            Profiler.endSection();
        }
    }

    @Override
    public void scheduleBlockUpdate(int i, int j, int k, int l, int i1) {
    }

    @Override
    public boolean tickUpdates(boolean par1) {
        return false;
    }

    public void doPreChunk(int par1, int par2, boolean par3) {
        if (par3) {
            this.field_20915_C.loadChunk(par1, par2);
        } else {
            this.field_20915_C.func_539_c(par1, par2);
        }
        if (!par3) {
            this.markBlocksDirty(par1 * 16, 0, par2 * 16, par1 * 16 + 15, 256, par2 * 16 + 15);
        }
    }

    @Override
    public boolean spawnEntityInWorld(Entity par1Entity) {
        boolean flag = super.spawnEntityInWorld(par1Entity);
        this.entityList.add(par1Entity);
        if (!flag) {
            this.entitySpawnQueue.add(par1Entity);
        }
        return flag;
    }

    @Override
    public void setEntityDead(Entity par1Entity) {
        super.setEntityDead(par1Entity);
        this.entityList.remove(par1Entity);
    }

    @Override
    protected void obtainEntitySkin(Entity par1Entity) {
        super.obtainEntitySkin(par1Entity);
        if (this.entitySpawnQueue.contains(par1Entity)) {
            this.entitySpawnQueue.remove(par1Entity);
        }
    }

    @Override
    protected void releaseEntitySkin(Entity par1Entity) {
        super.releaseEntitySkin(par1Entity);
        if (this.entityList.contains(par1Entity)) {
            if (par1Entity.isEntityAlive()) {
                this.entitySpawnQueue.add(par1Entity);
            } else {
                this.entityList.remove(par1Entity);
            }
        }
    }

    public void addEntityToWorld(int par1, Entity par2Entity) {
        Entity entity = this.getEntityByID(par1);
        if (entity != null) {
            this.setEntityDead(entity);
        }
        this.entityList.add(par2Entity);
        par2Entity.entityId = par1;
        if (!this.spawnEntityInWorld(par2Entity)) {
            this.entitySpawnQueue.add(par2Entity);
        }
        this.entityHashSet.addKey(par1, par2Entity);
    }

    public Entity getEntityByID(int par1) {
        return (Entity)this.entityHashSet.lookup(par1);
    }

    public Entity removeEntityFromWorld(int par1) {
        Entity entity = (Entity)this.entityHashSet.removeObject(par1);
        if (entity != null) {
            this.entityList.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    public boolean setBlockAndMetadataAndInvalidate(int par1, int par2, int par3, int par4, int par5) {
        this.invalidateBlockReceiveRegion(par1, par2, par3, par1, par2, par3);
        return super.setBlockAndMetadataWithNotify(par1, par2, par3, par4, par5);
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.quitWithPacket(new Packet255KickDisconnect("Quitting"));
    }

    @Override
    protected void updateWeather() {
        if (this.worldProvider.hasNoSky) {
            return;
        }
        if (this.lastLightningBolt > 0) {
            --this.lastLightningBolt;
        }
        this.prevRainingStrength = this.rainingStrength;
        this.rainingStrength = this.worldInfo.isRaining() ? (float)((double)this.rainingStrength + 0.01) : (float)((double)this.rainingStrength - 0.01);
        if (this.rainingStrength < 0.0f) {
            this.rainingStrength = 0.0f;
        }
        if (this.rainingStrength > 1.0f) {
            this.rainingStrength = 1.0f;
        }
        this.prevThunderingStrength = this.thunderingStrength;
        this.thunderingStrength = this.worldInfo.isThundering() ? (float)((double)this.thunderingStrength + 0.01) : (float)((double)this.thunderingStrength - 0.01);
        if (this.thunderingStrength < 0.0f) {
            this.thunderingStrength = 0.0f;
        }
        if (this.thunderingStrength > 1.0f) {
            this.thunderingStrength = 1.0f;
        }
    }
}

