/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenBigTree
extends WorldGenerator {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    Random rand;
    World worldObj;
    int[] basePos = new int[]{0, 0, 0};
    int heightLimit = 0;
    int height;
    double heightAttenuation = 0.618;
    double branchDensity = 1.0;
    double branchSlope = 0.381;
    double scaleWidth = 1.0;
    double leafDensity = 1.0;
    int trunkSize = 1;
    int heightLimitLimit = 12;
    int leafDistanceLimit = 4;
    int[][] leafNodes;

    public WorldGenBigTree(boolean par1) {
        super(par1);
        this.rand = new Random();
    }

    void generateLeafNodeList() {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        ai[0][0] = this.basePos[0];
        ai[0][1] = j--;
        ai[0][2] = this.basePos[2];
        ai[0][3] = l;
        while (i1 >= 0) {
            float f = this.layerSize(i1);
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] ai2;
                int l1;
                double d2;
                double d1 = this.scaleWidth * ((double)f * ((double)this.rand.nextFloat() + 0.328));
                int k1 = MathHelper.floor_double(d1 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d);
                int[] ai1 = new int[]{k1, j, l1 = MathHelper.floor_double(d1 * Math.cos(d2) + (double)this.basePos[2] + d)};
                if (this.checkBlockLine(ai1, ai2 = new int[]{k1, j + this.leafDistanceLimit, l1}) != -1) continue;
                int[] ai3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - ai1[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - ai1[2]), 2.0));
                double d4 = d3 * this.branchSlope;
                ai3[1] = (double)ai1[1] - d4 > (double)l ? l : (int)((double)ai1[1] - d4);
                if (this.checkBlockLine(ai3, ai1) != -1) continue;
                ai[k][0] = k1;
                ai[k][1] = j;
                ai[k][2] = l1;
                ai[k][3] = ai3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(ai, 0, this.leafNodes, 0, k);
    }

    void genTreeLayer(int par1, int par2, int par3, float par4, byte par5, int par6) {
        int i = (int)((double)par4 + 0.618);
        byte byte0 = otherCoordPairs[par5];
        byte byte1 = otherCoordPairs[par5 + 3];
        int[] ai = new int[]{par1, par2, par3};
        int[] ai1 = new int[]{0, 0, 0};
        int k = -i;
        ai1[par5] = ai[par5];
        for (int j = -i; j <= i; ++j) {
            ai1[byte0] = ai[byte0] + j;
            int l = -i;
            while (l <= i) {
                double d = Math.sqrt(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(l) + 0.5, 2.0));
                if (d > (double)par4) {
                    ++l;
                    continue;
                }
                ai1[byte1] = ai[byte1] + l;
                int i1 = this.worldObj.getBlockId(ai1[0], ai1[1], ai1[2]);
                if (i1 != 0 && i1 != 18) {
                    ++l;
                    continue;
                }
                this.setBlockAndMetadata(this.worldObj, ai1[0], ai1[1], ai1[2], par6, 0);
                ++l;
            }
        }
    }

    float layerSize(int par1) {
        if ((double)par1 < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)par1;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float leafSize(int par1) {
        if (par1 < 0 || par1 >= this.leafDistanceLimit) {
            return -1.0f;
        }
        return par1 != 0 && par1 != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
    }

    void generateLeafNode(int par1, int par2, int par3) {
        int j = par2 + this.leafDistanceLimit;
        for (int i = par2; i < j; ++i) {
            float f = this.leafSize(i - par2);
            this.genTreeLayer(par1, i, par3, f, (byte)1, 18);
        }
    }

    void placeBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger, int par3) {
        int[] ai = new int[]{0, 0, 0};
        int i = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai[byte0] = par2ArrayOfInteger[byte0] - par1ArrayOfInteger[byte0];
            if (Math.abs(ai[byte0]) <= Math.abs(ai[i])) continue;
            i = byte0;
        }
        if (ai[i] == 0) {
            return;
        }
        byte byte1 = otherCoordPairs[i];
        byte byte2 = otherCoordPairs[i + 3];
        int byte3 = ai[i] > 0 ? 1 : -1;
        double d = (double)ai[byte1] / (double)ai[i];
        double d1 = (double)ai[byte2] / (double)ai[i];
        int[] ai1 = new int[]{0, 0, 0};
        int k = ai[i] + byte3;
        for (int j = 0; j != k; j += byte3) {
            ai1[i] = MathHelper.floor_double((double)(par1ArrayOfInteger[i] + j) + 0.5);
            ai1[byte1] = MathHelper.floor_double((double)par1ArrayOfInteger[byte1] + (double)j * d + 0.5);
            ai1[byte2] = MathHelper.floor_double((double)par1ArrayOfInteger[byte2] + (double)j * d1 + 0.5);
            this.setBlockAndMetadata(this.worldObj, ai1[0], ai1[1], ai1[2], par3, 0);
        }
    }

    void generateLeaves() {
        int j = this.leafNodes.length;
        for (int i = 0; i < j; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(k, l, i1);
        }
    }

    boolean leafNodeNeedsBase(int par1) {
        return (double)par1 >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        int i = this.basePos[0];
        int j = this.basePos[1];
        int k = this.basePos[1] + this.height;
        int l = this.basePos[2];
        int[] ai = new int[]{i, j, l};
        int[] ai1 = new int[]{i, k, l};
        this.placeBlockLine(ai, ai1, 17);
        if (this.trunkSize == 2) {
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.placeBlockLine(ai, ai1, 17);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.placeBlockLine(ai, ai1, 17);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.placeBlockLine(ai, ai1, 17);
        }
    }

    void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.leafNodes[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(ai, ai2, 17);
        }
    }

    int checkBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger) {
        int j;
        int[] ai = new int[]{0, 0, 0};
        int i = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai[byte0] = par2ArrayOfInteger[byte0] - par1ArrayOfInteger[byte0];
            if (Math.abs(ai[byte0]) <= Math.abs(ai[i])) continue;
            i = byte0;
        }
        if (ai[i] == 0) {
            return -1;
        }
        byte byte1 = otherCoordPairs[i];
        byte byte2 = otherCoordPairs[i + 3];
        int byte3 = ai[i] > 0 ? 1 : -1;
        double d = (double)ai[byte1] / (double)ai[i];
        double d1 = (double)ai[byte2] / (double)ai[i];
        int[] ai1 = new int[]{0, 0, 0};
        int k = ai[i] + byte3;
        for (j = 0; j != k; j += byte3) {
            ai1[i] = par1ArrayOfInteger[i] + j;
            ai1[byte1] = MathHelper.floor_double((double)par1ArrayOfInteger[byte1] + (double)j * d);
            ai1[byte2] = MathHelper.floor_double((double)par1ArrayOfInteger[byte2] + (double)j * d1);
            int l = this.worldObj.getBlockId(ai1[0], ai1[1], ai1[2]);
            if (l != 0 && l != 18) break;
        }
        if (j == k) {
            return -1;
        }
        return Math.abs(j);
    }

    boolean validTreeLocation() {
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] ai1 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        int i = this.worldObj.getBlockId(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        if (i != 2 && i != 3) {
            return false;
        }
        int j = this.checkBlockLine(ai, ai1);
        if (j == -1) {
            return true;
        }
        if (j < 6) {
            return false;
        }
        this.heightLimit = j;
        return true;
    }

    @Override
    public void setScale(double par1, double par3, double par5) {
        this.heightLimitLimit = (int)(par1 * 12.0);
        if (par1 > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = par3;
        this.leafDensity = par5;
    }

    @Override
    public boolean generate(World par1World, Random par2Random, int par3, int par4, int par5) {
        this.worldObj = par1World;
        long l = par2Random.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = par3;
        this.basePos[1] = par4;
        this.basePos[2] = par5;
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        return true;
    }
}

