/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenSand
extends WorldGenerator {
    private int sandID;
    private int radius;

    public WorldGenSand(int par1, int par2) {
        this.sandID = par2;
        this.radius = par1;
    }

    @Override
    public boolean generate(World par1World, Random par2Random, int par3, int par4, int par5) {
        if (par1World.getBlockMaterial(par3, par4, par5) != Material.water) {
            return false;
        }
        int i = par2Random.nextInt(this.radius - 2) + 2;
        int byte0 = 2;
        for (int j = par3 - i; j <= par3 + i; ++j) {
            for (int k = par5 - i; k <= par5 + i; ++k) {
                int l = j - par3;
                int i1 = k - par5;
                if (l * l + i1 * i1 > i * i) continue;
                for (int j1 = par4 - byte0; j1 <= par4 + byte0; ++j1) {
                    int k1 = par1World.getBlockId(j, j1, k);
                    if (k1 != Block.dirt.blockID && k1 != Block.grass.blockID) continue;
                    par1World.setBlock(j, j1, k, this.sandID);
                }
            }
        }
        return true;
    }
}

