/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.ChunkProviderFlat;
import net.minecraft.src.ChunkProviderGenerate;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.WorldChunkManagerHell;

public class WorldType {
    public static final WorldType[] worldTypes = new WorldType[16];
    public static final WorldType DEFAULT = new WorldType(0, "default", 1).func_48631_f();
    public static final WorldType FLAT = new WorldType(1, "flat");
    public static final WorldType DEFAULT_1_1 = new WorldType(8, "default_1_1", 0).setCanBeCreated(false);
    private final String worldType;
    private final int generatorVersion;
    private boolean canBeCreated;
    private boolean field_48638_h;

    public WorldType(int par1, String par2Str) {
        this(par1, par2Str, 0);
    }

    private WorldType(int par1, String par2Str, int par3) {
        this.worldType = par2Str;
        this.generatorVersion = par3;
        this.canBeCreated = true;
        WorldType.worldTypes[par1] = this;
    }

    public String func_48628_a() {
        return this.worldType;
    }

    public String getTranslateName() {
        return "generator." + this.worldType;
    }

    public int getGeneratorVersion() {
        return this.generatorVersion;
    }

    public WorldType func_48629_a(int par1) {
        return this != DEFAULT || par1 != 0 ? this : DEFAULT_1_1;
    }

    private WorldType setCanBeCreated(boolean par1) {
        this.canBeCreated = par1;
        return this;
    }

    public boolean getCanBeCreated() {
        return this.canBeCreated;
    }

    private WorldType func_48631_f() {
        this.field_48638_h = true;
        return this;
    }

    public boolean func_48626_e() {
        return this.field_48638_h;
    }

    public static WorldType parseWorldType(String par0Str) {
        for (int i = 0; i < worldTypes.length; ++i) {
            if (worldTypes[i] == null || !WorldType.worldTypes[i].worldType.equalsIgnoreCase(par0Str)) continue;
            return worldTypes[i];
        }
        return null;
    }

    public WorldChunkManager getChunkManager(World world) {
        if (this == FLAT) {
            return new WorldChunkManagerHell(BiomeGenBase.plains, 0.5f, 0.5f);
        }
        return new WorldChunkManager(world);
    }

    public IChunkProvider getChunkGenerator(World world) {
        if (this == FLAT) {
            return new ChunkProviderFlat(world, world.getSeed(), world.getWorldInfo().isMapFeaturesEnabled());
        }
        return new ChunkProviderGenerate(world, world.getSeed(), world.getWorldInfo().isMapFeaturesEnabled());
    }

    public int getSeaLevel(World world) {
        return this != FLAT ? 64 : 4;
    }

    public boolean hasVoidParticles(boolean flag) {
        return this != FLAT && !flag;
    }

    public double voidFadeMagnitude() {
        return this != FLAT ? 0.03125 : 1.0;
    }
}

