/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Map;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CraftingToolGroup;
import net.minecraft.src.PC_InveditManager;
import net.minecraft.src.PC_Module;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.PC_Struct3;
import net.minecraft.src.PCde_BlockDeco;
import net.minecraft.src.PCde_BlockWalkable;
import net.minecraft.src.PCde_ItemBlockDeco;
import net.minecraft.src.PCde_ItemBlockWalkable;
import net.minecraft.src.PCde_Renderer;
import net.minecraft.src.PCde_TileEntityDeco;
import net.minecraft.src.PCde_TileEntityDecoRenderer;
import net.minecraft.src.PCde_TileEntityWalkable;
import net.minecraft.src.PCde_TileEntityWalkableRenderer;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;

public class mod_PCdeco
extends PC_Module {
    private static final String pk_idDecoBlockSolid = "id.block.decorative";
    private static final String pk_idDecoBlockNonsolid = "id.block.walkable";
    public static Block deco;
    public static Block walkable;

    @Override
    public String getVersion() {
        return "3.4p4";
    }

    public static String getImgDir() {
        return "/PowerCraft/deco/";
    }

    public static String getTerrainFile() {
        return mod_PCdeco.getImgDir() + "tiles.png";
    }

    @Override
    public String getModuleName() {
        return "DECO";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void initProperties(PC_PropertyManager conf) {
        conf.putBlock(pk_idDecoBlockSolid, 233);
        conf.putBlock(pk_idDecoBlockNonsolid, 237);
        conf.apply();
    }

    @Override
    public void registerEntities(List<PC_Struct3<Class<? extends Entity>, String, Integer>> list) {
    }

    @Override
    public void registerTileEntities(List<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>> list) {
        list.add(new PC_Struct3<Class<PCde_TileEntityDeco>, String, PCde_TileEntityDecoRenderer>(PCde_TileEntityDeco.class, "PCdeDecoBlock", new PCde_TileEntityDecoRenderer()));
        list.add(new PC_Struct3<Class<PCde_TileEntityWalkable>, String, PCde_TileEntityWalkableRenderer>(PCde_TileEntityWalkable.class, "PCdeWalkableBlock", new PCde_TileEntityWalkableRenderer()));
    }

    @Override
    public void registerBlockRenderers() {
        PCde_Renderer.decorativeBlockRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PCde_Renderer.walkableBlockRenderer = ModLoader.getUniqueBlockModelID(this, true);
    }

    @Override
    public void registerBlocks(List<Block> list) {
        deco = new PCde_BlockDeco(this.cfg().getInteger(pk_idDecoBlockSolid), 22, Material.rock).setHardness(1.5f).setResistance(5.0f).setBlockName("PCdeDecoBlock").setStepSound(Block.soundMetalFootstep);
        walkable = new PCde_BlockWalkable(this.cfg().getInteger(pk_idDecoBlockNonsolid), 22, Material.rock).setHardness(1.5f).setResistance(5.0f).setBlockName("PCdeWalkableBlock").setStepSound(Block.soundMetalFootstep);
        list.add(deco);
        list.add(walkable);
    }

    @Override
    public void registerItems() {
        mod_PCdeco.removeBlockItem(mod_PCdeco.deco.blockID);
        mod_PCdeco.removeBlockItem(mod_PCdeco.walkable.blockID);
        mod_PCdeco.setBlockItem(mod_PCdeco.deco.blockID, new PCde_ItemBlockDeco(mod_PCdeco.deco.blockID - 256));
        mod_PCdeco.setBlockItem(mod_PCdeco.walkable.blockID, new PCde_ItemBlockWalkable(mod_PCdeco.walkable.blockID - 256));
    }

    @Override
    public void preloadTextures(List<String> list) {
        list.add(mod_PCdeco.getTerrainFile());
        list.add(mod_PCdeco.getImgDir() + "block_deco.png");
    }

    @Override
    public void setTextures() {
    }

    @Override
    public void setNames(Map<Object, String> map) {
        map.put("tile.PCdeDecoBlock.0.name", "Iron Frame");
        map.put("tile.PCdeDecoBlock.1.name", "Redstone Block");
        map.put("tile.PCdeWalkableBlock.0.name", "Iron Ledge");
        map.put("tile.PCdeWalkableBlock.1.name", "Iron Stairs");
    }

    @Override
    public void addRecipes() {
        ModLoader.addRecipe(new ItemStack(deco, 32, 0), new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), Item.ingotIron});
        ModLoader.addRecipe(new ItemStack(deco, 1, 1), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), Item.redstone});
        ModLoader.addShapelessRecipe(new ItemStack(Item.redstone, 9, 0), new Object[]{new ItemStack(deco, 32, 1)});
        ModLoader.addRecipe(new ItemStack(walkable, 16, 0), new Object[]{"X  ", "X  ", "XXX", Character.valueOf('X'), Item.ingotIron});
        ModLoader.addRecipe(new ItemStack(walkable, 8, 1), new Object[]{"X ", " X", Character.valueOf('X'), new ItemStack(walkable, 1, 0)});
    }

    @Override
    public void postInit() {
        PC_InveditManager.setDamageRange(mod_PCdeco.deco.blockID, 0, 2);
        PC_InveditManager.setDamageRange(mod_PCdeco.walkable.blockID, 0, 1);
        PC_InveditManager.setItemCategory(mod_PCdeco.deco.blockID, "Decorative");
        PC_InveditManager.setItemCategory(mod_PCdeco.walkable.blockID, "Decorative");
        mod_PCdeco.addStacksToCraftingTool(PC_CraftingToolGroup.DECORATIVE, new ItemStack(deco, 1, 0), new ItemStack(deco, 1, 1), new ItemStack(walkable, 1, 0), new ItemStack(walkable, 1, 1));
    }

    @Override
    public boolean renderWorldBlock(RenderBlocks renderblocks, IBlockAccess blockAccess, int i, int j, int k, Block block, int rtype) {
        return PCde_Renderer.renderBlockByType(renderblocks, blockAccess, i, j, k, block, rtype);
    }

    @Override
    public void renderInvBlock(RenderBlocks renderblocks, Block block, int i, int rtype) {
        PCde_Renderer.renderInvBlockByType(renderblocks, block, i, rtype);
    }
}

