/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Map;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemFood;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_CraftingToolGroup;
import net.minecraft.src.PC_IActivatorListener;
import net.minecraft.src.PC_InveditManager;
import net.minecraft.src.PC_Module;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.PC_Struct3;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_BlockAutomaticWorkbench;
import net.minecraft.src.PCma_BlockBlockBuilder;
import net.minecraft.src.PCma_BlockHarvester;
import net.minecraft.src.PCma_BlockLaser;
import net.minecraft.src.PCma_BlockOptical;
import net.minecraft.src.PCma_BlockReplacer;
import net.minecraft.src.PCma_BlockRoaster;
import net.minecraft.src.PCma_BlockXPBank;
import net.minecraft.src.PCma_EntityFishingMachine;
import net.minecraft.src.PCma_EntityThrownBucket;
import net.minecraft.src.PCma_EntityThrownFood;
import net.minecraft.src.PCma_ItemBlockOptical;
import net.minecraft.src.PCma_RenderFishingMachine;
import net.minecraft.src.PCma_RenderThrownItem;
import net.minecraft.src.PCma_Renderer;
import net.minecraft.src.PCma_TileEntityAutomaticWorkbench;
import net.minecraft.src.PCma_TileEntityBlockBuilder;
import net.minecraft.src.PCma_TileEntityLaser;
import net.minecraft.src.PCma_TileEntityLaserRenderer;
import net.minecraft.src.PCma_TileEntityOptical;
import net.minecraft.src.PCma_TileEntityOpticalRenderer;
import net.minecraft.src.PCma_TileEntityReplacer;
import net.minecraft.src.PCma_TileEntityRoaster;
import net.minecraft.src.PCma_TileEntityXPBank;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.World;

public class mod_PCmachines
extends PC_Module
implements PC_IActivatorListener {
    public static mod_PCmachines instance;
    public static List<Integer> roasterIgnoreBlockIDs;
    private static boolean dispenseBuckets;
    private static boolean dispenseWheat;
    private static boolean dispenseFood;
    private static boolean dispenseBowls;
    private static final String pk_idHarvester = "id.block.harvester";
    private static final String pk_idBuilder = "id.block.builder";
    private static final String pk_idRoaster = "id.block.roaster";
    private static final String pk_idLaser = "id.block.laser";
    private static final String pk_idXpBank = "id.block.XP_bank";
    private static final String pk_idOptical = "id.block.optical";
    private static final String pk_idACT = "id.block.automatic_workbench";
    private static final String pk_idReplacer = "id.block.replacer";
    private static final String pk_optNoSmeltList = "opt.roaster.ignored_blocks_list";
    private static final String pk_optDispenseBuckets = "opt.dispenser.throw_buckets";
    private static final String pk_optDispenseWheat = "opt.dispenser.throw_wheat";
    private static final String pk_optDispenseFood = "opt.dispenser.throw_all_food";
    private static final String pk_optDispenseBowls = "opt.dispenser.throw_bowls";
    private static final String pk_optAltPrismRecipe = "opt.prism.alternate_recipe";
    public static Block harvester;
    public static Block builder;
    public static Block roaster;
    public static PCma_BlockLaser laser;
    public static Block optical;
    public static PCma_BlockXPBank xpbank;
    public static Block automaticWorkbench;
    public static Block replacer;

    @Override
    public String getVersion() {
        return "3.4p4";
    }

    public static String getImgDir() {
        return "/PowerCraft/machines/";
    }

    public static String getTerrainFile() {
        return mod_PCmachines.getImgDir() + "tiles.png";
    }

    @Override
    public String getModuleName() {
        return "MACHINES";
    }

    @Override
    public void preInit() {
        instance = this;
    }

    @Override
    public void initProperties(PC_PropertyManager conf) {
        conf.putBlock(pk_idHarvester, 221);
        conf.putBlock(pk_idBuilder, 222);
        conf.putBlock(pk_idRoaster, 228);
        conf.putBlock(pk_idLaser, 230);
        conf.putBlock(pk_idXpBank, 231);
        conf.putBlock(pk_idOptical, 234);
        conf.putBlock(pk_idACT, 217);
        conf.putBlock(pk_idReplacer, 238);
        conf.putString(pk_optNoSmeltList, "1", "IDs of items ignored by roaster (prevents smelting)");
        conf.putBoolean(pk_optDispenseBuckets, true, "Thrown buckets can milk cows.");
        conf.putBoolean(pk_optDispenseBowls, true, "Thrown bowls can get soup from mushroom cow.");
        conf.putBoolean(pk_optDispenseWheat, true, "Thrown wheat can put animals into 'love' mode.");
        conf.putBoolean(pk_optDispenseFood, false, "Thrown meat can heal wolves etc.");
        conf.putBoolean(pk_optAltPrismRecipe, false, "Use \"+\" shaped glass recipe instead of the 4-block one.\nNeeded for compatibility with MoCreatures.");
        conf.apply();
        roasterIgnoreBlockIDs = PC_Utils.parseIntList(conf.getString(pk_optNoSmeltList));
        dispenseBuckets = conf.getBoolean(pk_optDispenseBuckets);
        dispenseWheat = conf.getBoolean(pk_optDispenseWheat);
        dispenseFood = conf.getBoolean(pk_optDispenseFood);
        dispenseBowls = conf.getBoolean(pk_optDispenseBowls);
    }

    @Override
    public void registerEntities(List<PC_Struct3<Class<? extends Entity>, String, Integer>> list) {
        list.add(new PC_Struct3<Class<PCma_EntityThrownBucket>, String, Integer>(PCma_EntityThrownBucket.class, "PCma_ThrownBucket", ModLoader.getUniqueEntityId()));
        list.add(new PC_Struct3<Class<PCma_EntityThrownFood>, String, Integer>(PCma_EntityThrownFood.class, "PCma_ThrownFood", ModLoader.getUniqueEntityId()));
        list.add(new PC_Struct3<Class<PCma_EntityFishingMachine>, String, Integer>(PCma_EntityFishingMachine.class, "PCmo_FishingMachine", ModLoader.getUniqueEntityId()));
    }

    @Override
    public void registerTileEntities(List<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>> list) {
        list.add(new PC_Struct3<Class<PCma_TileEntityReplacer>, String, Object>(PCma_TileEntityReplacer.class, "PCReplacer", null));
        list.add(new PC_Struct3<Class<PCma_TileEntityBlockBuilder>, String, Object>(PCma_TileEntityBlockBuilder.class, "FCBlockPlacer", null));
        list.add(new PC_Struct3<Class<PCma_TileEntityRoaster>, String, Object>(PCma_TileEntityRoaster.class, "FCRoaster", null));
        list.add(new PC_Struct3<Class<PCma_TileEntityLaser>, String, PCma_TileEntityLaserRenderer>(PCma_TileEntityLaser.class, "PCLaser", new PCma_TileEntityLaserRenderer()));
        list.add(new PC_Struct3<Class<PCma_TileEntityXPBank>, String, Object>(PCma_TileEntityXPBank.class, "PCXPBank", null));
        list.add(new PC_Struct3<Class<PCma_TileEntityOptical>, String, PCma_TileEntityOpticalRenderer>(PCma_TileEntityOptical.class, "PCLaserMirror", new PCma_TileEntityOpticalRenderer()));
        list.add(new PC_Struct3<Class<PCma_TileEntityAutomaticWorkbench>, String, Object>(PCma_TileEntityAutomaticWorkbench.class, "FCConveyorACT", null));
    }

    @Override
    public void registerBlockRenderers() {
        PCma_Renderer.laserRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PCma_Renderer.xpbankRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PCma_Renderer.opticalRenderer = ModLoader.getUniqueBlockModelID(this, true);
    }

    @Override
    public void registerBlocks(List<Block> list) {
        harvester = new PCma_BlockHarvester(this.cfg().getInteger(pk_idHarvester)).setHardness(0.7f).setResistance(10.0f).setBlockName("PCmaHarvester").setStepSound(Block.soundStoneFootstep);
        builder = new PCma_BlockBlockBuilder(this.cfg().getInteger(pk_idBuilder)).setHardness(0.7f).setResistance(10.0f).setBlockName("PCmaBlockBuilder").setStepSound(Block.soundStoneFootstep);
        roaster = new PCma_BlockRoaster(this.cfg().getInteger(pk_idRoaster)).setHardness(0.7f).setResistance(10.0f).setBlockName("PCmaRoaster").setStepSound(Block.soundStoneFootstep);
        laser = (PCma_BlockLaser)new PCma_BlockLaser(this.cfg().getInteger(pk_idLaser)).setHardness(0.7f).setResistance(10.0f).setBlockName("PCmaLaserBlock").setStepSound(Block.soundStoneFootstep);
        optical = new PCma_BlockOptical(this.cfg().getInteger(pk_idOptical)).setHardness(1.0f).setResistance(4.0f).setBlockName("PCmaOptical").setStepSound(Block.soundStoneFootstep);
        xpbank = (PCma_BlockXPBank)new PCma_BlockXPBank(this.cfg().getInteger(pk_idXpBank)).setHardness(6.0f).setResistance(100.0f).setBlockName("PCmaXPBank").setLightValue(0.5f).setStepSound(Block.soundStoneFootstep);
        automaticWorkbench = new PCma_BlockAutomaticWorkbench(this.cfg().getInteger(pk_idACT)).setHardness(0.7f).setResistance(10.0f).setBlockName("PCmaAutoWorkbench").setStepSound(Block.soundMetalFootstep);
        replacer = new PCma_BlockReplacer(this.cfg().getInteger(pk_idReplacer)).setHardness(0.7f).setResistance(10.0f).setBlockName("PCmaReplacer").setStepSound(Block.soundStoneFootstep);
        list.add(harvester);
        list.add(builder);
        list.add(roaster);
        list.add(laser);
        list.add(xpbank);
        list.add(optical);
        list.add(automaticWorkbench);
        list.add(replacer);
    }

    @Override
    public void registerItems() {
        mod_PCmachines.removeBlockItem(mod_PCmachines.optical.blockID);
        mod_PCmachines.setBlockItem(mod_PCmachines.optical.blockID, new PCma_ItemBlockOptical(mod_PCmachines.optical.blockID - 256));
    }

    @Override
    public void preloadTextures(List<String> list) {
        list.add(mod_PCmachines.getTerrainFile());
        list.add(mod_PCmachines.getImgDir() + "mirror.png");
        list.add(mod_PCmachines.getImgDir() + "laser.png");
        list.add(mod_PCmachines.getImgDir() + "fisher.png");
    }

    @Override
    public void setTextures() {
        mod_PCmachines.harvester.blockIndexInTexture = 109;
        mod_PCmachines.builder.blockIndexInTexture = 109;
        mod_PCmachines.laser.blockIndexInTexture = 16;
        mod_PCmachines.roaster.blockIndexInTexture = 62;
        mod_PCmachines.optical.blockIndexInTexture = 67;
        mod_PCmachines.xpbank.blockIndexInTexture = 37;
        mod_PCmachines.automaticWorkbench.blockIndexInTexture = 109;
        mod_PCmachines.replacer.blockIndexInTexture = 109;
    }

    @Override
    public void setNames(Map<Object, String> map) {
        map.put(replacer, "Block Replacer");
        map.put(harvester, "Block Harvester");
        map.put(builder, "Block Dispenser");
        map.put(roaster, "Roaster");
        map.put(laser, "Laser");
        map.put(xpbank, "Experience Storage");
        map.put(automaticWorkbench, "Automatic Workbench");
        map.put("tile.PCmaOptical.mirror.name", "Laser Mirror");
        map.put("tile.PCmaOptical.prism.name", "Laser Prism");
        map.put("pc.fisher.errWater", "Not enough water!");
        map.put("pc.fisher.errStructure", "Not a valid Fish Machine structure!");
        map.put("pc.fisher.errClickedPlanks", "Fence, not planks!");
        map.put("pc.gui.laserTypeDecide.title", "Select Laser Type");
        map.put("pc.gui.laserTypeDecide.sensor", "Tripwire");
        map.put("pc.gui.laserTypeDecide.redstoneSender", "Transmitter");
        map.put("pc.gui.laserTypeDecide.redstoneReceiver", "Receiver");
        map.put("pc.optical.mirror.desc", "Reflects laser beam");
        map.put("pc.optical.prism.desc", "Splits laser beam");
        map.put("pc.roaster.insertFuel", "fuel");
        map.put("pc.gui.blockReplacer.title", "Block Replacer");
        map.put("pc.gui.blockReplacer.errWrongValue", "Expects a value between -16 and 16.");
        map.put("pc.gui.blockReplacer.err3zeros", "Expects at least 1 value unequal 0.");
    }

    @Override
    public void addRecipes() {
        ModLoader.addRecipe(new ItemStack(builder, 1), new Object[]{"G", "D", Character.valueOf('G'), Item.ingotGold, Character.valueOf('D'), Block.dispenser});
        ModLoader.addRecipe(new ItemStack(harvester, 1), new Object[]{"P", "D", Character.valueOf('P'), Item.pickaxeSteel, Character.valueOf('D'), Block.dispenser});
        ModLoader.addRecipe(new ItemStack(roaster, 1), new Object[]{"III", "IFI", "III", Character.valueOf('I'), Item.ingotIron, Character.valueOf('F'), Item.flintAndSteel});
        ModLoader.addRecipe(new ItemStack(laser, 1), new Object[]{" WD", " S ", "SSS", Character.valueOf('S'), Block.stone, Character.valueOf('W'), new ItemStack(Block.planks, 1, -1), Character.valueOf('D'), Item.diamond});
        ModLoader.addRecipe(new ItemStack(laser, 1), new Object[]{" WD", " S ", "SSS", Character.valueOf('S'), Block.cobblestone, Character.valueOf('W'), new ItemStack(Block.planks, 1, -1), Character.valueOf('D'), Item.diamond});
        ModLoader.addRecipe(new ItemStack(xpbank, 1), new Object[]{"ODO", "OGO", "O O", Character.valueOf('O'), Block.obsidian, Character.valueOf('D'), Block.blockDiamond, Character.valueOf('G'), Item.ghastTear});
        ModLoader.addRecipe(new ItemStack(optical, 2, 0), new Object[]{"GI", " I", Character.valueOf('G'), Block.thinGlass, Character.valueOf('I'), Item.ingotIron});
        if (this.cfg().getBoolean(pk_optAltPrismRecipe).booleanValue()) {
            ModLoader.addRecipe(new ItemStack(optical, 1, 1), new Object[]{" G ", "GGG", " G ", Character.valueOf('G'), Block.glass});
        } else {
            ModLoader.addRecipe(new ItemStack(optical, 1, 1), new Object[]{"GG", "GG", Character.valueOf('G'), Block.glass});
        }
        ModLoader.addRecipe(new ItemStack(automaticWorkbench, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), Item.diamond, Character.valueOf('Y'), Block.workbench, Character.valueOf('Z'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(replacer, 1), new Object[]{"B", "R", "H", Character.valueOf('B'), builder, Character.valueOf('R'), Item.redstone, Character.valueOf('H'), harvester});
    }

    @Override
    public void postInit() {
        PC_Module.registerActivatorListener(this);
        PC_InveditManager.setItemCategory(mod_PCmachines.harvester.blockID, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.builder.blockID, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.roaster.blockID, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.xpbank.blockID, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.automaticWorkbench.blockID, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.replacer.blockID, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.laser.blockID, "Optical");
        PC_InveditManager.setDamageRange(mod_PCmachines.optical.blockID, 0, 1);
        PC_InveditManager.setItemCategory(mod_PCmachines.optical.blockID, "Optical");
        mod_PCmachines.addStacksToCraftingTool(PC_CraftingToolGroup.MACHINES, new ItemStack(harvester), new ItemStack(builder), new ItemStack(replacer), new ItemStack(roaster), new ItemStack(xpbank), new ItemStack(automaticWorkbench));
        mod_PCmachines.addStacksToCraftingTool(PC_CraftingToolGroup.OPTICAL, new ItemStack(laser), new ItemStack(optical, 1, 0), new ItemStack(optical, 1, 1), new ItemStack(Block.thinGlass));
    }

    @Override
    public void addRenderer(Map map) {
        map.put(PCma_EntityThrownBucket.class, new PCma_RenderThrownItem());
        map.put(PCma_EntityThrownFood.class, new PCma_RenderThrownItem());
        map.put(PCma_EntityFishingMachine.class, new PCma_RenderFishingMachine());
    }

    @Override
    public boolean onActivatorUsedOnBlock(ItemStack stack, EntityPlayer player, World world, PC_CoordI pos) {
        PCma_EntityFishingMachine fisher = new PCma_EntityFishingMachine(world);
        if (!fisher.tryToBuildFishingMachine(stack, player, world, pos)) {
            fisher = null;
            return false;
        }
        return true;
    }

    @Override
    public boolean dispenseEntity(World world, double d, double d1, double d2, int i1, int j1, ItemStack itemstack) {
        if (dispenseBuckets && itemstack.itemID == Item.bucketEmpty.shiftedIndex) {
            PCma_EntityThrownBucket entity = new PCma_EntityThrownBucket(world, d, d1, d2, false);
            entity.setThrowableHeading(i1, 0.1, j1, 1.1f, 6.0f);
            world.spawnEntityInWorld(entity);
            world.playAuxSFX(1002, (int)Math.round(d), (int)Math.round(d1), (int)Math.round(d2), 0);
            return true;
        }
        if (dispenseBowls && itemstack.itemID == Item.bowlEmpty.shiftedIndex) {
            PCma_EntityThrownBucket entity = new PCma_EntityThrownBucket(world, d, d1, d2, true);
            entity.setThrowableHeading(i1, 0.1, j1, 1.1f, 6.0f);
            world.spawnEntityInWorld(entity);
            world.playAuxSFX(1002, (int)Math.round(d), (int)Math.round(d1), (int)Math.round(d2), 0);
            return true;
        }
        if (dispenseWheat && itemstack.itemID == Item.wheat.shiftedIndex) {
            PCma_EntityThrownFood entity = new PCma_EntityThrownFood(world, d, d1, d2, itemstack.getItem());
            entity.setThrowableHeading(i1, 0.1, j1, 1.1f, 6.0f);
            world.spawnEntityInWorld(entity);
            world.playAuxSFX(1002, (int)Math.round(d), (int)Math.round(d1), (int)Math.round(d2), 0);
            return true;
        }
        if (dispenseFood && (itemstack.getItem() instanceof ItemFood || itemstack.getItem() == Item.bone)) {
            PCma_EntityThrownFood entity = new PCma_EntityThrownFood(world, d, d1, d2, itemstack.getItem());
            entity.setThrowableHeading(i1, 0.1, j1, 1.1f, 6.0f);
            world.spawnEntityInWorld(entity);
            world.playAuxSFX(1002, (int)Math.round(d), (int)Math.round(d1), (int)Math.round(d2), 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean renderWorldBlock(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block, int renderType) {
        return PCma_Renderer.renderBlockByType(renderblocks, iblockaccess, i, j, k, block, renderType);
    }

    @Override
    public void renderInvBlock(RenderBlocks renderblocks, Block block, int meta, int rtype) {
        PCma_Renderer.renderInvBlockByType(renderblocks, block, meta, rtype);
    }

    static {
        dispenseBuckets = true;
        dispenseWheat = true;
        dispenseFood = false;
        dispenseBowls = true;
    }
}

