/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Map;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CraftingToolGroup;
import net.minecraft.src.PC_InveditManager;
import net.minecraft.src.PC_Module;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.PC_Struct3;
import net.minecraft.src.PCtr_BlockConveyor;
import net.minecraft.src.PCtr_BlockConveyorSeparator;
import net.minecraft.src.PCtr_BlockItemElevator;
import net.minecraft.src.PCtr_BlockTeleporter;
import net.minecraft.src.PCtr_EnumConv;
import net.minecraft.src.PCtr_ItemBlockElevator;
import net.minecraft.src.PCtr_Renderer;
import net.minecraft.src.PCtr_TileEntitySeparationBelt;
import net.minecraft.src.PCtr_TileEntityTeleporter;
import net.minecraft.src.PCtr_TileEntityTeleporterRenderer;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.mod_PCmachines;

public class mod_PCtransport
extends PC_Module {
    public static mod_PCtransport instance;
    public static boolean separate_wood_types;
    public static boolean separate_plank_types;
    private static final String pk_belt = "id.block.conveyor_belt";
    private static final String pk_ejector = "id.block.ejection_belt";
    private static final String pk_detector = "id.block.detection_belt";
    private static final String pk_separator = "id.block.separation_belt";
    private static final String pk_brake = "id.block.brake_belt";
    private static final String pk_redirector = "id.block.redirection_belt";
    private static final String pk_elevator = "id.block.elevator";
    private static final String pk_speedybelt = "id.block.speedy_belt";
    private static final String pk_teleporter = "id.block.teleporter";
    private static final String pk_teleporter_brightness = "brightness.teleporter";
    private static final String pk_woodTypes = "opt.separation.distinguish_wood_types";
    private static final String pk_plankTypes = "opt.separation.distinguish_plank_types";
    public static Block conveyorBelt;
    public static Block ejectionBelt;
    public static Block detectionBelt;
    public static Block separationBelt;
    public static Block brakeBelt;
    public static Block redirectionBelt;
    public static Block itemElevator;
    public static Block speedyBelt;
    public static Block teleporter;

    @Override
    public String getVersion() {
        return "3.4p4";
    }

    public static String getImgDir() {
        return "/PowerCraft/transport/";
    }

    public static String getTerrainFile() {
        return mod_PCtransport.getImgDir() + "tiles.png";
    }

    @Override
    public String getModuleName() {
        return "TRANSPORT";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void initProperties(PC_PropertyManager conf) {
        conf.putBlock(pk_belt, 212);
        conf.putBlock(pk_ejector, 213);
        conf.putBlock(pk_detector, 214);
        conf.putBlock(pk_separator, 215);
        conf.putBlock(pk_brake, 216);
        conf.putBlock(pk_redirector, 218);
        conf.putBlock(pk_elevator, 219);
        conf.putBlock(pk_speedybelt, 220);
        conf.putBlock(pk_teleporter, 235);
        conf.putBoolean(pk_woodTypes, false, "Treat different wood (log) colors as different items.");
        conf.putBoolean(pk_plankTypes, false, "Treat different planks colors as different items");
        conf.putInteger(pk_teleporter_brightness, 5, "Teleporter block brightness, scale 0-15.");
        conf.apply();
        separate_plank_types = conf.getBoolean(pk_plankTypes);
        separate_wood_types = conf.getBoolean(pk_woodTypes);
    }

    @Override
    public void registerEntities(List<PC_Struct3<Class<? extends Entity>, String, Integer>> list) {
    }

    @Override
    public void registerTileEntities(List<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>> list) {
        list.add(new PC_Struct3<Class<PCtr_TileEntitySeparationBelt>, String, Object>(PCtr_TileEntitySeparationBelt.class, "FCConveyorFilter", null));
        list.add(new PC_Struct3<Class<PCtr_TileEntityTeleporter>, String, PCtr_TileEntityTeleporterRenderer>(PCtr_TileEntityTeleporter.class, "PCteleporter", new PCtr_TileEntityTeleporterRenderer()));
    }

    @Override
    public void registerBlockRenderers() {
        PCtr_Renderer.teleporterRenderer = ModLoader.getUniqueBlockModelID(this, true);
    }

    @Override
    public void registerBlocks(List<Block> list) {
        conveyorBelt = new PCtr_BlockConveyor((int)this.cfg().getInteger(pk_belt), PCtr_EnumConv.belt).setHardness(0.22f).setResistance(5.0f).setBlockName("PCconveyorBelt").setStepSound(Block.soundMetalFootstep);
        ejectionBelt = new PCtr_BlockConveyor((int)this.cfg().getInteger(pk_ejector), PCtr_EnumConv.ejector).setHardness(0.22f).setResistance(5.0f).setBlockName("PCconveyorFurnace").setStepSound(Block.soundMetalFootstep);
        detectionBelt = new PCtr_BlockConveyor((int)this.cfg().getInteger(pk_detector), PCtr_EnumConv.detector).setHardness(0.22f).setResistance(5.0f).setBlockName("PCconveyorDetector").setStepSound(Block.soundMetalFootstep);
        separationBelt = new PCtr_BlockConveyorSeparator(this.cfg().getInteger(pk_separator)).setHardness(0.22f).setResistance(5.0f).setBlockName("PCconveyorFilter").setStepSound(Block.soundMetalFootstep);
        brakeBelt = new PCtr_BlockConveyor((int)this.cfg().getInteger(pk_brake), PCtr_EnumConv.brake).setHardness(0.22f).setResistance(5.0f).setBlockName("PCconveyorBrake").setStepSound(Block.soundMetalFootstep);
        redirectionBelt = new PCtr_BlockConveyor((int)this.cfg().getInteger(pk_redirector), PCtr_EnumConv.redirector).setHardness(0.22f).setResistance(5.0f).setBlockName("PCconveyorRedirector").setStepSound(Block.soundMetalFootstep);
        itemElevator = new PCtr_BlockItemElevator((int)this.cfg().getInteger(pk_elevator), 23).setHardness(0.5f).setResistance(8.0f).setBlockName("PCconveyorItemElevator").setStepSound(Block.soundMetalFootstep);
        speedyBelt = new PCtr_BlockConveyor((int)this.cfg().getInteger(pk_speedybelt), PCtr_EnumConv.speedy).setHardness(0.22f).setResistance(5.0f).setBlockName("PCconveyorSpeedBelt").setStepSound(Block.soundMetalFootstep);
        teleporter = new PCtr_BlockTeleporter(this.cfg().getInteger(pk_teleporter), 14, Material.portal).setHardness(1.0f).setResistance(5.0f).setLightValue((float)this.cfg().getInteger(pk_teleporter_brightness).intValue() * 0.0625f).setBlockName("PCteleporter").setStepSound(Block.soundMetalFootstep);
        list.add(conveyorBelt);
        list.add(ejectionBelt);
        list.add(detectionBelt);
        list.add(separationBelt);
        list.add(brakeBelt);
        list.add(redirectionBelt);
        list.add(itemElevator);
        list.add(speedyBelt);
        list.add(teleporter);
    }

    @Override
    public void registerItems() {
        mod_PCtransport.removeBlockItem(mod_PCtransport.itemElevator.blockID);
        mod_PCtransport.setBlockItem(mod_PCtransport.itemElevator.blockID, new PCtr_ItemBlockElevator(mod_PCtransport.itemElevator.blockID - 256));
    }

    @Override
    public void preloadTextures(List<String> list) {
        list.add(mod_PCtransport.getTerrainFile());
        list.add(mod_PCtransport.getImgDir() + "gui_separator.png");
    }

    @Override
    public void setTextures() {
        mod_PCtransport.conveyorBelt.blockIndexInTexture = 1;
        mod_PCtransport.ejectionBelt.blockIndexInTexture = 1;
        mod_PCtransport.detectionBelt.blockIndexInTexture = 1;
        mod_PCtransport.separationBelt.blockIndexInTexture = 1;
        mod_PCtransport.brakeBelt.blockIndexInTexture = 1;
        mod_PCtransport.redirectionBelt.blockIndexInTexture = 1;
        mod_PCtransport.itemElevator.blockIndexInTexture = 23;
        mod_PCtransport.speedyBelt.blockIndexInTexture = 1;
        mod_PCtransport.teleporter.blockIndexInTexture = 14;
    }

    @Override
    public void setNames(Map<Object, String> map) {
        map.put(conveyorBelt, "Conveyor Belt");
        map.put(speedyBelt, "Speedy Conveyor Belt");
        map.put(ejectionBelt, "Item Ejection Belt");
        map.put(detectionBelt, "Item Detector Belt");
        map.put(separationBelt, "Conveyor Item Separator");
        map.put(brakeBelt, "Brake Conveyor");
        map.put(redirectionBelt, "Item Redirection Belt");
        map.put(teleporter, "Teleporter");
        map.put("tile.PCconveyorItemElevator.up.name", "Item Elevator (up)");
        map.put("tile.PCconveyorItemElevator.down.name", "Item Descender (down)");
        map.put("pc.gui.teleporter.set", "SET");
        map.put("pc.gui.teleporter.items", "items");
        map.put("pc.gui.teleporter.animals", "animals");
        map.put("pc.gui.teleporter.monsters", "monsters");
        map.put("pc.gui.teleporter.players", "players");
        map.put("pc.gui.teleporter.dir.north", "north");
        map.put("pc.gui.teleporter.dir.south", "south");
        map.put("pc.gui.teleporter.dir.east", "east");
        map.put("pc.gui.teleporter.dir.west", "west");
        map.put("pc.gui.teleporter.sneak", "Sneak to trigger");
        map.put("pc.gui.teleporter.errIdUsed", "ID already used.");
        map.put("pc.gui.teleporter.errIdRequired", "ID is required!");
        map.put("pc.gui.teleporter.errIdNotFound", "Target not found.");
        map.put("pc.gui.teleporter.errIdDimEnd", "Target is in the End.");
        map.put("pc.gui.teleporter.errIdDimWorld", "Target is in the Overworld.");
        map.put("pc.gui.teleporter.errIdDimNether", "Target is in the Nether.");
        map.put("pc.gui.teleporter.errIdDim", "Target is in other dimension.");
        map.put("pc.gui.teleporter.errTargetRequired", "Target is required.");
        map.put("pc.gui.teleporter.titleSender", "Entity Teleporter - Sender");
        map.put("pc.gui.teleporter.titleTarget", "Entity Teleporter - Target");
        map.put("pc.gui.teleporter.title", "Entity Teleporter");
        map.put("pc.gui.teleporter.linksTo", "Links to (target ID):");
        map.put("pc.gui.teleporter.selectType", "Select device type.");
        map.put("pc.gui.teleporter.selectTypeDescr", "Sender teleports items to target.");
        map.put("pc.gui.teleporter.deviceId", "Device ID:");
        map.put("pc.gui.teleporter.teleportGroup", "Teleport:");
        map.put("pc.gui.teleporter.outputDirection", "Primary output:");
        map.put("pc.gui.teleporter.type.sender", "SENDER");
        map.put("pc.gui.teleporter.type.target", "TARGET");
    }

    @Override
    public void addRecipes() {
        ModLoader.addRecipe(new ItemStack(conveyorBelt, 16), new Object[]{"XXX", "YRY", Character.valueOf('X'), Item.leather, Character.valueOf('Y'), Item.ingotIron, Character.valueOf('R'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(conveyorBelt, 4), new Object[]{"XXX", "YRY", Character.valueOf('X'), Item.paper, Character.valueOf('Y'), Item.ingotIron, Character.valueOf('R'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(speedyBelt, 16), new Object[]{"XXX", "YRY", Character.valueOf('X'), Item.leather, Character.valueOf('Y'), Item.ingotGold, Character.valueOf('R'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(speedyBelt, 4), new Object[]{"XXX", "YRY", Character.valueOf('X'), Item.paper, Character.valueOf('Y'), Item.ingotGold, Character.valueOf('R'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(ejectionBelt, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), Item.bow, Character.valueOf('Y'), conveyorBelt, Character.valueOf('Z'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(detectionBelt, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), Block.pressurePlatePlanks, Character.valueOf('Y'), conveyorBelt, Character.valueOf('Z'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(detectionBelt, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), Block.pressurePlateStone, Character.valueOf('Y'), conveyorBelt, Character.valueOf('Z'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(separationBelt, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), Item.diamond, Character.valueOf('Y'), conveyorBelt, Character.valueOf('Z'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(brakeBelt, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), Item.ingotIron, Character.valueOf('Y'), conveyorBelt, Character.valueOf('Z'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(redirectionBelt, 1), new Object[]{"X", "Y", Character.valueOf('X'), conveyorBelt, Character.valueOf('Y'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(itemElevator, 6, 0), new Object[]{"XGX", "X X", "XGX", Character.valueOf('X'), conveyorBelt, Character.valueOf('G'), Item.ingotGold});
        ModLoader.addRecipe(new ItemStack(itemElevator, 6, 1), new Object[]{"XGX", "XRX", "XGX", Character.valueOf('X'), conveyorBelt, Character.valueOf('G'), Item.ingotGold, Character.valueOf('R'), Item.redstone});
    }

    @Override
    public void postInit() {
        PC_InveditManager.setDamageRange(mod_PCtransport.itemElevator.blockID, 0, 1);
        String ctg = "Transportation";
        PC_InveditManager.setItemCategory(mod_PCtransport.conveyorBelt.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.ejectionBelt.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.detectionBelt.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.redirectionBelt.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.brakeBelt.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.separationBelt.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.speedyBelt.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.itemElevator.blockID, ctg);
        PC_InveditManager.setItemCategory(mod_PCtransport.teleporter.blockID, ctg);
        mod_PCtransport.addStacksToCraftingTool(PC_CraftingToolGroup.TRANSPORT, new ItemStack(conveyorBelt), new ItemStack(speedyBelt), new ItemStack(ejectionBelt), new ItemStack(detectionBelt), new ItemStack(redirectionBelt), new ItemStack(brakeBelt), new ItemStack(separationBelt), new ItemStack(itemElevator, 1, 0), new ItemStack(itemElevator, 1, 1), new ItemStack(teleporter));
    }

    @Override
    public boolean renderWorldBlock(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block, int renderType) {
        return PCtr_Renderer.renderBlockByType(renderblocks, iblockaccess, i, j, k, block, renderType);
    }

    @Override
    public void renderInvBlock(RenderBlocks renderblocks, Block block, int i, int rtype) {
        PCtr_Renderer.renderInvBlockByType(renderblocks, block, i, rtype);
    }

    @Override
    public void modsLoaded() {
        ItemStack prism = PC_Module.isModuleLoaded("MACHINES") ? new ItemStack(mod_PCmachines.optical, 1, 1) : new ItemStack(Block.glass);
        ModLoader.addRecipe(new ItemStack(teleporter, 1, 0), new Object[]{" P ", "PVP", "SSS", Character.valueOf('V'), new ItemStack(Item.dyePowder, 1, 5), Character.valueOf('P'), prism, Character.valueOf('S'), Item.ingotIron});
        super.modsLoaded();
    }

    static {
        separate_wood_types = false;
        separate_plank_types = false;
    }
}

