/*
 * Decompiled with CFR 0.152.
 */
package argo.saj;

import argo.saj.InvalidSyntaxException;
import argo.saj.JsonListener;
import argo.saj.PositionTrackingPushbackReader;
import java.io.Reader;
import java.util.Arrays;

public final class SajParser {
    public void func_27463_a(Reader reader, JsonListener jsonListener) {
        PositionTrackingPushbackReader positionTrackingPushbackReader = new PositionTrackingPushbackReader(reader);
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        switch (c) {
            case '{': {
                positionTrackingPushbackReader.func_27334_a(c);
                jsonListener.func_27195_b();
                this.func_27453_b(positionTrackingPushbackReader, jsonListener);
                break;
            }
            case '[': {
                positionTrackingPushbackReader.func_27334_a(c);
                jsonListener.func_27195_b();
                this.func_27455_a(positionTrackingPushbackReader, jsonListener);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected either [ or { but got [" + c + "].", positionTrackingPushbackReader);
            }
        }
        int n = this.func_27448_l(positionTrackingPushbackReader);
        if (n != -1) {
            throw new InvalidSyntaxException("Got unexpected trailing character [" + (char)n + "].", positionTrackingPushbackReader);
        }
        jsonListener.func_27204_c();
    }

    private void func_27455_a(PositionTrackingPushbackReader positionTrackingPushbackReader, JsonListener jsonListener) {
        char c = (char)this.func_27448_l(positionTrackingPushbackReader);
        if (c != '[') {
            throw new InvalidSyntaxException("Expected object to start with [ but got [" + c + "].", positionTrackingPushbackReader);
        }
        jsonListener.func_27200_d();
        char c2 = (char)this.func_27448_l(positionTrackingPushbackReader);
        positionTrackingPushbackReader.func_27334_a(c2);
        if (c2 != ']') {
            this.func_27464_d(positionTrackingPushbackReader, jsonListener);
        }
        boolean bl = false;
        block4: while (!bl) {
            char c3 = (char)this.func_27448_l(positionTrackingPushbackReader);
            switch (c3) {
                case ',': {
                    this.func_27464_d(positionTrackingPushbackReader, jsonListener);
                    continue block4;
                }
                case ']': {
                    bl = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or ] but got [" + c3 + "].", positionTrackingPushbackReader);
        }
        jsonListener.func_27197_e();
    }

    private void func_27453_b(PositionTrackingPushbackReader positionTrackingPushbackReader, JsonListener jsonListener) {
        char c = (char)this.func_27448_l(positionTrackingPushbackReader);
        if (c != '{') {
            throw new InvalidSyntaxException("Expected object to start with { but got [" + c + "].", positionTrackingPushbackReader);
        }
        jsonListener.func_27194_f();
        char c2 = (char)this.func_27448_l(positionTrackingPushbackReader);
        positionTrackingPushbackReader.func_27334_a(c2);
        if (c2 != '}') {
            this.func_27449_c(positionTrackingPushbackReader, jsonListener);
        }
        boolean bl = false;
        block4: while (!bl) {
            char c3 = (char)this.func_27448_l(positionTrackingPushbackReader);
            switch (c3) {
                case ',': {
                    this.func_27449_c(positionTrackingPushbackReader, jsonListener);
                    continue block4;
                }
                case '}': {
                    bl = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or } but got [" + c3 + "].", positionTrackingPushbackReader);
        }
        jsonListener.func_27203_g();
    }

    private void func_27449_c(PositionTrackingPushbackReader positionTrackingPushbackReader, JsonListener jsonListener) {
        char c = (char)this.func_27448_l(positionTrackingPushbackReader);
        if ('\"' != c) {
            throw new InvalidSyntaxException("Expected object identifier to begin with [\"] but got [" + c + "].", positionTrackingPushbackReader);
        }
        positionTrackingPushbackReader.func_27334_a(c);
        jsonListener.func_27205_a(this.func_27452_i(positionTrackingPushbackReader));
        char c2 = (char)this.func_27448_l(positionTrackingPushbackReader);
        if (c2 != ':') {
            throw new InvalidSyntaxException("Expected object identifier to be followed by : but got [" + c2 + "].", positionTrackingPushbackReader);
        }
        this.func_27464_d(positionTrackingPushbackReader, jsonListener);
        jsonListener.func_27199_h();
    }

    private void func_27464_d(PositionTrackingPushbackReader positionTrackingPushbackReader, JsonListener jsonListener) {
        char c = (char)this.func_27448_l(positionTrackingPushbackReader);
        switch (c) {
            case '\"': {
                positionTrackingPushbackReader.func_27334_a(c);
                jsonListener.func_27198_c(this.func_27452_i(positionTrackingPushbackReader));
                break;
            }
            case 't': {
                char[] cArray = new char[3];
                int n = positionTrackingPushbackReader.func_27336_b(cArray);
                if (n != 3 || cArray[0] != 'r' || cArray[1] != 'u' || cArray[2] != 'e') {
                    positionTrackingPushbackReader.func_27335_a(cArray);
                    throw new InvalidSyntaxException("Expected 't' to be followed by [[r, u, e]], but got [" + Arrays.toString(cArray) + "].", positionTrackingPushbackReader);
                }
                jsonListener.func_27196_i();
                break;
            }
            case 'f': {
                char[] cArray = new char[4];
                int n = positionTrackingPushbackReader.func_27336_b(cArray);
                if (n != 4 || cArray[0] != 'a' || cArray[1] != 'l' || cArray[2] != 's' || cArray[3] != 'e') {
                    positionTrackingPushbackReader.func_27335_a(cArray);
                    throw new InvalidSyntaxException("Expected 'f' to be followed by [[a, l, s, e]], but got [" + Arrays.toString(cArray) + "].", positionTrackingPushbackReader);
                }
                jsonListener.func_27193_j();
                break;
            }
            case 'n': {
                char[] cArray = new char[3];
                int n = positionTrackingPushbackReader.func_27336_b(cArray);
                if (n != 3 || cArray[0] != 'u' || cArray[1] != 'l' || cArray[2] != 'l') {
                    positionTrackingPushbackReader.func_27335_a(cArray);
                    throw new InvalidSyntaxException("Expected 'n' to be followed by [[u, l, l]], but got [" + Arrays.toString(cArray) + "].", positionTrackingPushbackReader);
                }
                jsonListener.func_27202_k();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                positionTrackingPushbackReader.func_27334_a(c);
                jsonListener.func_27201_b(this.func_27459_a(positionTrackingPushbackReader));
                break;
            }
            case '{': {
                positionTrackingPushbackReader.func_27334_a(c);
                this.func_27453_b(positionTrackingPushbackReader, jsonListener);
                break;
            }
            case '[': {
                positionTrackingPushbackReader.func_27334_a(c);
                this.func_27455_a(positionTrackingPushbackReader, jsonListener);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Invalid character at start of value [" + c + "].", positionTrackingPushbackReader);
            }
        }
    }

    private String func_27459_a(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        if ('-' == c) {
            stringBuilder.append('-');
        } else {
            positionTrackingPushbackReader.func_27334_a(c);
        }
        stringBuilder.append(this.func_27451_b(positionTrackingPushbackReader));
        return stringBuilder.toString();
    }

    private String func_27451_b(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        if ('0' == c) {
            stringBuilder.append('0');
            stringBuilder.append(this.func_27462_f(positionTrackingPushbackReader));
            stringBuilder.append(this.func_27454_g(positionTrackingPushbackReader));
        } else {
            positionTrackingPushbackReader.func_27334_a(c);
            stringBuilder.append(this.func_27460_c(positionTrackingPushbackReader));
            stringBuilder.append(this.func_27456_e(positionTrackingPushbackReader));
            stringBuilder.append(this.func_27462_f(positionTrackingPushbackReader));
            stringBuilder.append(this.func_27454_g(positionTrackingPushbackReader));
        }
        return stringBuilder.toString();
    }

    private char func_27460_c(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        char c;
        char c2 = (char)positionTrackingPushbackReader.func_27333_c();
        switch (c2) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                c = c2;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + c2 + "].", positionTrackingPushbackReader);
            }
        }
        return c;
    }

    private char func_27458_d(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        char c;
        char c2 = (char)positionTrackingPushbackReader.func_27333_c();
        switch (c2) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                c = c2;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + c2 + "].", positionTrackingPushbackReader);
            }
        }
        return c;
    }

    private String func_27456_e(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block3: while (!bl) {
            char c = (char)positionTrackingPushbackReader.func_27333_c();
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    stringBuilder.append(c);
                    continue block3;
                }
            }
            bl = true;
            positionTrackingPushbackReader.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27462_f(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        if (c == '.') {
            stringBuilder.append('.');
            stringBuilder.append(this.func_27458_d(positionTrackingPushbackReader));
            stringBuilder.append(this.func_27456_e(positionTrackingPushbackReader));
        } else {
            positionTrackingPushbackReader.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27454_g(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        if (c == '.' || c == 'E') {
            stringBuilder.append('E');
            stringBuilder.append(this.func_27461_h(positionTrackingPushbackReader));
            stringBuilder.append(this.func_27458_d(positionTrackingPushbackReader));
            stringBuilder.append(this.func_27456_e(positionTrackingPushbackReader));
        } else {
            positionTrackingPushbackReader.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27461_h(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        if (c == '+' || c == '-') {
            stringBuilder.append(c);
        } else {
            positionTrackingPushbackReader.func_27334_a(c);
        }
        return stringBuilder.toString();
    }

    private String func_27452_i(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)positionTrackingPushbackReader.func_27333_c();
        if ('\"' != c) {
            throw new InvalidSyntaxException("Expected [\"] but got [" + c + "].", positionTrackingPushbackReader);
        }
        boolean bl = false;
        block4: while (!bl) {
            char c2 = (char)positionTrackingPushbackReader.func_27333_c();
            switch (c2) {
                case '\"': {
                    bl = true;
                    continue block4;
                }
                case '\\': {
                    char c3 = this.func_27457_j(positionTrackingPushbackReader);
                    stringBuilder.append(c3);
                    continue block4;
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private char func_27457_j(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        char c;
        char c2 = (char)positionTrackingPushbackReader.func_27333_c();
        switch (c2) {
            case '\"': {
                c = '\"';
                break;
            }
            case '\\': {
                c = '\\';
                break;
            }
            case '/': {
                c = '/';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'u': {
                c = (char)this.func_27450_k(positionTrackingPushbackReader);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Unrecognised escape character [" + c2 + "].", positionTrackingPushbackReader);
            }
        }
        return c;
    }

    private int func_27450_k(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        int n;
        char[] cArray = new char[4];
        int n2 = positionTrackingPushbackReader.func_27336_b(cArray);
        if (n2 != 4) {
            throw new InvalidSyntaxException("Expected a 4 digit hexidecimal number but got only [" + n2 + "], namely [" + String.valueOf(cArray, 0, n2) + "].", positionTrackingPushbackReader);
        }
        try {
            n = Integer.parseInt(String.valueOf(cArray), 16);
        }
        catch (NumberFormatException numberFormatException) {
            positionTrackingPushbackReader.func_27335_a(cArray);
            throw new InvalidSyntaxException("Unable to parse [" + String.valueOf(cArray) + "] as a hexidecimal number.", numberFormatException, positionTrackingPushbackReader);
        }
        return n;
    }

    private int func_27448_l(PositionTrackingPushbackReader positionTrackingPushbackReader) {
        int n;
        boolean bl = false;
        do {
            n = positionTrackingPushbackReader.func_27333_c();
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
        return n;
    }
}

