/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Floor0$EchstateFloor0;
import com.jcraft.jorbis.Floor0$InfoFloor0;
import com.jcraft.jorbis.Floor0$LookFloor0;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.Lsp;
import com.jcraft.jorbis.Util;
import net.minecraft.src.MathHelper;

class Floor0
extends FuncFloor {
    float[] lsp = null;

    Floor0() {
    }

    void pack(Object object, Buffer buffer) {
        Floor0$InfoFloor0 floor0$InfoFloor0 = (Floor0$InfoFloor0)object;
        buffer.write(floor0$InfoFloor0.order, 8);
        buffer.write(floor0$InfoFloor0.rate, 16);
        buffer.write(floor0$InfoFloor0.barkmap, 16);
        buffer.write(floor0$InfoFloor0.ampbits, 6);
        buffer.write(floor0$InfoFloor0.ampdB, 8);
        buffer.write(floor0$InfoFloor0.numbooks - 1, 4);
        for (int i = 0; i < floor0$InfoFloor0.numbooks; ++i) {
            buffer.write(floor0$InfoFloor0.books[i], 8);
        }
    }

    Object unpack(Info info, Buffer buffer) {
        Floor0$InfoFloor0 floor0$InfoFloor0 = new Floor0$InfoFloor0(this);
        floor0$InfoFloor0.order = buffer.read(8);
        floor0$InfoFloor0.rate = buffer.read(16);
        floor0$InfoFloor0.barkmap = buffer.read(16);
        floor0$InfoFloor0.ampbits = buffer.read(6);
        floor0$InfoFloor0.ampdB = buffer.read(8);
        floor0$InfoFloor0.numbooks = buffer.read(4) + 1;
        if (floor0$InfoFloor0.order < 1 || floor0$InfoFloor0.rate < 1 || floor0$InfoFloor0.barkmap < 1 || floor0$InfoFloor0.numbooks < 1) {
            return null;
        }
        for (int i = 0; i < floor0$InfoFloor0.numbooks; ++i) {
            floor0$InfoFloor0.books[i] = buffer.read(8);
            if (floor0$InfoFloor0.books[i] >= 0 && floor0$InfoFloor0.books[i] < info.books) continue;
            return null;
        }
        return floor0$InfoFloor0;
    }

    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        Floor0$InfoFloor0 floor0$InfoFloor0 = (Floor0$InfoFloor0)object;
        Floor0$LookFloor0 floor0$LookFloor0 = new Floor0$LookFloor0(this);
        floor0$LookFloor0.m = floor0$InfoFloor0.order;
        floor0$LookFloor0.n = info.blocksizes[infoMode.blockflag] / 2;
        floor0$LookFloor0.ln = floor0$InfoFloor0.barkmap;
        floor0$LookFloor0.vi = floor0$InfoFloor0;
        floor0$LookFloor0.lpclook.init(floor0$LookFloor0.ln, floor0$LookFloor0.m);
        float f = (float)floor0$LookFloor0.ln / Floor0.toBARK((float)((double)floor0$InfoFloor0.rate / 2.0));
        floor0$LookFloor0.linearmap = new int[floor0$LookFloor0.n];
        for (int i = 0; i < floor0$LookFloor0.n; ++i) {
            int n = MathHelper.func_1110_d(Floor0.toBARK((float)((double)floor0$InfoFloor0.rate / 2.0 / (double)floor0$LookFloor0.n * (double)i)) * f);
            if (n >= floor0$LookFloor0.ln) {
                n = floor0$LookFloor0.ln;
            }
            floor0$LookFloor0.linearmap[i] = n;
        }
        return floor0$LookFloor0;
    }

    static float toBARK(float f) {
        return (float)(13.1 * Math.atan(7.4E-4 * (double)f) + 2.24 * Math.atan((double)(f * f) * 1.85E-8) + 1.0E-4 * (double)f);
    }

    Object state(Object object) {
        Floor0$EchstateFloor0 floor0$EchstateFloor0 = new Floor0$EchstateFloor0(this);
        Floor0$InfoFloor0 floor0$InfoFloor0 = (Floor0$InfoFloor0)object;
        floor0$EchstateFloor0.codewords = new int[floor0$InfoFloor0.order];
        floor0$EchstateFloor0.curve = new float[floor0$InfoFloor0.barkmap];
        floor0$EchstateFloor0.frameno = -1L;
        return floor0$EchstateFloor0;
    }

    void free_info(Object object) {
    }

    void free_look(Object object) {
    }

    void free_state(Object object) {
    }

    int forward(Block block, Object object, float[] fArray, float[] fArray2, Object object2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int inverse(Block block, Object object, float[] fArray) {
        Floor0$LookFloor0 floor0$LookFloor0 = (Floor0$LookFloor0)object;
        Floor0$InfoFloor0 floor0$InfoFloor0 = floor0$LookFloor0.vi;
        int n = block.opb.read(floor0$InfoFloor0.ampbits);
        if (n > 0) {
            int n2 = (1 << floor0$InfoFloor0.ampbits) - 1;
            float f = (float)n / (float)n2 * (float)floor0$InfoFloor0.ampdB;
            int n3 = block.opb.read(Util.ilog(floor0$InfoFloor0.numbooks));
            if (n3 != -1 && n3 < floor0$InfoFloor0.numbooks) {
                Floor0 floor0 = this;
                synchronized (floor0) {
                    int n4;
                    if (this.lsp == null || this.lsp.length < floor0$LookFloor0.m) {
                        this.lsp = new float[floor0$LookFloor0.m];
                    } else {
                        for (int i = 0; i < floor0$LookFloor0.m; ++i) {
                            this.lsp[i] = 0.0f;
                        }
                    }
                    CodeBook codeBook = block.vd.fullbooks[floor0$InfoFloor0.books[n3]];
                    float f2 = 0.0f;
                    for (n4 = 0; n4 < floor0$LookFloor0.m; ++n4) {
                        fArray[n4] = 0.0f;
                    }
                    for (n4 = 0; n4 < floor0$LookFloor0.m; n4 += codeBook.dim) {
                        if (codeBook.decodevs(this.lsp, n4, block.opb, 1, -1) != -1) continue;
                        for (int i = 0; i < floor0$LookFloor0.n; ++i) {
                            fArray[i] = 0.0f;
                        }
                        return 0;
                    }
                    n4 = 0;
                    while (n4 < floor0$LookFloor0.m) {
                        for (int i = 0; i < codeBook.dim; ++i) {
                            int n5 = n4++;
                            this.lsp[n5] = this.lsp[n5] + f2;
                        }
                        f2 = this.lsp[n4 - 1];
                    }
                    Lsp.lsp_to_curve(fArray, floor0$LookFloor0.linearmap, floor0$LookFloor0.n, floor0$LookFloor0.ln, this.lsp, floor0$LookFloor0.m, f, floor0$InfoFloor0.ampdB);
                    return 1;
                }
            }
        }
        return 0;
    }

    Object inverse1(Block block, Object object, Object object2) {
        int n;
        Floor0$LookFloor0 floor0$LookFloor0 = (Floor0$LookFloor0)object;
        Floor0$InfoFloor0 floor0$InfoFloor0 = floor0$LookFloor0.vi;
        float[] fArray = null;
        if (object2 instanceof float[]) {
            fArray = (float[])object2;
        }
        if ((n = block.opb.read(floor0$InfoFloor0.ampbits)) > 0) {
            int n2 = (1 << floor0$InfoFloor0.ampbits) - 1;
            float f = (float)n / (float)n2 * (float)floor0$InfoFloor0.ampdB;
            int n3 = block.opb.read(Util.ilog(floor0$InfoFloor0.numbooks));
            if (n3 != -1 && n3 < floor0$InfoFloor0.numbooks) {
                int n4;
                CodeBook codeBook = block.vd.fullbooks[floor0$InfoFloor0.books[n3]];
                float f2 = 0.0f;
                if (fArray == null || fArray.length < floor0$LookFloor0.m + 1) {
                    fArray = new float[floor0$LookFloor0.m + 1];
                } else {
                    for (n4 = 0; n4 < fArray.length; ++n4) {
                        fArray[n4] = 0.0f;
                    }
                }
                for (n4 = 0; n4 < floor0$LookFloor0.m; n4 += codeBook.dim) {
                    if (codeBook.decodev_set(fArray, n4, block.opb, codeBook.dim) != -1) continue;
                    return null;
                }
                n4 = 0;
                while (n4 < floor0$LookFloor0.m) {
                    for (int i = 0; i < codeBook.dim; ++i) {
                        int n5 = n4++;
                        fArray[n5] = fArray[n5] + f2;
                    }
                    f2 = fArray[n4 - 1];
                }
                fArray[floor0$LookFloor0.m] = f;
                return fArray;
            }
        }
        return null;
    }

    int inverse2(Block block, Object object, Object object2, float[] fArray) {
        Floor0$LookFloor0 floor0$LookFloor0 = (Floor0$LookFloor0)object;
        Floor0$InfoFloor0 floor0$InfoFloor0 = floor0$LookFloor0.vi;
        if (object2 != null) {
            float[] fArray2 = (float[])object2;
            float f = fArray2[floor0$LookFloor0.m];
            Lsp.lsp_to_curve(fArray, floor0$LookFloor0.linearmap, floor0$LookFloor0.n, floor0$LookFloor0.ln, fArray2, floor0$LookFloor0.m, f, floor0$InfoFloor0.ampdB);
            return 1;
        }
        for (int i = 0; i < floor0$LookFloor0.n; ++i) {
            fArray[i] = 0.0f;
        }
        return 0;
    }

    static float fromdB(float f) {
        return (float)Math.exp((double)f * 0.11512925);
    }

    static void lsp_to_lpc(float[] fArray, float[] fArray2, int n) {
        int n2;
        int n3;
        int n4 = n / 2;
        float[] fArray3 = new float[n4];
        float[] fArray4 = new float[n4];
        float[] fArray5 = new float[n4 + 1];
        float[] fArray6 = new float[n4 + 1];
        float[] fArray7 = new float[n4];
        float[] fArray8 = new float[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            fArray3[n3] = (float)(-2.0 * Math.cos(fArray[n3 * 2]));
            fArray4[n3] = (float)(-2.0 * Math.cos(fArray[n3 * 2 + 1]));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            fArray5[n2] = 0.0f;
            fArray6[n2] = 1.0f;
            fArray7[n2] = 0.0f;
            fArray8[n2] = 1.0f;
        }
        fArray6[n2] = 1.0f;
        fArray5[n2] = 1.0f;
        for (n3 = 1; n3 < n + 1; ++n3) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (n2 = 0; n2 < n4; ++n2) {
                float f3 = fArray3[n2] * fArray6[n2] + fArray5[n2];
                fArray5[n2] = fArray6[n2];
                fArray6[n2] = f2;
                f2 += f3;
                f3 = fArray4[n2] * fArray8[n2] + fArray7[n2];
                fArray7[n2] = fArray8[n2];
                fArray8[n2] = f;
                f += f3;
            }
            fArray2[n3 - 1] = (f2 + fArray6[n2] + f - fArray5[n2]) / 2.0f;
            fArray6[n2] = f2;
            fArray5[n2] = f;
        }
    }

    static void lpc_to_curve(float[] fArray, float[] fArray2, float f, Floor0$LookFloor0 floor0$LookFloor0, String string, int n) {
        float[] fArray3 = new float[Math.max(floor0$LookFloor0.ln * 2, floor0$LookFloor0.m * 2 + 2)];
        if (f == 0.0f) {
            for (int i = 0; i < floor0$LookFloor0.n; ++i) {
                fArray[i] = 0.0f;
            }
            return;
        }
        floor0$LookFloor0.lpclook.lpc_to_curve(fArray3, fArray2, f);
        for (int i = 0; i < floor0$LookFloor0.n; ++i) {
            fArray[i] = fArray3[floor0$LookFloor0.linearmap[i]];
        }
    }
}

