/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.AnvilConverterData;
import net.minecraft.src.AnvilSaveConverterFileFilter;
import net.minecraft.src.AnvilSaveHandler;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.ChunkLoader;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.RegionFile;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.SaveFormatOld;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.WorldChunkManagerHell;
import net.minecraft.src.WorldInfo;
import net.minecraft.src.WorldType;

public class AnvilSaveConverter
extends SaveFormatOld {
    public AnvilSaveConverter(File file) {
        super(file);
    }

    public String func_22178_a() {
        return "Anvil";
    }

    public List func_22176_b() {
        File[] fileArray;
        ArrayList<SaveFormatComparator> arrayList = new ArrayList<SaveFormatComparator>();
        for (File file : fileArray = this.field_22180_a.listFiles()) {
            String string;
            WorldInfo worldInfo;
            if (!file.isDirectory() || (worldInfo = this.func_22173_b(string = file.getName())) == null || worldInfo.func_22296_k() != 19132 && worldInfo.func_22296_k() != 19133) continue;
            boolean bl = worldInfo.func_22296_k() != this.func_48431_c();
            String string2 = worldInfo.func_22302_j();
            if (string2 == null || MathHelper.func_22282_a(string2)) {
                string2 = string;
            }
            long l = 0L;
            arrayList.add(new SaveFormatComparator(string, string2, worldInfo.func_22301_l(), l, worldInfo.func_35918_q(), bl, worldInfo.func_40724_s()));
        }
        return arrayList;
    }

    protected int func_48431_c() {
        return 19133;
    }

    public void func_22177_c() {
        RegionFileCache.func_22192_a();
    }

    public ISaveHandler func_22174_a(String string, boolean bl) {
        return new AnvilSaveHandler(this.field_22180_a, string, bl);
    }

    public boolean func_22175_a(String string) {
        WorldInfo worldInfo = this.func_22173_b(string);
        return worldInfo != null && worldInfo.func_22296_k() != this.func_48431_c();
    }

    public boolean func_22171_a(String string, IProgressUpdate iProgressUpdate) {
        iProgressUpdate.func_593_a(0);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        File file = new File(this.field_22180_a, string);
        File file2 = new File(file, "DIM-1");
        File file3 = new File(file, "DIM1");
        System.out.println("Scanning folders...");
        this.func_48432_a(file, arrayList);
        if (file2.exists()) {
            this.func_48432_a(file2, arrayList2);
        }
        if (file3.exists()) {
            this.func_48432_a(file3, arrayList3);
        }
        int n = arrayList.size() + arrayList2.size() + arrayList3.size();
        System.out.println("Total conversion count is " + n);
        WorldInfo worldInfo = this.func_22173_b(string);
        WorldChunkManager worldChunkManager = null;
        worldChunkManager = worldInfo.func_46133_t() == WorldType.field_48636_c ? new WorldChunkManagerHell(BiomeGenBase.field_35485_c, 0.5f, 0.5f) : new WorldChunkManager(worldInfo.func_22288_b(), worldInfo.func_46133_t());
        this.func_48428_a(new File(file, "region"), arrayList, worldChunkManager, 0, n, iProgressUpdate);
        this.func_48428_a(new File(file2, "region"), arrayList2, new WorldChunkManagerHell(BiomeGenBase.field_4245_l, 1.0f, 0.0f), arrayList.size(), n, iProgressUpdate);
        this.func_48428_a(new File(file3, "region"), arrayList3, new WorldChunkManagerHell(BiomeGenBase.field_28057_m, 0.5f, 0.0f), arrayList.size() + arrayList2.size(), n, iProgressUpdate);
        worldInfo.func_22289_d(19133);
        if (worldInfo.func_46133_t() == WorldType.field_48634_d) {
            worldInfo.func_48619_a(WorldType.field_48635_b);
        }
        this.func_48429_d(string);
        ISaveHandler iSaveHandler = this.func_22174_a(string, false);
        iSaveHandler.func_22152_a(worldInfo);
        return true;
    }

    private void func_48429_d(String string) {
        File file = new File(this.field_22180_a, string);
        if (!file.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file2 = new File(file, "level.dat");
        if (!file2.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file3 = new File(file, "level.dat_mcr");
        if (!file2.renameTo(file3)) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
        }
    }

    private void func_48428_a(File file, ArrayList arrayList, WorldChunkManager worldChunkManager, int n, int n2, IProgressUpdate iProgressUpdate) {
        for (File file2 : arrayList) {
            this.func_48430_a(file, file2, worldChunkManager, n, n2, iProgressUpdate);
            int n3 = (int)Math.round(100.0 * (double)(++n) / (double)n2);
            iProgressUpdate.func_593_a(n3);
        }
    }

    private void func_48430_a(File file, File file2, WorldChunkManager worldChunkManager, int n, int n2, IProgressUpdate iProgressUpdate) {
        try {
            String string = file2.getName();
            RegionFile regionFile = new RegionFile(file2);
            RegionFile regionFile2 = new RegionFile(new File(file, string.substring(0, string.length() - ".mcr".length()) + ".mca"));
            for (int i = 0; i < 32; ++i) {
                int n3;
                for (n3 = 0; n3 < 32; ++n3) {
                    if (!regionFile.func_22202_c(i, n3) || regionFile2.func_22202_c(i, n3)) continue;
                    DataInputStream dataInputStream = regionFile.func_22210_a(i, n3);
                    if (dataInputStream == null) {
                        System.out.println("Failed to fetch input stream");
                        continue;
                    }
                    NBTTagCompound nBTTagCompound = CompressedStreamTools.func_1141_a(dataInputStream);
                    dataInputStream.close();
                    NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_743_k("Level");
                    AnvilConverterData anvilConverterData = ChunkLoader.func_48485_a(nBTTagCompound2);
                    NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                    NBTTagCompound nBTTagCompound4 = new NBTTagCompound();
                    nBTTagCompound3.func_762_a("Level", nBTTagCompound4);
                    ChunkLoader.func_48486_a(anvilConverterData, nBTTagCompound4, worldChunkManager);
                    DataOutputStream dataOutputStream = regionFile2.func_22205_b(i, n3);
                    CompressedStreamTools.func_1139_a(nBTTagCompound3, dataOutputStream);
                    dataOutputStream.close();
                }
                n3 = (int)Math.round(100.0 * (double)(n * 1024) / (double)(n2 * 1024));
                int n4 = (int)Math.round(100.0 * (double)((i + 1) * 32 + n * 1024) / (double)(n2 * 1024));
                if (n4 <= n3) continue;
                iProgressUpdate.func_593_a(n4);
            }
            regionFile.func_22196_b();
            regionFile2.func_22196_b();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_48432_a(File file, ArrayList arrayList) {
        File file2 = new File(file, "region");
        File[] fileArray = file2.listFiles(new AnvilSaveConverterFileFilter(this));
        if (fileArray != null) {
            for (File file3 : fileArray) {
                arrayList.add(file3);
            }
        }
    }
}

