/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.src.NBTTagByte;
import net.minecraft.src.NBTTagByteArray;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagDouble;
import net.minecraft.src.NBTTagEnd;
import net.minecraft.src.NBTTagFloat;
import net.minecraft.src.NBTTagInt;
import net.minecraft.src.NBTTagIntArray;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.NBTTagLong;
import net.minecraft.src.NBTTagShort;
import net.minecraft.src.NBTTagString;

public abstract class NBTBase {
    private String field_1087_a;

    abstract void func_735_a(DataOutput var1);

    abstract void func_736_a(DataInput var1);

    public abstract byte func_733_a();

    protected NBTBase(String string) {
        this.field_1087_a = string == null ? "" : string;
    }

    public NBTBase func_732_a(String string) {
        this.field_1087_a = string == null ? "" : string;
        return this;
    }

    public String func_737_b() {
        if (this.field_1087_a == null) {
            return "";
        }
        return this.field_1087_a;
    }

    public static NBTBase func_734_b(DataInput dataInput) {
        byte by = dataInput.readByte();
        if (by == 0) {
            return new NBTTagEnd();
        }
        String string = dataInput.readUTF();
        NBTBase nBTBase = NBTBase.func_739_a(by, string);
        nBTBase.func_736_a(dataInput);
        return nBTBase;
    }

    public static void func_738_a(NBTBase nBTBase, DataOutput dataOutput) {
        dataOutput.writeByte(nBTBase.func_733_a());
        if (nBTBase.func_733_a() == 0) {
            return;
        }
        dataOutput.writeUTF(nBTBase.func_737_b());
        nBTBase.func_735_a(dataOutput);
    }

    public static NBTBase func_739_a(byte by, String string) {
        switch (by) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte(string);
            }
            case 2: {
                return new NBTTagShort(string);
            }
            case 3: {
                return new NBTTagInt(string);
            }
            case 4: {
                return new NBTTagLong(string);
            }
            case 5: {
                return new NBTTagFloat(string);
            }
            case 6: {
                return new NBTTagDouble(string);
            }
            case 7: {
                return new NBTTagByteArray(string);
            }
            case 11: {
                return new NBTTagIntArray(string);
            }
            case 8: {
                return new NBTTagString(string);
            }
            case 9: {
                return new NBTTagList(string);
            }
            case 10: {
                return new NBTTagCompound(string);
            }
        }
        return null;
    }

    public static String func_731_b(byte by) {
        switch (by) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 11: {
                return "TAG_Int_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
        }
        return "UNKNOWN";
    }

    public abstract NBTBase func_40195_b();

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NBTBase)) {
            return false;
        }
        NBTBase nBTBase = (NBTBase)object;
        if (this.func_733_a() != nBTBase.func_733_a()) {
            return false;
        }
        if (this.field_1087_a == null && nBTBase.field_1087_a != null || this.field_1087_a != null && nBTBase.field_1087_a == null) {
            return false;
        }
        return this.field_1087_a == null || this.field_1087_a.equals(nBTBase.field_1087_a);
    }

    public int hashCode() {
        return this.field_1087_a.hashCode() ^ this.func_733_a();
    }
}

