/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.util.rfc822;

import java.io.IOException;
import java.io.Writer;

public class Header {
    private static final int MAX_HEADER_LINE_LENGTH = 70;
    private String tag;
    private String value;

    public static Header parse(String line) {
        int pos;
        Header header = null;
        if (line != null && (pos = line.indexOf(58)) != -1) {
            header = new Header(line.substring(0, pos).trim(), line.substring(pos + 1).trim());
        }
        return header;
    }

    public Header(String tag, String value) {
        this.tag = tag == null ? "" : tag;
        this.value = value == null ? "" : value;
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        Header header;
        return o instanceof Header && (header = (Header)o).getTag().equals(this.getTag()) && header.getValue().equals(this.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public void writeString(Writer writer) throws IOException {
        String prefix = this.getTag() + ": ";
        String value = this.getValue();
        for (int index = 0; index < value.length(); index += Math.min(value.length() - index, 70 - prefix.length())) {
            int start = index;
            writer.write(prefix + value.substring(start, index) + "\r\n");
            prefix = " ";
        }
    }

    public String toString() {
        return this.getTag() + ": " + this.getValue();
    }
}

