/*
 * Decompiled with CFR 0.152.
 */
import codechicken.nei.API;
import codechicken.nei.IConfigureNEI;
import codechicken.nei.MultiItemRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class NEIPowerCraftConfig
implements IConfigureNEI {
    @Override
    public void loadConfig() {
        PC_Logger.fine("Loading NEI configuration.");
        for (Integer id2 : PC_InveditManager.hidden) {
            API.hideItem(id2);
            PC_Logger.finer("Hiding item ID = " + id2);
        }
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (Integer id3 : PC_InveditManager.damageRanges.keySet()) {
            list.clear();
            Integer[] range = (Integer[])PC_InveditManager.damageRanges.get(id3);
            if (range.length != 2) {
                PC_Logger.severe("Invedit Manager: Invalid damage range for item with ID=" + id3);
                continue;
            }
            list.add(new int[]{range[0], range[1]});
            API.setItemDamageVariants((int)id3, list);
            PC_Logger.finer("Setting item damage variants ID = " + id3 + ", damage range=" + range[0] + " - " + range[1]);
        }
        for (Integer id3 : PC_InveditManager.damageLists.keySet()) {
            Integer[] damageList = (Integer[])PC_InveditManager.damageLists.get(id3);
            List<Integer> col = Arrays.asList(damageList);
            if (col == null || col.size() == 0) {
                PC_Logger.severe("Invedit Manager: Invalid damage list for item with ID=" + id3);
                continue;
            }
            API.setItemDamageVariants((int)id3, col);
            PC_Logger.finer("Setting item damage variants ID = " + id3 + ", collection:");
            for (Integer dmg : col) {
                PC_Logger.finest("" + dmg);
            }
        }
        HashMap categoryLists = new HashMap();
        for (Integer id4 : PC_InveditManager.categories.keySet()) {
            String cat = (String)PC_InveditManager.categories.get(id4);
            if (!categoryLists.containsKey(cat)) {
                categoryLists.put(cat, new HashSet());
            }
            ((HashSet)categoryLists.get(cat)).add(id4);
            PC_Logger.finest("Adding ID = " + id4 + " to category " + cat);
        }
        for (String catname : categoryLists.keySet()) {
            HashSet set = (HashSet)categoryLists.get(catname);
            if (set == null || set.size() <= 0) continue;
            MultiItemRange range = new MultiItemRange();
            for (Integer id5 : set) {
                range.add(id5);
            }
            API.addSetRange("PowerCraft." + catname, range);
        }
    }
}

