/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.lwjgl.input.Keyboard;

public class PC_GresMultiTextEdit
extends PC_GresWidget {
    private static final char br = '\n';
    private PC_CoordI lastMousePosition = new PC_CoordI(0, 0);
    private PC_CoordI mouseSelectStart = new PC_CoordI(0, 0);
    private PC_CoordI mouseSelectEnd = new PC_CoordI(0, 0);
    private int mousePressed = 0;
    private PC_CoordI scroll = new PC_CoordI(0, 0);
    private ArrayList keyWords = null;
    private int vScrollPos = 0;
    private int vScrollSize = 0;
    private int hScrollPos = 0;
    private int hScrollSize = 0;

    public PC_GresMultiTextEdit(String text, int minWidth, int minHeight) {
        super(minWidth > 20 ? minWidth : 20, minHeight > PC_Utils.mc().q.b + 26 ? minHeight : PC_Utils.mc().q.b + 26, text);
        this.canAddWidget = false;
        this.color[0] = -1;
        this.color[1] = -13092808;
        this.color[2] = -1;
        this.color[3] = -13092808;
    }

    public PC_GresMultiTextEdit(String text, int minWidth, int minHeight, ArrayList keyWords) {
        super(minWidth > 20 ? minWidth : 20, minHeight > PC_Utils.mc().q.b + 26 ? minHeight : PC_Utils.mc().q.b + 26, text);
        this.canAddWidget = false;
        this.color[0] = -1;
        this.color[1] = -13092808;
        this.color[2] = -1;
        this.color[3] = -13092808;
        this.keyWords = keyWords;
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public PC_CoordI calcSize() {
        return this.size;
    }

    @Override
    public void calcChildPositions() {
    }

    private int getMaxLineLength() {
        int maxLength = 0;
        int length = 0;
        for (int i2 = 0; i2 <= this.getLineNumbers(); ++i2) {
            length = this.getStringWidth(this.getLine(i2));
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    private void calcScrollPosition() {
        int sizeX = this.size.x - 12;
        int maxSizeX = this.getMaxLineLength();
        int sizeOutOfFrame = maxSizeX - sizeX + 14;
        if (sizeOutOfFrame < 0) {
            sizeOutOfFrame = 0;
        }
        float prozent = maxSizeX > 0 ? (float)sizeOutOfFrame / (float)maxSizeX : 0.0f;
        this.hScrollPos = (int)((double)((sizeOutOfFrame > 0 ? (float)this.scroll.x / (float)sizeOutOfFrame : 0.0f) * prozent * (float)sizeX) + 0.5);
        this.hScrollSize = (int)((double)((1.0f - prozent) * (float)sizeX) + 0.5);
        int lineNumbers = this.getLineNumbers() + 1;
        int linesNotToSee = lineNumbers - this.shownLines();
        if (linesNotToSee < 0) {
            linesNotToSee = 0;
        }
        prozent = lineNumbers > 0 ? (float)linesNotToSee / (float)lineNumbers : 0.0f;
        int sizeY = this.size.y - 12;
        this.vScrollPos = (int)((double)((linesNotToSee > 0 ? (float)this.scroll.y / (float)linesNotToSee : 0.0f) * prozent * (float)sizeY) + 0.5);
        this.vScrollSize = (int)((double)((1.0f - prozent) * (float)sizeY) + 0.5);
        this.updateScrollPosition();
    }

    private void updateScrollPosition() {
        float prozent;
        int sizeX = this.size.x - 12;
        int maxSizeX = this.getMaxLineLength();
        int sizeOutOfFrame = maxSizeX - sizeX + 14;
        if (sizeOutOfFrame < 0) {
            sizeOutOfFrame = 0;
        }
        float f2 = prozent = maxSizeX > 0 ? (float)sizeOutOfFrame / (float)maxSizeX : 0.0f;
        if (this.hScrollPos < 0) {
            this.hScrollPos = 0;
        }
        if (this.hScrollPos > sizeX - this.hScrollSize) {
            this.hScrollPos = sizeX - this.hScrollSize;
        }
        this.scroll.x = (int)((double)((float)this.hScrollPos / prozent / (float)sizeX * (float)sizeOutOfFrame) + 0.5);
        int sizeY = this.size.y - 12;
        int lineNumbers = this.getLineNumbers() + 1;
        int linesNotToSee = lineNumbers - this.shownLines();
        if (linesNotToSee < 0) {
            linesNotToSee = 0;
        }
        float f3 = prozent = lineNumbers > 0 ? (float)linesNotToSee / (float)lineNumbers : 0.0f;
        if (this.vScrollPos < 0) {
            this.vScrollPos = 0;
        }
        if (this.vScrollPos > sizeY - this.vScrollSize) {
            this.vScrollPos = sizeY - this.vScrollSize;
        }
        this.scroll.y = (int)((double)((float)this.vScrollPos / prozent / (float)sizeY * (float)linesNotToSee) + 0.5);
    }

    private int getColorForWord(String word) {
        if (this.keyWords != null) {
            for (Keyword k2 : this.keyWords) {
                if (!k2.word.equalsIgnoreCase(word)) continue;
                return k2.color;
            }
        }
        return -1;
    }

    private boolean yCoordsInDrawRect(int cy2) {
        return cy2 >= this.scroll.y && cy2 < this.scroll.y + this.shownLines();
    }

    private boolean coordsInDrawRect(PC_CoordI c2) {
        if (!this.yCoordsInDrawRect(c2.y)) {
            return false;
        }
        int cx2 = this.getStringWidth(this.getLine(c2.y).substring(0, c2.x));
        return cx2 >= this.scroll.x && cx2 < this.scroll.x + this.size.x - 26;
    }

    private void drawSelect(PC_CoordI offsetPos, int sx2, int ex2, int y2) {
        if (!this.yCoordsInDrawRect(y2)) {
            return;
        }
        String line = this.getLine(y2);
        if (sx2 < 0) {
            sx2 = 0;
        }
        if (ex2 < 0) {
            ex2 = line.length();
        }
        int cy2 = y2 - this.scroll.y;
        int sxx = this.getStringWidth(line.substring(0, sx2)) - this.scroll.x;
        int exx = this.getStringWidth(line.substring(0, ex2)) - this.scroll.x;
        if (sxx < 0) {
            sxx = 0;
        } else if (sxx > this.size.x - 24) {
            return;
        }
        if (exx < 0) {
            return;
        }
        if (exx > this.size.x - 24) {
            exx = this.size.x - 24;
        }
        PC_GresMultiTextEdit.a(offsetPos.x + this.pos.x + sxx + 6, offsetPos.y + this.pos.y + 6 + cy2 * PC_Utils.mc().q.b, offsetPos.x + this.pos.x + exx + 6, offsetPos.y + this.pos.y + 6 + (cy2 + 1) * PC_Utils.mc().q.b, -13395457);
    }

    private void drawWord(PC_CoordI offsetPos, int x2, int y2, String word, boolean highlited) {
        int charSize;
        if (!this.yCoordsInDrawRect(y2)) {
            return;
        }
        int wordlength = this.getStringWidth(word);
        if (x2 > this.size.x + wordlength - 26) {
            return;
        }
        int color = highlited ? this.getColorForWord(word) : -1;
        int strposStart = 0;
        int strSize = 0;
        int sx2 = x2;
        for (strposStart = 0; strposStart < word.length() && sx2 < 0; sx2 += charSize, ++strposStart) {
            charSize = this.getStringWidth("" + word.charAt(strposStart));
        }
        int xp2 = sx2;
        strSize = 0;
        while (strSize + strposStart < word.length() && sx2 <= this.size.x - 25) {
            charSize = this.getStringWidth("" + word.charAt(strposStart + strSize));
            sx2 += charSize;
            ++strSize;
        }
        this.getFontRenderer().a(word.substring(strposStart, strposStart + strSize), offsetPos.x + this.pos.x + 6 + xp2, offsetPos.y + this.pos.y + 6 + (y2 - this.scroll.y) * PC_Utils.mc().q.b, color);
    }

    private void drawStringLine(PC_CoordI offsetPos, int y2) {
        int sx2;
        if (!this.yCoordsInDrawRect(y2)) {
            return;
        }
        String line = this.getLine(y2);
        String word = "";
        int wordStart = sx2 = -this.scroll.x;
        for (int i2 = 0; i2 < line.length(); ++i2) {
            char c2 = line.charAt(i2);
            if (Character.isLetterOrDigit(c2)) {
                if (word.equals("")) {
                    wordStart = sx2;
                }
                word = word + c2;
            } else if (Character.isSpaceChar(c2)) {
                if (!word.equals("")) {
                    this.drawWord(offsetPos, wordStart, y2, word, true);
                }
                word = "";
            } else {
                if (!word.equals("")) {
                    this.drawWord(offsetPos, wordStart, y2, word, true);
                }
                this.drawWord(offsetPos, sx2, y2, "" + c2, true);
                word = "";
            }
            sx2 += this.getStringWidth("" + c2);
        }
        if (!word.equals("")) {
            this.drawWord(offsetPos, wordStart, y2, word, true);
        }
    }

    @Override
    protected void render(PC_CoordI offsetPos) {
        this.a(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y, -6250336);
        this.a(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        this.b(offsetPos.x + this.pos.x, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        this.b(offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 12, -6250336);
        PC_GresMultiTextEdit.a(offsetPos.x + this.pos.x + 1, offsetPos.y + this.pos.y + 1, offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y + this.size.y - 12, -16777216);
        PC_GresMultiTextEdit.a(offsetPos.x + this.pos.x + 1, offsetPos.y + this.pos.y + this.size.y - 11, offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y + this.size.y - 1, -1);
        PC_GresMultiTextEdit.a(offsetPos.x + this.pos.x + this.size.x - 11, offsetPos.y + this.pos.y + 1, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.size.y - 12, -1);
        this.a(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.size.y - 12, -6250336);
        this.b(offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        if (this.mousePressed == 0 || this.mousePressed == 1) {
            this.calcScrollPosition();
        }
        PC_GresMultiTextEdit.a(offsetPos.x + this.pos.x + 1 + this.hScrollPos, offsetPos.y + this.pos.y + this.size.y - 11, offsetPos.x + this.pos.x + this.hScrollPos + this.hScrollSize, offsetPos.y + this.pos.y + this.size.y - 1, -8747521);
        PC_GresMultiTextEdit.a(offsetPos.x + this.pos.x + this.size.x - 11, offsetPos.y + this.pos.y + 1 + this.vScrollPos, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.vScrollPos + this.vScrollSize, -8747521);
        if ((this.mouseSelectStart.x != this.mouseSelectEnd.x || this.mouseSelectStart.y != this.mouseSelectEnd.y) && this.hasFocus) {
            int s2 = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
            int e2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
            PC_CoordI cs2 = this.mouseSelectStart;
            PC_CoordI ce2 = this.mouseSelectEnd;
            if (s2 > e2) {
                cs2 = this.mouseSelectEnd;
                ce2 = this.mouseSelectStart;
            }
            if (this.mouseSelectStart.y == this.mouseSelectEnd.y) {
                if (this.yCoordsInDrawRect(this.mouseSelectStart.y)) {
                    this.drawSelect(offsetPos, cs2.x, ce2.x, cs2.y);
                }
            } else {
                if (this.yCoordsInDrawRect(cs2.y)) {
                    this.drawSelect(offsetPos, cs2.x, -1, cs2.y);
                }
                for (int i2 = cs2.y + 1; i2 < ce2.y; ++i2) {
                    if (!this.yCoordsInDrawRect(i2)) continue;
                    this.drawSelect(offsetPos, 0, -1, i2);
                }
                if (this.yCoordsInDrawRect(ce2.y)) {
                    this.drawSelect(offsetPos, 0, ce2.x, ce2.y);
                }
            }
        }
        for (int i3 = 0; i3 < this.shownLines(); ++i3) {
            this.drawStringLine(offsetPos, i3 + this.scroll.y);
        }
        if (this.hasFocus && this.cursorCounter / 6 % 2 == 0 && this.coordsInDrawRect(new PC_CoordI(this.mouseSelectEnd.x > 0 ? this.mouseSelectEnd.x - 1 : 0, this.mouseSelectEnd.y))) {
            if (this.calcSelectCoordsToStringIndex(this.mouseSelectEnd) == this.text.length()) {
                this.drawString("_", offsetPos.x + this.pos.x + this.getStringWidth(this.getLine(this.mouseSelectEnd.y)) + 6 - this.scroll.x, offsetPos.y + this.pos.y + 6 + (this.mouseSelectEnd.y - this.scroll.y) * PC_Utils.mc().q.b);
            } else {
                this.b(offsetPos.x + this.pos.x + this.getStringWidth(this.getLine(this.mouseSelectEnd.y).substring(0, this.mouseSelectEnd.x)) + 5 - this.scroll.x, offsetPos.y + this.pos.y + 6 + (this.mouseSelectEnd.y - this.scroll.y) * PC_Utils.mc().q.b, offsetPos.y + this.pos.y + 6 + (this.mouseSelectEnd.y - this.scroll.y + 1) * PC_Utils.mc().q.b, this.color[this.enabled ? 0 : 2]);
            }
        }
    }

    @Override
    public boolean mouseOver(PC_CoordI mousePos) {
        return true;
    }

    private String getLine(int line) {
        String s2 = "";
        int pos = 0;
        while (line > 0) {
            if (pos >= this.text.length()) {
                return "";
            }
            if (this.text.charAt(pos) == '\n') {
                --line;
            }
            ++pos;
        }
        while (pos < this.text.length()) {
            if (this.text.charAt(pos) == '\n') {
                return s2;
            }
            s2 = s2 + this.text.charAt(pos);
            ++pos;
        }
        return s2;
    }

    private PC_CoordI getMousePositionInString(PC_CoordI pos) {
        int i2;
        int row = this.scroll.y;
        PC_CoordI coord = null;
        pos = pos.copy();
        pos.x -= 6;
        pos.y -= 6;
        int n2 = pos.y < 0 ? -1 : pos.y / PC_Utils.mc().q.b;
        pos.x += this.scroll.x;
        if ((row += n2) < 0) {
            row = 0;
        }
        String rowText = this.getLine(row);
        for (i2 = 0; i2 < rowText.length(); ++i2) {
            int charSize = this.getStringWidth("" + rowText.charAt(i2));
            if (pos.x - charSize / 2 < 0) {
                coord = new PC_CoordI(i2, row);
                break;
            }
            pos.x -= charSize;
        }
        if ((i2 = this.calcSelectCoordsToStringIndex(coord == null ? new PC_CoordI(rowText.length(), row) : coord)) > this.text.length()) {
            i2 = this.text.length();
        }
        return this.calcStringIndexToSelectCoords(i2);
    }

    private PC_CoordI lineUp() {
        if (this.mouseSelectEnd.y <= 0) {
            return new PC_CoordI(0, 0);
        }
        int xP = this.getStringWidth(this.getLine(this.mouseSelectEnd.y).substring(0, this.mouseSelectEnd.x));
        String rowText = this.getLine(this.mouseSelectEnd.y - 1);
        PC_CoordI coord = null;
        for (int i2 = 0; i2 < rowText.length(); ++i2) {
            int charSize = this.getStringWidth("" + rowText.charAt(i2));
            if (xP - charSize / 2 < 0) {
                coord = new PC_CoordI(i2, this.mouseSelectEnd.y - 1);
                break;
            }
            xP -= charSize;
        }
        return coord == null ? new PC_CoordI(rowText.length(), this.mouseSelectEnd.y - 1) : coord;
    }

    private PC_CoordI lineDown() {
        int i2;
        int xP = this.getStringWidth(this.getLine(this.mouseSelectEnd.y).substring(0, this.mouseSelectEnd.x));
        String rowText = this.getLine(this.mouseSelectEnd.y + 1);
        PC_CoordI coord = null;
        for (i2 = 0; i2 < rowText.length(); ++i2) {
            int charSize = this.getStringWidth("" + rowText.charAt(i2));
            if (xP - charSize / 2 < 0) {
                coord = new PC_CoordI(i2, this.mouseSelectEnd.y + 1);
                break;
            }
            xP -= charSize;
        }
        if ((i2 = this.calcSelectCoordsToStringIndex(coord == null ? new PC_CoordI(rowText.length(), this.mouseSelectEnd.y + 1) : coord)) > this.text.length()) {
            i2 = this.text.length();
        }
        return this.calcStringIndexToSelectCoords(i2);
    }

    @Override
    public boolean mouseClick(PC_CoordI mousePos, int key) {
        this.mousePressed = 0;
        if (!this.enabled) {
            return false;
        }
        this.lastMousePosition.setTo(mousePos);
        if (key != -1) {
            if (mousePos.x < this.size.x - 12 && mousePos.y < this.size.y - 12) {
                this.mouseSelectEnd.setTo(this.getMousePositionInString(mousePos));
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.mousePressed = 1;
                this.setScrollToCursor();
                return true;
            }
            if (mousePos.y < this.size.y - 12) {
                if (mousePos.y - 1 < this.vScrollPos) {
                    --this.scroll.y;
                    return true;
                }
                if (mousePos.y - 1 >= this.vScrollPos + this.vScrollSize) {
                    ++this.scroll.y;
                    return true;
                }
                this.mousePressed = 2;
                return true;
            }
            if (mousePos.x < this.size.x - 12) {
                if (mousePos.x - 1 < this.hScrollPos) {
                    this.scroll.x -= 5;
                    return true;
                }
                if (mousePos.x - 1 >= this.hScrollPos + this.hScrollSize) {
                    this.scroll.x += 5;
                    return true;
                }
                this.mousePressed = 3;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseMove(PC_CoordI mousePos) {
        switch (this.mousePressed) {
            case 1: {
                this.mouseSelectEnd.setTo(this.getMousePositionInString(mousePos));
                this.setScrollToCursor();
                break;
            }
            case 2: {
                this.vScrollPos += mousePos.y - this.lastMousePosition.y;
                this.updateScrollPosition();
                break;
            }
            case 3: {
                this.hScrollPos += mousePos.x - this.lastMousePosition.x;
                this.updateScrollPosition();
            }
        }
        this.lastMousePosition.setTo(mousePos);
    }

    private int calcSelectCoordsToStringIndex(PC_CoordI c2) {
        int pos = 0;
        int line = c2.y;
        while (line > 0) {
            if (pos >= this.text.length()) {
                return pos;
            }
            if (this.text.charAt(pos) == '\n') {
                --line;
            }
            ++pos;
        }
        for (int p2 = c2.x; p2 > 0; --p2) {
            if (pos >= this.text.length()) {
                return pos;
            }
            if (this.text.charAt(pos) == '\n') {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private PC_CoordI calcStringIndexToSelectCoords(int index) {
        int xx2 = 0;
        int yy2 = 0;
        for (int i2 = 0; i2 < index && i2 < this.text.length(); ++i2) {
            if (this.text.charAt(i2) == '\n') {
                ++yy2;
                xx2 = -1;
            }
            ++xx2;
        }
        return new PC_CoordI(xx2, yy2);
    }

    private void addKey(char c2) {
        int e2;
        int s2 = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s2 > (e2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t2 = e2;
            e2 = s2;
            s2 = t2;
        }
        String s1 = this.text.substring(0, s2);
        String s22 = this.text.substring(e2);
        this.text = s1 + c2 + s22;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(++e2));
        this.mouseSelectStart.setTo(this.mouseSelectEnd);
    }

    private void deleteSelected() {
        int e2;
        int s2 = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s2 > (e2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t2 = e2;
            e2 = s2;
            s2 = t2;
        }
        String s1 = this.text.substring(0, s2);
        String s22 = this.text.substring(e2);
        this.text = s1 + s22;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(s2));
        this.mouseSelectStart.setTo(this.mouseSelectEnd);
    }

    private void key_backspace() {
        if (this.mouseSelectStart.x != this.mouseSelectEnd.x || this.mouseSelectStart.y != this.mouseSelectEnd.y) {
            this.deleteSelected();
            return;
        }
        int e2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
        if (e2 <= 0) {
            return;
        }
        String s1 = this.text.substring(0, e2 - 1);
        String s2 = this.text.substring(e2);
        this.text = s1 + s2;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(e2 - 1));
        this.mouseSelectStart.setTo(this.mouseSelectEnd);
    }

    private void key_delete() {
        if (this.mouseSelectStart.x != this.mouseSelectEnd.x || this.mouseSelectStart.y != this.mouseSelectEnd.y) {
            this.deleteSelected();
            return;
        }
        int p2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
        if (p2 >= this.text.length()) {
            return;
        }
        String s1 = this.text.substring(0, p2);
        String s2 = this.text.substring(p2 + 1);
        this.text = s1 + s2;
    }

    private String getSelect() {
        int e2;
        int s2 = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s2 > (e2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t2 = e2;
            e2 = s2;
            s2 = t2;
        }
        return this.text.substring(s2, e2);
    }

    private void setSelected(String stri) {
        int e2;
        int s2 = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s2 > (e2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t2 = e2;
            e2 = s2;
            s2 = t2;
            this.mouseSelectStart.setTo(this.mouseSelectEnd);
        }
        String s1 = this.text.substring(0, s2);
        String s22 = this.text.substring(e2);
        this.text = s1 + stri + s22;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(s2 + stri.length()));
    }

    private int shownLines() {
        return (this.size.y - 26) / PC_Utils.mc().q.b;
    }

    private void setScrollToCursor() {
        int cy2 = this.mouseSelectEnd.y - this.scroll.y;
        if (cy2 < 0) {
            this.scroll.y = this.mouseSelectEnd.y;
        } else if (cy2 >= this.shownLines()) {
            this.scroll.y = this.mouseSelectEnd.y - this.shownLines() + 1;
        }
        String line = this.getLine(this.mouseSelectEnd.y);
        int cxs = this.getStringWidth(line.substring(0, this.mouseSelectEnd.x));
        int cxb = this.mouseSelectEnd.x > 0 ? this.getStringWidth(line.substring(this.mouseSelectEnd.x - 1, this.mouseSelectEnd.x)) : 0;
        int cx2 = cxs - this.scroll.x;
        if (cx2 <= cxb) {
            this.scroll.x = cxs - cxb;
        } else if (cx2 >= this.size.x - 25) {
            this.scroll.x = cxs - this.size.x + 27;
        }
    }

    @Override
    public boolean keyTyped(char c2, int key) {
        if (!this.enabled || !this.hasFocus || this.mousePressed != 0 && this.mousePressed != 1) {
            return false;
        }
        switch (c2) {
            case '\u0003': {
                vp.a(this.getSelect());
                this.setScrollToCursor();
                return true;
            }
            case '\u0016': {
                this.setSelected(vp.h());
                this.setScrollToCursor();
                return true;
            }
            case '\u0018': {
                vp.a(this.getSelect());
                this.deleteSelected();
                this.setScrollToCursor();
                return true;
            }
        }
        switch (key) {
            case 28: {
                this.addKey('\n');
                this.setScrollToCursor();
                return true;
            }
            case 14: {
                this.key_backspace();
                this.setScrollToCursor();
                return true;
            }
            case 211: {
                this.key_delete();
                this.setScrollToCursor();
                return true;
            }
            case 203: {
                int p2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
                if (p2 > 0) {
                    this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(p2 - 1));
                }
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
            case 205: {
                int p2 = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
                if (p2 < this.text.length()) {
                    this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(p2 + 1));
                }
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
            case 200: {
                this.mouseSelectEnd.setTo(this.lineUp());
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
            case 208: {
                this.mouseSelectEnd.setTo(this.lineDown());
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
        }
        if (xn.a(c2)) {
            this.addKey(c2);
            this.setScrollToCursor();
            return true;
        }
        return false;
    }

    private int getLineNumbers() {
        String s2 = "";
        int line = 0;
        for (int i2 = 0; i2 < this.text.length(); ++i2) {
            if (this.text.charAt(i2) != '\n') continue;
            ++line;
        }
        return line;
    }

    @Override
    public void mouseWheel(int i2) {
        int maxY;
        this.scroll.y -= i2;
        if (this.scroll.y < 0) {
            this.scroll.y = 0;
        }
        if ((maxY = this.getLineNumbers() - this.shownLines() + 1) < 0) {
            maxY = 0;
        }
        if (this.scroll.y > maxY) {
            this.scroll.y = maxY;
        }
    }

    @Override
    public void addedToWidget() {
    }

    public static class Keyword {
        public String word;
        public int color;

        public Keyword(String word, int color) {
            this.word = word;
            this.color = color;
        }
    }
}

