/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;

public class PC_Logger {
    private static final Logger logger = Logger.getLogger("PowerCraft");
    private static boolean loggingEnabled;

    public static void enableLogging() {
        loggingEnabled = true;
    }

    public static void disableLogging() {
        loggingEnabled = false;
    }

    public static void info(String msg) {
        if (!loggingEnabled) {
            return;
        }
        logger.log(Level.INFO, msg);
    }

    public static void fine(String msg) {
        if (!loggingEnabled) {
            return;
        }
        logger.log(Level.FINE, msg);
    }

    public static void finer(String msg) {
        if (!loggingEnabled) {
            return;
        }
        logger.log(Level.FINER, msg);
    }

    public static void finest(String msg) {
        if (!loggingEnabled) {
            return;
        }
        logger.log(Level.FINEST, msg);
    }

    public static void warning(String msg) {
        if (!loggingEnabled) {
            return;
        }
        logger.log(Level.WARNING, msg);
    }

    public static void severe(String msg) {
        if (!loggingEnabled) {
            return;
        }
        logger.log(Level.SEVERE, msg);
    }

    public static void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (!loggingEnabled) {
            return;
        }
        logger.throwing(sourceClass, sourceMethod, thrown);
    }

    static {
        try {
            FileHandler handler = new FileHandler(new File(Minecraft.b(), "PowerCraft.log").getPath());
            handler.setFormatter(new PC_LogFormatter());
            logger.addHandler(handler);
            loggingEnabled = true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        logger.setLevel(Level.ALL);
        logger.info("PowerCraft logger initialized.");
        logger.info(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
    }

    private static class PC_LogFormatter
    extends Formatter {
        private static final String nl = System.getProperty("line.separator");

        private PC_LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuffer buf = new StringBuffer(180);
            if (record.getMessage().equals("\n")) {
                return nl;
            }
            if (record.getMessage().charAt(0) == '\n') {
                buf.append(nl);
                record.setMessage(record.getMessage().substring(1));
            }
            Level level = record.getLevel();
            String trail = "";
            if (level == Level.CONFIG) {
                trail = "CONFIG: ";
            }
            if (level == Level.FINE) {
                trail = "";
            }
            if (level == Level.FINER) {
                trail = "\t";
            }
            if (level == Level.FINEST) {
                trail = "\t\t";
            }
            if (level == Level.INFO) {
                trail = "INFO: ";
            }
            if (level == Level.SEVERE) {
                trail = "SEVERE: ";
            }
            if (level == Level.WARNING) {
                trail = "WARNING: ";
            }
            buf.append(trail);
            buf.append(this.formatMessage(record));
            buf.append(nl);
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                buf.append("at ");
                buf.append(record.getSourceClassName());
                buf.append('.');
                buf.append(record.getSourceMethodName());
                buf.append(nl);
                StringWriter sink = new StringWriter();
                throwable.printStackTrace(new PrintWriter((Writer)sink, true));
                buf.append(sink.toString());
                buf.append(nl);
            }
            return buf.toString();
        }
    }
}

