/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;

public abstract class PC_Module
extends BaseMod {
    public static Minecraft mc;
    private PC_PropertyManager conf;
    public PC_Lang lang;
    public static final Hashtable modules;

    public PC_PropertyManager cfg() {
        return this.conf;
    }

    public PC_Module() {
        modules.put(this.getModuleName(), this);
    }

    public abstract String getModuleName();

    public static final boolean isModuleLoaded(String name) {
        return modules.containsKey(name);
    }

    public static final PC_Module getModule(String name) {
        return (PC_Module)modules.get(name);
    }

    @Override
    public abstract String getVersion();

    @Override
    public String getPriorities() {
        return "after:mod_PCcore";
    }

    @Override
    public void modsLoaded() {
        PC_InveditManager.sendToTMI();
    }

    private String getNameTagForObject(Object obj) {
        String name = null;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof yr) {
            yr item = (yr)obj;
            if (item.e() != null) {
                name = String.valueOf(item.e()) + ".name";
            }
        } else if (obj instanceof pb) {
            pb block = (pb)obj;
            if (block.s() != null) {
                name = String.valueOf(block.s()) + ".name";
            }
        } else if (obj instanceof aan) {
            aan itemstack = (aan)obj;
            String s3 = yr.e[itemstack.c].a(itemstack);
            if (s3 != null) {
                name = String.valueOf(s3) + ".name";
            }
        } else {
            PC_Logger.warning("Trying to add name to invalid object (not Block, Item or ItemStack)");
        }
        return name;
    }

    @Override
    public final void load() {
        try {
            if (mc == null) {
                mc = ModLoader.getMinecraftInstance();
                PC_Logger.fine("\nInitializing Minecraft instance.");
            }
            PC_Logger.fine("\n\nLoading module " + this.getModuleName());
            PC_Logger.finer("Calling pre-init hook...");
            this.preInit();
            PC_Logger.finer("Initializing properties...");
            this.conf = new PC_PropertyManager("/PowerCraft/" + this.getModuleName() + ".cfg", "PowerCraft " + this.getModuleName() + " module\nconfiguration file");
            this.initProperties(this.conf);
            PC_Logger.finer("Registering entities...");
            ArrayList entities = new ArrayList();
            this.registerEntities(entities);
            for (PC_Struct3 entry : entities) {
                ModLoader.registerEntityID((Class)entry.getA(), (String)entry.getB(), (Integer)entry.getC());
            }
            PC_Logger.finer("Registering tile entities...");
            ArrayList tileentities = new ArrayList();
            this.registerTileEntities(tileentities);
            for (PC_Struct3 entry : tileentities) {
                if (entry.c == null) {
                    ModLoader.registerTileEntity((Class)entry.a, (String)entry.b);
                    continue;
                }
                ModLoader.registerTileEntity((Class)entry.a, (String)entry.b, (aar)entry.c);
            }
            PC_Logger.finer("Registering block model renderers...");
            this.registerBlockRenderers();
            PC_Logger.finer("Registering blocks...");
            ArrayList blocks = new ArrayList();
            this.registerBlocks(blocks);
            for (pb block : blocks) {
                ModLoader.registerBlock(block);
            }
            PC_Logger.finer("Registering items...");
            this.registerItems();
            PC_Logger.finer("Preloading textures...");
            ArrayList textures = new ArrayList();
            this.preloadTextures(textures);
            for (String texture : textures) {
                PC_Renderer.preloadTexture(texture);
            }
            PC_Logger.finer("Adding texture overrides...");
            this.setTextures();
            PC_Logger.finer("Adding default names...");
            HashMap names = new HashMap();
            HashMap en_US = new HashMap();
            this.setNames(names);
            for (Map.Entry loc : names.entrySet()) {
                if (loc.getKey() == null || loc.getValue() == null) {
                    PC_Logger.severe("Trying to use null when adding names.");
                    continue;
                }
                String nametag = this.getNameTagForObject(loc.getKey());
                if (nametag == null) {
                    PC_Logger.severe("Setting name to invalid object.");
                    continue;
                }
                en_US.put(nametag, loc.getValue());
            }
            this.lang = new PC_Lang(this.getModuleName(), en_US);
            PC_Logger.finer("Generating default translation file (en_US) if not exists");
            this.lang.generateDefaultTranslationFile();
            PC_Logger.finer("Loading translations from /PowerCraft/lang");
            this.lang.loadTranstalions();
            PC_Logger.finer("Adding recipes...");
            this.addRecipes();
            PC_Logger.finer("Calling post-init hook...");
            this.postInit();
            PC_Logger.fine("Module loaded");
        }
        catch (RuntimeException e2) {
            PC_Logger.severe("\nAn error occured, probably due to wrong IDs in your property files.");
            PC_Logger.severe("Read this log file carefully to locate the problem.\n\n");
            PC_Logger.throwing("PowerCraft module " + this.getModuleName() + " - method name: " + this.getName(), "load()", e2);
            throw e2;
        }
    }

    public static final void addStackRangeToCraftingTool(PC_CraftingToolGroup group, int id2, int damage1, int damage2, int stackSize) {
        ArrayList<aan> list = new ArrayList<aan>();
        for (int dmg = damage1; dmg <= damage2; ++dmg) {
            list.add(new aan(id2, stackSize, dmg));
        }
        PCco_CraftingToolManager.addStacks(group.index, list.toArray(new aan[list.size()]));
    }

    public static final void addStacksToCraftingTool(PC_CraftingToolGroup group, aan ... stacks) {
        PCco_CraftingToolManager.addStacks(group.index, stacks);
    }

    public static final void registerActivatorListener(PC_IActivatorListener listener) {
        PCco_ItemActivator.registerListener(listener);
    }

    public static final void removeBlockItem(int id2) {
        yr.e[id2] = null;
    }

    public static final void setBlockItem(int id2, yr item) {
        yr.e[id2] = item;
    }

    public abstract void preInit();

    public abstract void initProperties(PC_PropertyManager var1);

    public abstract void registerEntities(List var1);

    public abstract void registerTileEntities(List var1);

    public abstract void registerBlockRenderers();

    public abstract void registerBlocks(List var1);

    public abstract void registerItems();

    public abstract void preloadTextures(List var1);

    public abstract void setTextures();

    public abstract void setNames(Map var1);

    public abstract void addRecipes();

    public abstract void postInit();

    static {
        modules = new Hashtable();
    }
}

