/*
 * Decompiled with CFR 0.152.
 */
public class PClo_GuiCustomGate
implements PC_IGresBase {
    private PClo_TileEntityGate tileEntity;
    private PC_GresWidget buttonOK;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget edit;
    private PC_GresWidget txError;

    public PClo_GuiCustomGate(PClo_TileEntityGate tileEntity) {
        this.tileEntity = tileEntity;
    }

    @Override
    public yw getPlayer() {
        return PC_Utils.mc().h;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        PC_GresWindow w2 = new PC_GresWindow(PC_Lang.tr("tile.PCloLogicGate.programmable.name"));
        this.edit = new PC_GresTextEdit(this.tileEntity.programm, 20);
        w2.add(this.edit);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        w2.add(this.txError);
        PC_GresWidget hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        hg2.add(new PC_GresButton("L").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton("R").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton("B").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton("(").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton(")").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton("|").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton("&").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton("^").setId(100).setMinWidth(0));
        hg2.add(new PC_GresButton("!").setId(100).setMinWidth(0));
        w2.add(hg2);
        hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg2.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg2.add(this.buttonOK);
        w2.add(hg2);
        gui.add(w2);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    private int isProgrammOK(String program) {
        int i2;
        program = program.trim();
        int h2 = 0;
        if (program.length() < 1) {
            this.txError.setText(PC_Lang.tr("pc.gui.customGate.errProgEq0"));
            return 1;
        }
        if (program.length() == 1) {
            char c2 = program.charAt(0);
            if (c2 == 'l' || c2 == 'L') {
                return 0;
            }
            if (c2 == 'b' || c2 == 'B') {
                return 0;
            }
            if (c2 == 'r' || c2 == 'R') {
                return 0;
            }
            this.txError.setText(PC_Lang.tr("pc.gui.customGate.errUnkChar", new String[]{"" + c2}));
            return 2;
        }
        if (program.charAt(0) == '(') {
            h2 = 1;
            for (i2 = 1; i2 < program.length() - 1; ++i2) {
                if (program.charAt(i2) == '(') {
                    ++h2;
                }
                if (program.charAt(i2) == ')' && --h2 == 0) break;
            }
            if (h2 > 0) {
                if (program.charAt(program.length() - 1) == ')') {
                    return this.isProgrammOK(program.substring(1, program.length() - 1));
                }
                this.txError.setText(PC_Lang.tr("pc.gui.customGate.errUnclosed"));
                return 3;
            }
        }
        h2 = 0;
        block6: for (i2 = program.length() - 1; i2 >= 0; --i2) {
            switch (program.charAt(i2)) {
                case '(': {
                    --h2;
                    continue block6;
                }
                case ')': {
                    ++h2;
                    continue block6;
                }
                case '&': 
                case '^': 
                case '|': {
                    if (h2 > 0) continue block6;
                    int e1 = this.isProgrammOK(program.substring(0, i2));
                    int e2 = this.isProgrammOK(program.substring(i2 + 1));
                    if (e1 == 0 && e2 == 0) {
                        return 0;
                    }
                    if (e1 == 1) {
                        this.txError.setText(PC_Lang.tr("pc.gui.customGate.errNoTextBefore", new String[]{"" + program.charAt(i2)}));
                        return 6;
                    }
                    if (e2 == 1) {
                        this.txError.setText(PC_Lang.tr("pc.gui.customGate.errNoTextBehind", new String[]{"" + program.charAt(i2)}));
                        return 6;
                    }
                    return e1 == 0 ? e2 : e1;
                }
            }
        }
        if (program.charAt(0) == '!') {
            int e2 = this.isProgrammOK(program.substring(1));
            if (e2 == 0) {
                return 0;
            }
            if (e2 == 1) {
                this.txError.setText(PC_Lang.tr("pc.gui.customGate.errNoTextBehind", new String[]{"!"}));
                return 5;
            }
            return e2;
        }
        this.txError.setText(PC_Lang.tr("pc.gui.customGate.errUnkString", new String[]{program}));
        return 4;
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget == this.buttonCancel) {
            gui.close();
        } else if (widget == this.buttonOK) {
            this.txError.setText("");
            if (this.isProgrammOK(this.edit.getText()) == 0) {
                this.tileEntity.programm = this.edit.getText();
                gui.close();
            }
        } else if (widget == this.edit) {
            this.txError.setText("");
            this.isProgrammOK(this.edit.getText());
        } else if (widget.getId() == 100) {
            ((PC_GresTextEdit)this.edit).addKey(widget.getText().charAt(0));
            this.actionPerformed(this.edit, gui);
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(io iinventory) {
    }
}

