/*
 * Decompiled with CFR 0.152.
 */
public class PClo_GuiDelayer
implements PC_IGresBase {
    private PClo_TileEntityGate gateTE;
    private int ticks;
    private boolean error = false;
    private String errMsg = "";
    private int delayer_type;
    public static final int FIFO = 1;
    public static final int HOLD = 0;
    private PC_GresWidget buttonOK;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget edit;
    private PC_GresWidget txConverted;
    private PC_GresWidget txError;

    public PClo_GuiDelayer(PClo_TileEntityGate tep, int type) {
        this.gateTE = tep;
        this.ticks = type == 1 ? this.gateTE.getDelayBufferLength() : this.gateTE.repeaterGetHoldTime();
        this.delayer_type = type;
    }

    @Override
    public yw getPlayer() {
        return PC_Utils.mc().h;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        String title = "";
        if (this.delayer_type == 1) {
            title = PC_Lang.tr("tile.PCloLogicGate.buffer.name");
        }
        if (this.delayer_type == 0) {
            title = PC_Lang.tr("tile.PCloLogicGate.slowRepeater.name");
        }
        PC_GresWindow w2 = new PC_GresWindow(title);
        w2.setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        PC_GresWidget vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        vg2.add(new PC_GresLabel(PC_Lang.tr("pc.gui.gate.delay")));
        this.edit = new PC_GresTextEdit(PC_Utils.floatToString((float)this.ticks * 0.05f), 8, PC_GresTextEdit.PC_GresInputType.SIGNED_FLOAT).setMinWidth(120);
        vg2.add(this.edit);
        this.txConverted = new PC_GresLabelMultiline("", 120).setMinRows(2).setColor(0, 0x606060);
        vg2.add(this.txConverted);
        w2.add(vg2);
        PC_GresWidget hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        hg2.add(this.txError);
        w2.add(hg2);
        hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg2.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg2.add(this.buttonOK);
        w2.add(hg2);
        gui.add(w2);
        gui.setPausesGame(false);
        this.actionPerformed(this.edit, gui);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget.getId() == 0) {
            if (this.delayer_type == 1) {
                this.gateTE.bufferResize(this.ticks);
            } else if (this.delayer_type == 0) {
                this.gateTE.setRepeaterHoldTime(this.ticks);
            }
            gui.close();
        } else if (widget.getId() == 1) {
            gui.close();
        }
        if (widget == this.edit) {
            try {
                double time = Double.parseDouble(this.edit.getText());
                this.ticks = PC_Utils.secsToTicks(time);
                this.error = this.ticks < 2 || this.ticks > 37000;
                this.errMsg = "pc.gui.gate.delayer.errRange";
                this.buttonOK.enabled = !this.error;
            }
            catch (NumberFormatException nfe) {
                this.buttonOK.enabled = false;
                this.error = true;
                this.errMsg = "pc.gui.gate.delayer.errNumFormat";
            }
            catch (NullPointerException npe) {
                this.buttonOK.enabled = false;
                this.error = true;
                this.errMsg = "pc.gui.gate.delayer.errNumFormat";
            }
            if (!this.error) {
                this.errMsg = "";
            }
            this.txError.setText(PC_Lang.tr(this.errMsg));
            String conv = "";
            if (!this.error) {
                conv = conv + "= " + this.ticks + " " + PC_Lang.tr("pc.gui.gate.delayer.ticks");
                if (this.ticks >= 1200) {
                    conv = conv + "\n= " + PC_Utils.formatTimeTicks(this.ticks);
                }
            }
            this.txConverted.setText(conv);
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(io iinventory) {
    }
}

