/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class PCmo_GuiMinerConsole
implements PC_IGresBase {
    private PCmo_EntityMiner miner;
    private PC_GresMultiTextEdit programBox;
    private PC_GresTextEdit appendBox;
    private PC_GresCheckBox checkBridge;
    private PC_GresCheckBox checkMining;
    private PC_GresCheckBox checkLava;
    private PC_GresCheckBox checkWater;
    private PC_GresCheckBox checkKeepFuel;
    private PC_GresCheckBox checkCobble;
    private PC_GresCheckBox checkGravel;
    private PC_GresCheckBox checkDirt;
    private PC_GresCheckBox checkTorchFloor;
    private PC_GresCheckBox checkCompress;
    private PC_GresLabel commandListLength;
    private PC_GresLabel errorString;
    private PC_GresButton quit;
    private PC_GresWidget pgm_clear;
    private PC_GresWidget pgm_run;
    private PC_GresWidget dir_go;
    private PC_GresButton clear_buffer;

    public PCmo_GuiMinerConsole(PCmo_EntityMiner machine) {
        this.miner = machine;
    }

    @Override
    public yw getPlayer() {
        return null;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        PC_GresWidget w2 = new PC_GresWindow(PC_Lang.tr("pc.gui.miner.title")).setAlignH(PC_GresWidget.PC_GresAlign.STRETCH);
        w2.add(new PC_GresLabel(PC_Lang.tr("pc.gui.miner.programCode")));
        ArrayList<PC_GresMultiTextEdit.Keyword> keyWords = new ArrayList<PC_GresMultiTextEdit.Keyword>();
        int keyWordColor = 0xFFFF00;
        int operatorColor = 65280;
        keyWords.add(new PC_GresMultiTextEdit.Keyword("(", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword(")", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("@", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("+", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("-", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("*", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("/", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("%", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("=", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("<", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword(">", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword(":", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("?", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("!", operatorColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("F", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("B", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("L", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("R", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("S", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("N", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("E", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("W", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("U", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("D", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("Q", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("deposit", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("store", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("eject", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("X", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("halt", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("die", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("toblocks", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("blocks", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("M", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("mining", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("mine", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("mi", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("B", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("bridge", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("br", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("L", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("lava", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("W", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("water", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("on", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("off", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("loop", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("and", keyWordColor));
        keyWords.add(new PC_GresMultiTextEdit.Keyword("RND", keyWordColor));
        this.programBox = new PC_GresMultiTextEdit(this.miner.program, 250, 60, keyWords);
        w2.add(this.programBox);
        PC_GresWidget hg2 = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.RIGHT);
        this.errorString = new PC_GresLabel("");
        this.errorString.setColor(0, 0x990000);
        this.errorString.setColor(1, 0x999999);
        hg2.add(this.errorString);
        this.pgm_clear = new PC_GresButton(PC_Lang.tr("pc.gui.miner.clear")).setMinWidth(40);
        hg2.add(this.pgm_clear);
        this.pgm_run = new PC_GresButton(PC_Lang.tr("pc.gui.miner.run")).setMinWidth(40);
        hg2.add(this.pgm_run);
        w2.add(hg2);
        hg2 = new PC_GresLayoutH();
        this.appendBox = new PC_GresTextEdit("", 20);
        hg2.add(this.appendBox);
        this.dir_go = new PC_GresButton(PC_Lang.tr("pc.gui.miner.go")).setMinWidth(40);
        hg2.add(this.dir_go);
        w2.add(hg2);
        hg2 = new PC_GresLayoutH();
        PC_GresWidget vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        this.checkMining = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.mining")).check(this.miner.miningEnabled);
        vg2.add(this.checkMining);
        this.checkBridge = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.bridge")).check(this.miner.bridgeEnabled);
        vg2.add(this.checkBridge);
        this.checkLava = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.lavaFill")).check(this.miner.lavaFillingEnabled);
        vg2.add(this.checkLava);
        this.checkWater = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.waterFill")).check(this.miner.waterFillingEnabled);
        vg2.add(this.checkWater);
        this.checkKeepFuel = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.keepFuel")).check(this.miner.keepAllFuel);
        vg2.add(this.checkKeepFuel);
        hg2.add(vg2);
        this.checkBridge.enable(this.miner.level >= 3);
        this.checkLava.enable(this.miner.level >= 4);
        this.checkWater.enable(this.miner.level >= 6);
        this.pgm_run.enable(this.miner.program.length() > 0);
        this.dir_go.enable(false);
        vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.LEFT);
        this.checkCobble = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.destroyCobble")).check((this.miner.DESTROY & 1) != 0);
        vg2.add(this.checkCobble);
        this.checkGravel = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.destroyGravel")).check((this.miner.DESTROY & 4) != 0);
        vg2.add(this.checkGravel);
        this.checkDirt = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.destroyDirt")).check((this.miner.DESTROY & 2) != 0);
        vg2.add(this.checkDirt);
        this.checkTorchFloor = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.torchesOnFloor")).check(this.miner.torchesOnlyOnFloor);
        vg2.add(this.checkTorchFloor);
        this.checkCompress = new PC_GresCheckBox(PC_Lang.tr("pc.gui.miner.opt.compress")).check(this.miner.compressBlocks);
        vg2.add(this.checkCompress);
        hg2.add(vg2);
        vg2 = new PC_GresLayoutV().setAlignH(PC_GresWidget.PC_GresAlign.STRETCH);
        this.commandListLength = new PC_GresLabel(".." + this.miner.commandList.length());
        vg2.add(this.commandListLength);
        this.clear_buffer = new PC_GresButton(PC_Lang.tr("pc.gui.miner.reset"));
        vg2.add(this.clear_buffer);
        this.quit = new PC_GresButton(PC_Lang.tr("pc.gui.miner.quit"));
        vg2.add(this.quit);
        hg2.add(vg2);
        w2.add(hg2);
        gui.add(w2);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
        this.miner.openedGui = false;
        this.miner.programmingGuiOpen = false;
        this.miner.miningEnabled = this.checkMining.isChecked();
        this.miner.bridgeEnabled = this.checkBridge.isChecked();
        this.miner.lavaFillingEnabled = this.checkLava.isChecked();
        this.miner.waterFillingEnabled = this.checkWater.isChecked();
        this.miner.keepAllFuel = this.checkKeepFuel.isChecked();
        this.miner.torchesOnlyOnFloor = this.checkTorchFloor.isChecked();
        this.miner.compressBlocks = this.checkCompress.isChecked();
        this.miner.DESTROY = (byte)((this.checkCobble.isChecked() ? 1 : 0) | (this.checkGravel.isChecked() ? 4 : 0) | (this.checkDirt.isChecked() ? 2 : 0));
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (!widget.isEnabled()) {
            return;
        }
        if (widget == this.quit) {
            this.miner.program = this.programBox.getText().trim();
            gui.close();
        } else if (widget == this.pgm_clear) {
            this.programBox.setText("");
        } else if (widget == this.clear_buffer) {
            this.miner.resetEverything();
        } else if (widget == this.pgm_run) {
            this.miner.program = this.programBox.getText().trim();
            this.errorString.setText("");
            try {
                this.miner.runNewProgram();
                gui.close();
            }
            catch (PCmo_CommandException err) {
                this.errorString.setText(err.getError());
            }
        } else if (widget == this.dir_go) {
            this.errorString.setText("");
            try {
                this.miner.setCode(this.appendBox.getText().trim());
                gui.close();
            }
            catch (PCmo_CommandException err) {
                this.errorString.setText(err.getError());
            }
        } else if (widget == this.programBox) {
            this.pgm_run.enable(this.programBox.getText().length() > 0);
        } else if (widget == this.appendBox) {
            this.dir_go.enable(this.appendBox.getText().length() > 0);
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onCraftMatrixChanged(io iinventory) {
    }
}

