/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class PCmo_MinerControlHandler {
    public static List controlledMiners = new ArrayList();
    static xd lastTickWorld = null;
    private static int[] keyPressTimer = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int CooldownTime = 8;

    public static void disconnectMinerFromKeyboardControl(PCmo_EntityMiner miner, boolean silent) {
        lastTickWorld = ModLoader.getMinecraftInstance().f;
        if (controlledMiners.contains(miner)) {
            controlledMiners.remove(miner);
        }
        if (!silent) {
            PC_Utils.chatMsg(PC_Lang.tr("pc.miner.disconnected", new String[]{miner.level + ""}), true);
        }
    }

    public static boolean sendCommandToMiners(int cmd) {
        boolean flag = false;
        for (PCmo_EntityMiner miner : controlledMiners) {
            if (!miner.canReceiveKeyboardCommand()) continue;
            flag = true;
            miner.receiveKeyboardCommand(cmd);
        }
        return flag;
    }

    private static boolean sendSequenceToMiners(String seq) {
        boolean flag = false;
        for (PCmo_EntityMiner miner : controlledMiners) {
            if (!miner.canReceiveKeyboardCommand()) continue;
            flag = true;
            try {
                miner.appendCode(seq);
            }
            catch (PCmo_CommandException ce2) {
                PC_Logger.severe("Error in keyboard-sent command! This is a bug!");
                return false;
            }
        }
        return flag;
    }

    public static boolean sendUrgentCommandToMiners(int cmd) {
        boolean flag = false;
        for (PCmo_EntityMiner miner : controlledMiners) {
            if (!miner.canReceiveKeyboardCommand()) continue;
            flag = true;
            miner.receiveKeyboardCommand(cmd);
        }
        return flag;
    }

    private static boolean sendSafelyUrgentCommandToMiners(int cmd) {
        boolean flag = false;
        ArrayList<PCmo_EntityMiner> controlled2 = new ArrayList<PCmo_EntityMiner>();
        for (PCmo_EntityMiner miner : controlledMiners) {
            controlled2.add(miner);
        }
        for (PCmo_EntityMiner miner : controlled2) {
            if (!miner.canReceiveKeyboardCommand()) continue;
            flag = true;
            miner.receiveKeyboardCommand(cmd);
        }
        return flag;
    }

    public static void setMinerForKeyboardControl(PCmo_EntityMiner miner, boolean silent) {
        lastTickWorld = ModLoader.getMinecraftInstance().f;
        if (!controlledMiners.contains(miner)) {
            controlledMiners.add(miner);
        }
        if (!silent) {
            PC_Utils.chatMsg(PC_Lang.tr("pc.miner.connected", new String[]{miner.level + ""}), true);
        }
    }

    public static void onGameTick() {
        if (lastTickWorld != ModLoader.getMinecraftInstance().f) {
            controlledMiners.clear();
            lastTickWorld = ModLoader.getMinecraftInstance().f;
        }
        if (lastTickWorld == null) {
            return;
        }
        if (ModLoader.getMinecraftInstance().s != null) {
            return;
        }
        for (int i2 = 0; i2 <= 8; ++i2) {
            if (keyPressTimer[i2] <= 0) continue;
            int n2 = i2;
            keyPressTimer[n2] = keyPressTimer[n2] - 1;
        }
        PC_PropertyManager conf = mod_PCmobile.instance.cfg();
        if (ModLoader.getMinecraftInstance().f != null && lastTickWorld == ModLoader.getMinecraftInstance().f) {
            if (conf.isKeyDown("key.miner.move_forward").booleanValue()) {
                if (keyPressTimer[0] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[0] = 8;
                    PCmo_MinerControlHandler.sendCommandToMiners(0);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.turn_left").booleanValue()) {
                if (keyPressTimer[1] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[1] = 8;
                    PCmo_MinerControlHandler.sendCommandToMiners(1);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.turn_right").booleanValue()) {
                if (keyPressTimer[2] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[2] = 8;
                    PCmo_MinerControlHandler.sendCommandToMiners(2);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.turn_around").booleanValue()) {
                if (keyPressTimer[3] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[3] = 8;
                    PCmo_MinerControlHandler.sendSequenceToMiners("RR");
                }
                return;
            }
            if (conf.isKeyDown("key.miner.move_backward").booleanValue()) {
                if (keyPressTimer[4] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[4] = 8;
                    PCmo_MinerControlHandler.sendCommandToMiners(3);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.mine_down").booleanValue()) {
                if (keyPressTimer[5] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[5] = 8;
                    PCmo_MinerControlHandler.sendCommandToMiners(8);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.mine_up").booleanValue()) {
                if (keyPressTimer[6] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[6] = 8;
                    PCmo_MinerControlHandler.sendCommandToMiners(9);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.set_bridge_on").booleanValue()) {
                if (PCmo_MinerControlHandler.sendCommandToMiners(14)) {
                    PC_Utils.chatMsg(PC_Lang.tr("pc.miner.bridgeOn"), true);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.set_bridge_off").booleanValue()) {
                if (PCmo_MinerControlHandler.sendCommandToMiners(15)) {
                    PC_Utils.chatMsg(PC_Lang.tr("pc.miner.bridgeOff"), true);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.store_to_chest").booleanValue()) {
                if (keyPressTimer[7] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[7] = 8;
                    PCmo_MinerControlHandler.sendCommandToMiners(10);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.run_program").booleanValue()) {
                if (keyPressTimer[8] == 0) {
                    PCmo_MinerControlHandler.keyPressTimer[8] = 8;
                    if (PCmo_MinerControlHandler.sendSafelyUrgentCommandToMiners(-3)) {
                        PC_Utils.chatMsg(PC_Lang.tr("pc.miner.launchedAll"), true);
                    }
                }
                return;
            }
            if (conf.isKeyDown("key.miner.deactivate").booleanValue()) {
                PCmo_MinerControlHandler.sendUrgentCommandToMiners(11);
                return;
            }
            if (conf.isKeyDown("key.miner.set_mining_on").booleanValue()) {
                if (PCmo_MinerControlHandler.sendCommandToMiners(12)) {
                    PC_Utils.chatMsg(PC_Lang.tr("pc.miner.miningOn"), true);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.set_mining_off").booleanValue()) {
                if (PCmo_MinerControlHandler.sendCommandToMiners(13)) {
                    PC_Utils.chatMsg(PC_Lang.tr("pc.miner.miningOff"), true);
                }
                return;
            }
            if (conf.isKeyDown("key.miner.reset").booleanValue()) {
                if (PCmo_MinerControlHandler.sendUrgentCommandToMiners(-2)) {
                    PC_Utils.chatMsg(PC_Lang.tr("pc.miner.operationsCancelled"), true);
                }
                return;
            }
        }
    }
}

