/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.client.Minecraft;

public class PCtr_TeleporterEntry {
    private static Minecraft mc = ModLoader.getMinecraftInstance();
    public int i = 0;
    public int j = 0;
    public int k = 0;
    public String identifier;
    public int dimension = 0;

    public PCtr_TeleporterEntry(int pi2, int pj2, int pk2) {
        this.setPos(pi2, pj2, pk2);
    }

    public PCtr_TeleporterEntry(int pi2, int pj2, int pk2, String id2) {
        this.setPos(pi2, pj2, pk2);
        this.setIdentifier(id2);
        this.setDimension(PCtr_TeleporterEntry.mc.f.x.i());
    }

    public PCtr_TeleporterEntry(int pi2, int pj2, int pk2, String id2, int dim) {
        this.setPos(pi2, pj2, pk2);
        this.setIdentifier(id2);
        this.setDimension(dim);
    }

    public PCtr_TeleporterEntry(String file) {
        this.load(file);
    }

    public PCtr_TeleporterEntry copy() {
        return new PCtr_TeleporterEntry(this.i, this.j, this.k, this.identifier);
    }

    public void load(String file) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
        }
        catch (IOException e2) {
            return;
        }
        try {
            this.setPos(Integer.valueOf(props.getProperty("x")), Integer.valueOf(props.getProperty("y")), Integer.valueOf(props.getProperty("z")));
            this.setIdentifier(props.getProperty("id"));
            this.setDimension(props.getProperty("dim"));
        }
        catch (NumberFormatException nfe) {
            return;
        }
    }

    public void removeFile() {
        PC_Logger.finest("Deleting teleporter's file.");
        File f2 = new File(this.getSavePath(PCtr_TeleporterEntry.mc.f));
        if (!f2.exists()) {
            PC_Logger.warning("file does not exist");
            return;
        }
        if (!f2.canWrite()) {
            PC_Logger.warning("file not accessible");
            return;
        }
        if (f2.isDirectory()) {
            PC_Logger.warning("file is dir");
            return;
        }
        f2.delete();
    }

    public void save() {
        new File(PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterEntry.mc.f)).mkdirs();
        Properties props = new Properties();
        props.setProperty("x", Integer.toString(this.i));
        props.setProperty("y", Integer.toString(this.j));
        props.setProperty("z", Integer.toString(this.k));
        props.setProperty("id", this.identifier);
        props.setProperty("dim", Integer.toString(this.dimension));
        try {
            props.store(new FileOutputStream(this.getSavePath(PCtr_TeleporterEntry.mc.f)), "Teleporter save file - do not touch!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PC_CoordI getCoord() {
        return new PC_CoordI(this.i, this.j, this.k);
    }

    public static String getSaveDir(xd world) {
        if (mc == null || world == null) {
            return null;
        }
        return ((eg)world.w).a().toString().concat("/teleporter/");
    }

    private String getSavePath(xd world) {
        if (mc == null || world == null) {
            return null;
        }
        return ((eg)world.w).a().toString().concat("/teleporter/").concat(this.getIdentifier()).concat(".dat");
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getI() {
        return this.i;
    }

    public int getJ() {
        return this.j;
    }

    public int getK() {
        return this.k;
    }

    public int getX() {
        return this.i;
    }

    public int getY() {
        return this.j;
    }

    public int getZ() {
        return this.k;
    }

    private void setDimension(int dim) {
        this.dimension = dim;
    }

    private void setDimension(String property) {
        int dim;
        if (property == null) {
            this.dimension = 0;
            return;
        }
        try {
            dim = Integer.parseInt(property);
        }
        catch (NumberFormatException e2) {
            dim = 0;
        }
        this.dimension = dim;
    }

    public void setIdentifier(String id2) {
        this.identifier = id2;
    }

    public void setPos(int i2, int j2, int k2) {
        this.i = i2;
        this.j = j2;
        this.k = k2;
    }
}

