/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Hashtable;
import net.minecraft.client.Minecraft;

public class PCtr_TeleporterHelper {
    public static Minecraft mc = ModLoader.getMinecraftInstance();
    private static Hashtable targets = new Hashtable();
    private static boolean listsLoaded = false;
    private static xd listsWorld = null;
    private static String listSaveDir = null;

    private static void loadAllLists() {
        listsWorld = PCtr_TeleporterHelper.mc.f;
        listSaveDir = PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterHelper.mc.f);
        listsLoaded = true;
        PCtr_TeleporterHelper.loadDevices();
    }

    private static void loadIfNeeded() {
        if (listsWorld == null || listSaveDir == null || !listsLoaded || listsWorld != PCtr_TeleporterHelper.mc.f || !listSaveDir.equals(PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterHelper.mc.f))) {
            PC_Logger.fine("Loading teleporter list...");
            targets.clear();
            PCtr_TeleporterHelper.loadAllLists();
        }
    }

    private static void loadDevices() {
        String dirPath = PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterHelper.mc.f);
        File dir = new File(dirPath);
        String[] children = dir.list();
        if (children == null) {
            return;
        }
        for (String filename : children) {
            PCtr_TeleporterHelper.loadSingleDevice(dirPath + filename);
        }
    }

    private static void loadSingleDevice(String filePath) {
        PCtr_TeleporterEntry entry = new PCtr_TeleporterEntry(filePath);
        PC_CoordI coord = entry.getCoord();
        if (!PCtr_TeleporterHelper.isTeleporter(PCtr_TeleporterHelper.mc.f.a(coord.x, coord.y, coord.z))) {
            entry.dimension = PCtr_TeleporterHelper.mc.h.aB == 0 ? -1 : 0;
        }
        targets.put(new String(entry.getIdentifier()), entry);
        for (PCtr_TeleporterEntry e2 : targets.values()) {
            e2.save();
        }
    }

    private static PC_CoordI getTargetCoord(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        PCtr_TeleporterEntry e2 = (PCtr_TeleporterEntry)targets.get(identifier);
        if (e2 == null) {
            return null;
        }
        return e2.getCoord();
    }

    public static boolean targetExists(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (identifier.equals("")) {
            return false;
        }
        return targets.get(identifier) != null;
    }

    public static boolean targetExistsExcept(String identifier, PC_CoordI coord) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (identifier.equals("")) {
            return false;
        }
        PCtr_TeleporterEntry entry = (PCtr_TeleporterEntry)targets.get(identifier);
        return entry != null && !entry.getCoord().equals(coord);
    }

    public static boolean isTargetInThisDimension(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        return PCtr_TeleporterHelper.mc.h.aB == PCtr_TeleporterHelper.getTargetDimension(identifier);
    }

    public static int getTargetDimension(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (identifier.equals("")) {
            return 0;
        }
        PCtr_TeleporterEntry entry = (PCtr_TeleporterEntry)targets.get(identifier);
        if (entry == null) {
            return 0;
        }
        return entry.getDimension();
    }

    public static void registerNewDevice(int i2, int j2, int k2, String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        int dim = PCtr_TeleporterHelper.mc.h.aB;
        PCtr_TeleporterEntry newDev = new PCtr_TeleporterEntry(i2, j2, k2, identifier, dim);
        newDev.save();
        targets.put(identifier, newDev);
    }

    public static boolean renameDevice(String id1, String id2) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (!PCtr_TeleporterHelper.targetExists(id1) || PCtr_TeleporterHelper.targetExists(id2)) {
            return false;
        }
        PCtr_TeleporterEntry dev = (PCtr_TeleporterEntry)targets.get(id1);
        if (dev == null) {
            return false;
        }
        dev.removeFile();
        dev.setIdentifier(id2);
        dev.save();
        targets.put(id2, dev.copy());
        targets.remove(id1);
        return true;
    }

    public static void unregisterDevice(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        PCtr_TeleporterEntry dev = (PCtr_TeleporterEntry)targets.get(identifier);
        if (dev == null) {
            return;
        }
        dev.removeFile();
        targets.remove(identifier);
    }

    private static final boolean isTeleporter(int id2) {
        return id2 == mod_PCtransport.teleporter.bO;
    }

    public static boolean teleportEntityTo(nn entity, String target) {
        PC_CoordI tc2 = PCtr_TeleporterHelper.getTargetCoord(target);
        if (tc2 == null) {
            return false;
        }
        xd world = entity.k;
        if (world.a(tc2.x, tc2.y, tc2.z) != mod_PCtransport.teleporter.bO) {
            return false;
        }
        PCtr_TileEntityTeleporter tet = (PCtr_TileEntityTeleporter)tc2.getTileEntity(world);
        if (tet == null) {
            return false;
        }
        int[] good = new int[]{0, 0, 0, 0};
        PC_CoordI[] coords = new PC_CoordI[]{new PC_CoordI(0, 0, -1), new PC_CoordI(1, 0, 0), new PC_CoordI(0, 0, 1), new PC_CoordI(-1, 0, 0)};
        String[] side = new String[]{"N", "E", "S", "W"};
        for (int i2 = 0; i2 < 4; ++i2) {
            PC_CoordI tmp = tc2.offset(coords[i2]);
            if (PC_BlockUtils.hasFlag(world, tmp, "BELT") && !PC_BlockUtils.hasFlag(world, tmp, "TELEPORTER")) {
                int meta = tmp.getMeta(world);
                int rotation = PCtr_BlockConveyor.getRotation_(meta);
                if (rotation == i2) {
                    good[i2] = 3;
                } else if (rotation != (i2 + 2) % 4) {
                    good[i2] = 2;
                }
            } else if (!PCtr_BlockConveyor.isBlocked(world, tmp.x, tmp.y, tmp.z)) {
                good[i2] = 1;
            }
            if (tet.direction.equals(side[i2])) {
                int n2 = i2;
                good[n2] = good[n2] + 1;
            }
            if (!PC_BlockUtils.hasFlag(world, tmp, "TELEPORTER")) continue;
            good[i2] = 0;
        }
        if (good[0] + good[1] + good[2] + good[3] > 0) {
            for (int need = 6; need > 0; --need) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    if (good[i3] < need) continue;
                    entity.l = entity.N = (double)((float)tc2.x + 0.5f) + (double)coords[i3].x * 0.7;
                    entity.o = entity.N;
                    entity.m = entity.O = (double)((float)tc2.y + entity.H + 0.2f);
                    entity.p = entity.O;
                    entity.n = entity.P = (double)((float)tc2.z + 0.5f) + (double)coords[i3].z * 0.7;
                    entity.q = entity.P;
                    entity.d(entity.o, entity.p, entity.q);
                    entity.r = (float)coords[i3].x * 0.2f;
                    entity.t = (float)coords[i3].z * 0.2f;
                    entity.u = (float)i3 * 90.0f + 180.0f;
                    entity.M = 0.0f;
                    entity.L = 0.0f;
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

