/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import java.util.Map;

public class mod_PCmachines
extends PC_Module
implements PC_IActivatorListener {
    public static mod_PCmachines instance;
    public static List roasterIgnoreBlockIDs;
    private static boolean dispenseBuckets;
    private static boolean dispenseWheat;
    private static boolean dispenseFood;
    private static boolean dispenseBowls;
    private static final String pk_idHarvester = "id.block.harvester";
    private static final String pk_idBuilder = "id.block.builder";
    private static final String pk_idRoaster = "id.block.roaster";
    private static final String pk_idLaser = "id.block.laser";
    private static final String pk_idXpBank = "id.block.XP_bank";
    private static final String pk_idOptical = "id.block.optical";
    private static final String pk_idACT = "id.block.automatic_workbench";
    private static final String pk_idReplacer = "id.block.replacer";
    private static final String pk_optNoSmeltList = "opt.roaster.ignored_blocks_list";
    private static final String pk_optDispenseBuckets = "opt.dispenser.throw_buckets";
    private static final String pk_optDispenseWheat = "opt.dispenser.throw_wheat";
    private static final String pk_optDispenseFood = "opt.dispenser.throw_all_food";
    private static final String pk_optDispenseBowls = "opt.dispenser.throw_bowls";
    private static final String pk_optAltPrismRecipe = "opt.prism.alternate_recipe";
    public static pb harvester;
    public static pb builder;
    public static pb roaster;
    public static PCma_BlockLaser laser;
    public static pb optical;
    public static PCma_BlockXPBank xpbank;
    public static pb automaticWorkbench;
    public static pb replacer;

    @Override
    public String getVersion() {
        return "3.4p4";
    }

    public static String getImgDir() {
        return "/PowerCraft/machines/";
    }

    public static String getTerrainFile() {
        return mod_PCmachines.getImgDir() + "tiles.png";
    }

    @Override
    public String getModuleName() {
        return "MACHINES";
    }

    @Override
    public void preInit() {
        instance = this;
    }

    @Override
    public void initProperties(PC_PropertyManager conf) {
        conf.putBlock(pk_idHarvester, 221);
        conf.putBlock(pk_idBuilder, 222);
        conf.putBlock(pk_idRoaster, 228);
        conf.putBlock(pk_idLaser, 230);
        conf.putBlock(pk_idXpBank, 231);
        conf.putBlock(pk_idOptical, 234);
        conf.putBlock(pk_idACT, 217);
        conf.putBlock(pk_idReplacer, 238);
        conf.putString(pk_optNoSmeltList, "1", "IDs of items ignored by roaster (prevents smelting)");
        conf.putBoolean(pk_optDispenseBuckets, true, "Thrown buckets can milk cows.");
        conf.putBoolean(pk_optDispenseBowls, true, "Thrown bowls can get soup from mushroom cow.");
        conf.putBoolean(pk_optDispenseWheat, true, "Thrown wheat can put animals into 'love' mode.");
        conf.putBoolean(pk_optDispenseFood, false, "Thrown meat can heal wolves etc.");
        conf.putBoolean(pk_optAltPrismRecipe, false, "Use \"+\" shaped glass recipe instead of the 4-block one.\nNeeded for compatibility with MoCreatures.");
        conf.apply();
        roasterIgnoreBlockIDs = PC_Utils.parseIntList(conf.getString(pk_optNoSmeltList));
        dispenseBuckets = conf.getBoolean(pk_optDispenseBuckets);
        dispenseWheat = conf.getBoolean(pk_optDispenseWheat);
        dispenseFood = conf.getBoolean(pk_optDispenseFood);
        dispenseBowls = conf.getBoolean(pk_optDispenseBowls);
    }

    @Override
    public void registerEntities(List list) {
        list.add(new PC_Struct3(PCma_EntityThrownBucket.class, "PCma_ThrownBucket", ModLoader.getUniqueEntityId()));
        list.add(new PC_Struct3(PCma_EntityThrownFood.class, "PCma_ThrownFood", ModLoader.getUniqueEntityId()));
        list.add(new PC_Struct3(PCma_EntityFishingMachine.class, "PCmo_FishingMachine", ModLoader.getUniqueEntityId()));
    }

    @Override
    public void registerTileEntities(List list) {
        list.add(new PC_Struct3(PCma_TileEntityReplacer.class, "PCReplacer", null));
        list.add(new PC_Struct3(PCma_TileEntityBlockBuilder.class, "FCBlockPlacer", null));
        list.add(new PC_Struct3(PCma_TileEntityRoaster.class, "FCRoaster", null));
        list.add(new PC_Struct3(PCma_TileEntityLaser.class, "PCLaser", new PCma_TileEntityLaserRenderer()));
        list.add(new PC_Struct3(PCma_TileEntityXPBank.class, "PCXPBank", null));
        list.add(new PC_Struct3(PCma_TileEntityOptical.class, "PCLaserMirror", new PCma_TileEntityOpticalRenderer()));
        list.add(new PC_Struct3(PCma_TileEntityAutomaticWorkbench.class, "FCConveyorACT", null));
    }

    @Override
    public void registerBlockRenderers() {
        PCma_Renderer.laserRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PCma_Renderer.xpbankRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PCma_Renderer.opticalRenderer = ModLoader.getUniqueBlockModelID(this, true);
    }

    @Override
    public void registerBlocks(List list) {
        harvester = new PCma_BlockHarvester(this.cfg().getInteger(pk_idHarvester)).c(0.7f).b(10.0f).a("PCmaHarvester").a(pb.h);
        builder = new PCma_BlockBlockBuilder(this.cfg().getInteger(pk_idBuilder)).c(0.7f).b(10.0f).a("PCmaBlockBuilder").a(pb.h);
        roaster = new PCma_BlockRoaster(this.cfg().getInteger(pk_idRoaster)).c(0.7f).b(10.0f).a("PCmaRoaster").a(pb.h);
        laser = (PCma_BlockLaser)new PCma_BlockLaser(this.cfg().getInteger(pk_idLaser)).c(0.7f).b(10.0f).a("PCmaLaserBlock").a(pb.h);
        optical = new PCma_BlockOptical(this.cfg().getInteger(pk_idOptical)).c(1.0f).b(4.0f).a("PCmaOptical").a(pb.h);
        xpbank = (PCma_BlockXPBank)new PCma_BlockXPBank(this.cfg().getInteger(pk_idXpBank)).c(6.0f).b(100.0f).a("PCmaXPBank").a(0.5f).a(pb.h);
        automaticWorkbench = new PCma_BlockAutomaticWorkbench(this.cfg().getInteger(pk_idACT)).c(0.7f).b(10.0f).a("PCmaAutoWorkbench").a(pb.i);
        replacer = new PCma_BlockReplacer(this.cfg().getInteger(pk_idReplacer)).c(0.7f).b(10.0f).a("PCmaReplacer").a(pb.h);
        list.add(harvester);
        list.add(builder);
        list.add(roaster);
        list.add(laser);
        list.add(xpbank);
        list.add(optical);
        list.add(automaticWorkbench);
        list.add(replacer);
    }

    @Override
    public void registerItems() {
        mod_PCmachines.removeBlockItem(mod_PCmachines.optical.bO);
        mod_PCmachines.setBlockItem(mod_PCmachines.optical.bO, new PCma_ItemBlockOptical(mod_PCmachines.optical.bO - 256));
    }

    @Override
    public void preloadTextures(List list) {
        list.add(mod_PCmachines.getTerrainFile());
        list.add(mod_PCmachines.getImgDir() + "mirror.png");
        list.add(mod_PCmachines.getImgDir() + "laser.png");
        list.add(mod_PCmachines.getImgDir() + "fisher.png");
    }

    @Override
    public void setTextures() {
        mod_PCmachines.harvester.bN = 109;
        mod_PCmachines.builder.bN = 109;
        mod_PCmachines.laser.bN = 16;
        mod_PCmachines.roaster.bN = 62;
        mod_PCmachines.optical.bN = 67;
        mod_PCmachines.xpbank.bN = 37;
        mod_PCmachines.automaticWorkbench.bN = 109;
        mod_PCmachines.replacer.bN = 109;
    }

    @Override
    public void setNames(Map map) {
        map.put(replacer, "Block Replacer");
        map.put(harvester, "Block Harvester");
        map.put(builder, "Block Dispenser");
        map.put(roaster, "Roaster");
        map.put(laser, "Laser");
        map.put(xpbank, "Experience Storage");
        map.put(automaticWorkbench, "Automatic Workbench");
        map.put("tile.PCmaOptical.mirror.name", "Laser Mirror");
        map.put("tile.PCmaOptical.prism.name", "Laser Prism");
        map.put("pc.fisher.errWater", "Not enough water!");
        map.put("pc.fisher.errStructure", "Not a valid Fish Machine structure!");
        map.put("pc.fisher.errClickedPlanks", "Fence, not planks!");
        map.put("pc.gui.laserTypeDecide.title", "Select Laser Type");
        map.put("pc.gui.laserTypeDecide.sensor", "Tripwire");
        map.put("pc.gui.laserTypeDecide.redstoneSender", "Transmitter");
        map.put("pc.gui.laserTypeDecide.redstoneReceiver", "Receiver");
        map.put("pc.optical.mirror.desc", "Reflects laser beam");
        map.put("pc.optical.prism.desc", "Splits laser beam");
        map.put("pc.roaster.insertFuel", "fuel");
        map.put("pc.gui.blockReplacer.title", "Block Replacer");
        map.put("pc.gui.blockReplacer.errWrongValue", "Expects a value between -16 and 16.");
        map.put("pc.gui.blockReplacer.err3zeros", "Expects at least 1 value unequal 0.");
    }

    @Override
    public void addRecipes() {
        ModLoader.addRecipe(new aan(builder, 1), new Object[]{"G", "D", Character.valueOf('G'), yr.p, Character.valueOf('D'), pb.P});
        ModLoader.addRecipe(new aan(harvester, 1), new Object[]{"P", "D", Character.valueOf('P'), yr.g, Character.valueOf('D'), pb.P});
        ModLoader.addRecipe(new aan(roaster, 1), new Object[]{"III", "IFI", "III", Character.valueOf('I'), yr.o, Character.valueOf('F'), yr.i});
        ModLoader.addRecipe(new aan(laser, 1), new Object[]{" WD", " S ", "SSS", Character.valueOf('S'), pb.t, Character.valueOf('W'), new aan(pb.x, 1, -1), Character.valueOf('D'), yr.n});
        ModLoader.addRecipe(new aan(laser, 1), new Object[]{" WD", " S ", "SSS", Character.valueOf('S'), pb.w, Character.valueOf('W'), new aan(pb.x, 1, -1), Character.valueOf('D'), yr.n});
        ModLoader.addRecipe(new aan(xpbank, 1), new Object[]{"ODO", "OGO", "O O", Character.valueOf('O'), pb.ap, Character.valueOf('D'), pb.ax, Character.valueOf('G'), yr.bp});
        ModLoader.addRecipe(new aan(optical, 2, 0), new Object[]{"GI", " I", Character.valueOf('G'), pb.bq, Character.valueOf('I'), yr.o});
        if (this.cfg().getBoolean(pk_optAltPrismRecipe).booleanValue()) {
            ModLoader.addRecipe(new aan(optical, 1, 1), new Object[]{" G ", "GGG", " G ", Character.valueOf('G'), pb.M});
        } else {
            ModLoader.addRecipe(new aan(optical, 1, 1), new Object[]{"GG", "GG", Character.valueOf('G'), pb.M});
        }
        ModLoader.addRecipe(new aan(automaticWorkbench, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), yr.n, Character.valueOf('Y'), pb.ay, Character.valueOf('Z'), yr.aC});
        ModLoader.addRecipe(new aan(replacer, 1), new Object[]{"B", "R", "H", Character.valueOf('B'), builder, Character.valueOf('R'), yr.aC, Character.valueOf('H'), harvester});
    }

    @Override
    public void postInit() {
        PC_Module.registerActivatorListener(this);
        PC_InveditManager.setItemCategory(mod_PCmachines.harvester.bO, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.builder.bO, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.roaster.bO, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.xpbank.bO, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.automaticWorkbench.bO, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.replacer.bO, "Machines");
        PC_InveditManager.setItemCategory(mod_PCmachines.laser.bO, "Optical");
        PC_InveditManager.setDamageRange(mod_PCmachines.optical.bO, 0, 1);
        PC_InveditManager.setItemCategory(mod_PCmachines.optical.bO, "Optical");
        mod_PCmachines.addStacksToCraftingTool(PC_CraftingToolGroup.MACHINES, new aan(harvester), new aan(builder), new aan(replacer), new aan(roaster), new aan(xpbank), new aan(automaticWorkbench));
        mod_PCmachines.addStacksToCraftingTool(PC_CraftingToolGroup.OPTICAL, new aan(laser), new aan(optical, 1, 0), new aan(optical, 1, 1), new aan(pb.bq));
    }

    @Override
    public void addRenderer(Map map) {
        map.put(PCma_EntityThrownBucket.class, new PCma_RenderThrownItem());
        map.put(PCma_EntityThrownFood.class, new PCma_RenderThrownItem());
        map.put(PCma_EntityFishingMachine.class, new PCma_RenderFishingMachine());
    }

    @Override
    public boolean onActivatorUsedOnBlock(aan stack, yw player, xd world, PC_CoordI pos) {
        PCma_EntityFishingMachine fisher = new PCma_EntityFishingMachine(world);
        if (!fisher.tryToBuildFishingMachine(stack, player, world, pos)) {
            fisher = null;
            return false;
        }
        return true;
    }

    @Override
    public boolean dispenseEntity(xd world, double d2, double d1, double d22, int i1, int j1, aan itemstack) {
        if (dispenseBuckets && itemstack.c == yr.aw.bQ) {
            PCma_EntityThrownBucket entity = new PCma_EntityThrownBucket(world, d2, d1, d22, false);
            entity.a(i1, 0.1, j1, 1.1f, 6.0f);
            world.a(entity);
            world.g(1002, (int)Math.round(d2), (int)Math.round(d1), (int)Math.round(d22), 0);
            return true;
        }
        if (dispenseBowls && itemstack.c == yr.E.bQ) {
            PCma_EntityThrownBucket entity = new PCma_EntityThrownBucket(world, d2, d1, d22, true);
            entity.a(i1, 0.1, j1, 1.1f, 6.0f);
            world.a(entity);
            world.g(1002, (int)Math.round(d2), (int)Math.round(d1), (int)Math.round(d22), 0);
            return true;
        }
        if (dispenseWheat && itemstack.c == yr.T.bQ) {
            PCma_EntityThrownFood entity = new PCma_EntityThrownFood(world, d2, d1, d22, itemstack.a());
            entity.a(i1, 0.1, j1, 1.1f, 6.0f);
            world.a(entity);
            world.g(1002, (int)Math.round(d2), (int)Math.round(d1), (int)Math.round(d22), 0);
            return true;
        }
        if (dispenseFood && (itemstack.a() instanceof amm || itemstack.a() == yr.aX)) {
            PCma_EntityThrownFood entity = new PCma_EntityThrownFood(world, d2, d1, d22, itemstack.a());
            entity.a(i1, 0.1, j1, 1.1f, 6.0f);
            world.a(entity);
            world.g(1002, (int)Math.round(d2), (int)Math.round(d1), (int)Math.round(d22), 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean renderWorldBlock(vl renderblocks, ali iblockaccess, int i2, int j2, int k2, pb block, int renderType) {
        return PCma_Renderer.renderBlockByType(renderblocks, iblockaccess, i2, j2, k2, block, renderType);
    }

    @Override
    public void renderInvBlock(vl renderblocks, pb block, int meta, int rtype) {
        PCma_Renderer.renderInvBlockByType(renderblocks, block, meta, rtype);
    }

    static {
        dispenseBuckets = true;
        dispenseWheat = true;
        dispenseFood = false;
        dispenseBowls = true;
    }
}

