/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.ClassEntity;

final class AccessFlags
extends ClassEntity {
    private static final int ACC_FINAL = 16;
    private static final int ACC_STATIC = 8;
    private static final int ACC_SYNTHETIC = 4096;
    private static final int ACC_TRANSIENT = 128;
    private static final int ACC_VOLATILE = 64;
    private int flags;

    private AccessFlags(int n) {
        this.flags = n;
    }

    AccessFlags(InputStream inputStream) throws IOException {
        this.flags = AccessFlags.readUnsignedShort(inputStream);
    }

    static AccessFlags makeStatic() {
        return new AccessFlags(8);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        AccessFlags.writeShort(outputStream, this.flags);
    }

    boolean isFinal() {
        return (this.flags & 0x10) != 0;
    }

    boolean isStatic() {
        return (this.flags & 8) != 0;
    }

    boolean isSynthetic() {
        return (this.flags & 0x1000) != 0;
    }

    boolean clearTransient() {
        if ((this.flags & 0x80) == 0) {
            return false;
        }
        this.flags &= 0xFFFFFF7F;
        return true;
    }

    boolean clearVolatile() {
        if ((this.flags & 0x40) == 0) {
            return false;
        }
        this.flags &= 0xFFFFFFBF;
        return true;
    }
}

