/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.sf.jadretro.AttrContent;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.LocalVariableDesc;

final class AttrLocalVarsContent
extends AttrContent {
    private Vector localVariables;

    AttrLocalVarsContent(InputStream inputStream, ClassFile classFile) throws IOException {
        int n = AttrLocalVarsContent.readUnsignedShort(inputStream);
        this.localVariables = new Vector(n);
        while (n-- > 0) {
            this.localVariables.addElement(new LocalVariableDesc(inputStream, classFile));
        }
    }

    static String nameValue() {
        return "LocalVariableTable";
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        AttrLocalVarsContent.mapLabelsPcForArray(this.localVariables, nArray);
    }

    boolean removeLabelsInRange(int n, int n2) {
        return AttrLocalVarsContent.removeLabelsInRangeForArray(this.localVariables, n, n2);
    }

    void incLabelIndices(int n, int n2) {
        AttrLocalVarsContent.incLabelIndicesForArray(this.localVariables, n, n2);
    }

    void rebuildLabelsPc(int[] nArray) {
        AttrLocalVarsContent.rebuildLabelsPcForArray(this.localVariables, nArray);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        AttrLocalVarsContent.writeToForArray(this.localVariables, outputStream);
    }

    int getVarsCount() {
        return this.localVariables.size();
    }

    LocalVariableDesc getVarDescAt(int n) {
        return (LocalVariableDesc)this.localVariables.elementAt(n);
    }
}

