/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.AttrCodeContent;
import net.sf.jadretro.AttrContent;
import net.sf.jadretro.AttrInnerClassContent;
import net.sf.jadretro.AttrLineNumsContent;
import net.sf.jadretro.AttrLocalVarsContent;
import net.sf.jadretro.AttrRawContent;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ClassLabeledEntity;
import net.sf.jadretro.ConstantRef;

final class AttributeEntry
extends ClassLabeledEntity {
    private ConstantRef name;
    private AttrContent content;

    AttributeEntry(ConstantRef constantRef, AttrContent attrContent) {
        this.name = constantRef;
        this.content = attrContent;
    }

    AttributeEntry(InputStream inputStream, ClassFile classFile) throws IOException {
        this.name = new ConstantRef(inputStream, classFile, false);
        int n = AttributeEntry.readInt(inputStream);
        if (n < 0) {
            throw new BadClassFileException();
        }
        byte[] byArray = new byte[n];
        AttributeEntry.readFully(inputStream, byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.content = AttributeEntry.decodeContent(byteArrayInputStream, n, this.name, classFile);
        }
        catch (EOFException eOFException) {
            throw new BadClassFileException();
        }
        if (byteArrayInputStream.read() >= 0) {
            throw new BadClassFileException();
        }
    }

    private static AttrContent decodeContent(InputStream inputStream, int n, ConstantRef constantRef, ClassFile classFile) throws IOException {
        String string = constantRef.utfValue();
        if (AttrCodeContent.nameValue().equals(string)) {
            return new AttrCodeContent(inputStream, classFile);
        }
        if (AttrLineNumsContent.nameValue().equals(string)) {
            return new AttrLineNumsContent(inputStream);
        }
        if (AttrLocalVarsContent.nameValue().equals(string) || "LocalVariableTypeTable".equals(string)) {
            return new AttrLocalVarsContent(inputStream, classFile);
        }
        if (AttrInnerClassContent.nameValue().equals(string)) {
            return new AttrInnerClassContent(inputStream, classFile);
        }
        return new AttrRawContent(inputStream, n);
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        this.content.mapLabelsPc(nArray);
    }

    boolean removeLabelsInRange(int n, int n2) {
        return this.content.removeLabelsInRange(n, n2);
    }

    void incLabelIndices(int n, int n2) {
        this.content.incLabelIndices(n, n2);
    }

    void rebuildLabelsPc(int[] nArray) {
        this.content.rebuildLabelsPc(nArray);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.name.writeTo(outputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.content.writeTo(byteArrayOutputStream);
        AttributeEntry.writeInt(outputStream, byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(outputStream);
    }

    String getNameValue() throws BadClassFileException {
        return this.name.utfValue();
    }

    AttrContent content() {
        return this.content;
    }
}

