/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Vector;
import net.sf.jadretro.AccessFlags;
import net.sf.jadretro.AttrCodeContent;
import net.sf.jadretro.AttrContent;
import net.sf.jadretro.AttrInnerClassContent;
import net.sf.jadretro.AttrRawContent;
import net.sf.jadretro.AttributeEntry;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassEntity;
import net.sf.jadretro.ClassOverflowException;
import net.sf.jadretro.ConstantPoolEntry;
import net.sf.jadretro.ConstantRef;
import net.sf.jadretro.FieldMethodEntry;

final class ClassFile
extends ClassEntity {
    private static final int MAGIC_VALUE = -889275714;
    private static final int MAJOR_VER_BASE = 45;
    private static final int MINOR_VER_MIN = 3;
    private int minorVer;
    private int majorVer;
    private Vector constants;
    private AccessFlags accessFlags;
    private ConstantRef thisClass;
    private ConstantRef superClass;
    private Vector interfaces;
    private Vector fields;
    private Vector methods;
    private Vector attributes;

    ClassFile(InputStream inputStream) throws IOException {
        int n;
        if (ClassFile.readInt(inputStream) != -889275714) {
            throw new BadClassFileException();
        }
        this.minorVer = ClassFile.readUnsignedShort(inputStream);
        this.majorVer = ClassFile.readUnsignedShort(inputStream);
        if (this.majorVer < 45 || this.getJavaVer() > 64 || this.majorVer == 45 && this.minorVer < 3) {
            throw new BadClassFileException();
        }
        int n2 = ClassFile.readUnsignedShort(inputStream);
        if (n2 == 0) {
            throw new BadClassFileException();
        }
        this.constants = new Vector(n2);
        this.constants.setSize(n2);
        this.constants.setElementAt(ConstantPoolEntry.EMPTY_ENTRY, 0);
        try {
            for (n = 1; n < n2; ++n) {
                ConstantPoolEntry constantPoolEntry = new ConstantPoolEntry(inputStream, this);
                this.constants.setElementAt(constantPoolEntry, n);
                if (!constantPoolEntry.isLongOrDouble()) continue;
                if (++n == n2) {
                    throw new BadClassFileException();
                }
                this.constants.setElementAt(ConstantPoolEntry.EMPTY_ENTRY, n);
            }
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new BadClassFileException();
        }
        this.accessFlags = new AccessFlags(inputStream);
        this.thisClass = new ConstantRef(inputStream, this, false);
        this.superClass = new ConstantRef(inputStream, this, true);
        n = ClassFile.readUnsignedShort(inputStream);
        this.interfaces = new Vector(n);
        while (n-- > 0) {
            this.interfaces.addElement(new ConstantRef(inputStream, this, false));
        }
        this.fields = ClassFile.readFieldsOrMethods(inputStream, this);
        this.methods = ClassFile.readFieldsOrMethods(inputStream, this);
        this.attributes = ClassFile.readAttributes(inputStream, this);
        if (inputStream.read() >= 0) {
            throw new BadClassFileException();
        }
    }

    private static Vector readFieldsOrMethods(InputStream inputStream, ClassFile classFile) throws IOException {
        int n = ClassFile.readUnsignedShort(inputStream);
        Vector<FieldMethodEntry> vector = new Vector<FieldMethodEntry>(n);
        while (n-- > 0) {
            vector.addElement(new FieldMethodEntry(inputStream, classFile));
        }
        return vector;
    }

    void writeTo(OutputStream outputStream) throws IOException {
        ClassFile.writeInt(outputStream, -889275714);
        ClassFile.writeShort(outputStream, this.minorVer);
        ClassFile.writeShort(outputStream, this.majorVer);
        int n = this.constants.size();
        ClassFile.writeCheckedUShort(outputStream, n);
        try {
            for (int i = 1; i < n; ++i) {
                ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)this.constants.elementAt(i);
                constantPoolEntry.writeTo(outputStream);
                if (!constantPoolEntry.isLongOrDouble()) continue;
                ++i;
            }
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new ClassOverflowException();
        }
        this.accessFlags.writeTo(outputStream);
        this.thisClass.writeTo(outputStream);
        this.superClass.writeTo(outputStream);
        ClassFile.writeToForArray(this.interfaces, outputStream);
        ClassFile.writeToForArray(this.fields, outputStream);
        ClassFile.writeToForArray(this.methods, outputStream);
        ClassFile.writeToForArray(this.attributes, outputStream);
    }

    int getJavaVer() {
        return (this.minorVer > 0 && this.majorVer > 45 ? 2 : 1) + this.majorVer - 45;
    }

    void setJavaVer(int n) {
        if (n > 1) {
            this.majorVer = n + 45 - 1;
            this.minorVer = 0;
        }
    }

    String className() throws BadClassFileException {
        return this.thisClass.classOrName().utfValue();
    }

    String getSuperClassName() throws BadClassFileException {
        return this.superClass.isZero() ? null : this.superClass.classOrName().utfValue();
    }

    int getMethodsCount() {
        return this.methods.size();
    }

    FieldMethodEntry getMethodAt(int n) {
        return (FieldMethodEntry)this.methods.elementAt(n);
    }

    void removeMethodAt(int n) {
        this.methods.removeElementAt(n);
    }

    int getFieldsCount() {
        return this.fields.size();
    }

    FieldMethodEntry getFieldAt(int n) {
        return (FieldMethodEntry)this.fields.elementAt(n);
    }

    int findField(String string, String string2, boolean bl) throws BadClassFileException {
        int n = this.fields.size();
        for (int i = 0; i < n; ++i) {
            FieldMethodEntry fieldMethodEntry = (FieldMethodEntry)this.fields.elementAt(i);
            if (fieldMethodEntry.accessFlags().isStatic() != bl || !string.equals(fieldMethodEntry.name().utfValue()) || !string2.equals(fieldMethodEntry.descriptor().utfValue())) continue;
            return i;
        }
        return -1;
    }

    void removeFieldAt(int n) {
        this.fields.removeElementAt(n);
    }

    void removeStaticAnonInnerClassInfo(String string) throws BadClassFileException {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttrContent attrContent = ((AttributeEntry)this.attributes.elementAt(i)).content();
            if (!(attrContent instanceof AttrInnerClassContent)) continue;
            if (!((AttrInnerClassContent)attrContent).removeStaticAnonInnerClass(string, this.className())) break;
            this.attributes.removeElementAt(i);
            break;
        }
    }

    int getConstantPoolCount() {
        return this.constants.size();
    }

    ConstantPoolEntry getConstantAt(int n) {
        return (ConstantPoolEntry)this.constants.elementAt(n);
    }

    void changeClassConstAt(int n, String string) {
        this.constants.setElementAt(ConstantPoolEntry.makeClassString(this.addUtfConst(string), true), n);
    }

    void changeNameAndTypeConstAt(int n, String string) throws BadClassFileException {
        this.constants.setElementAt(ConstantPoolEntry.makeNameAndType(((ConstantPoolEntry)this.constants.elementAt(n)).content().classOrName(), this.addUtfConst(string)), n);
    }

    private ConstantRef addConstant(ConstantPoolEntry constantPoolEntry) {
        for (int i = this.constants.size() - 1; i > 0; --i) {
            if (!constantPoolEntry.isEqualTo((ConstantPoolEntry)this.constants.elementAt(i))) continue;
            return new ConstantRef(i, this);
        }
        this.constants.addElement(constantPoolEntry);
        return new ConstantRef(this.constants.size() - 1, this);
    }

    ConstantRef addUtfConst(String string) {
        return this.addConstant(ConstantPoolEntry.makeUtf(string));
    }

    ConstantRef addClassStringConst(String string, boolean bl) {
        return this.addConstant(ConstantPoolEntry.makeClassString(this.addUtfConst(string), bl));
    }

    private ConstantRef addFieldNormMethodConst(ConstantRef constantRef, ConstantRef constantRef2, ConstantRef constantRef3, boolean bl) {
        return this.addConstant(ConstantPoolEntry.makeFieldNormMethod(constantRef, this.addConstant(ConstantPoolEntry.makeNameAndType(constantRef2, constantRef3)), bl));
    }

    ConstantRef addNormMethodConst(ConstantRef constantRef, String string, String string2) {
        ConstantRef constantRef2 = this.addUtfConst(string);
        return this.addFieldNormMethodConst(constantRef, constantRef2, this.addUtfConst(string2), false);
    }

    ConstantRef addNormMethodConstFor(int n) {
        FieldMethodEntry fieldMethodEntry = this.getMethodAt(n);
        return this.addFieldNormMethodConst(this.thisClass, fieldMethodEntry.name(), fieldMethodEntry.descriptor(), false);
    }

    AttributeEntry makeSyntheticAttribute() {
        return new AttributeEntry(this.addUtfConst(AttrRawContent.syntheticName()), new AttrRawContent());
    }

    ConstantRef addStaticField(String string, String string2) throws BadClassFileException {
        FieldMethodEntry fieldMethodEntry;
        ConstantRef constantRef = null;
        ConstantRef constantRef2 = null;
        int n = this.fields.size();
        while (n-- > 0) {
            fieldMethodEntry = (FieldMethodEntry)this.fields.elementAt(n);
            constantRef = fieldMethodEntry.name();
            constantRef2 = fieldMethodEntry.descriptor();
            if (!string.equals(constantRef.utfValue())) continue;
            if (fieldMethodEntry.accessFlags().isStatic() && string2.equals(constantRef2.utfValue())) break;
            return null;
        }
        if (n < 0) {
            constantRef = this.addUtfConst(string);
            constantRef2 = this.addUtfConst(string2);
            fieldMethodEntry = new FieldMethodEntry(AccessFlags.makeStatic(), constantRef, constantRef2);
            fieldMethodEntry.addAttribute(this.makeSyntheticAttribute());
            this.fields.addElement(fieldMethodEntry);
        }
        return this.addFieldNormMethodConst(this.thisClass, constantRef, constantRef2, true);
    }

    int addStaticMethodNoExc(String string, String string2) throws BadClassFileException {
        String string3 = string2.substring(0, string2.indexOf(41) + 1);
        for (int i = this.getMethodsCount() - 1; i >= 0; --i) {
            String string4;
            FieldMethodEntry fieldMethodEntry = this.getMethodAt(i);
            if (!string.equals(fieldMethodEntry.name().utfValue()) || !(string4 = fieldMethodEntry.descriptor().utfValue()).startsWith(string3)) continue;
            return fieldMethodEntry.accessFlags().isStatic() && !fieldMethodEntry.hasExceptionsSynthetic(true) && string2.equals(string4) ? i : -1;
        }
        FieldMethodEntry fieldMethodEntry = new FieldMethodEntry(AccessFlags.makeStatic(), this.addUtfConst(string), this.addUtfConst(string2));
        fieldMethodEntry.addAttribute(new AttributeEntry(this.addUtfConst(AttrCodeContent.nameValue()), new AttrCodeContent()));
        fieldMethodEntry.addAttribute(this.makeSyntheticAttribute());
        this.methods.addElement(fieldMethodEntry);
        return this.getMethodsCount() - 1;
    }
}

