/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassLabeledEntity;
import net.sf.jadretro.ClassOverflowException;

final class CodeAbsLabel
extends ClassLabeledEntity {
    private int targetPc;
    private int index = -1;

    CodeAbsLabel() {
    }

    CodeAbsLabel(InputStream inputStream, CodeAbsLabel codeAbsLabel) throws IOException {
        this.targetPc = CodeAbsLabel.readUnsignedShort(inputStream) + (codeAbsLabel != null ? codeAbsLabel.getPc() : 0);
    }

    CodeAbsLabel(InputStream inputStream, boolean bl, int n) throws IOException {
        this.targetPc = (bl ? CodeAbsLabel.readInt(inputStream) : (int)CodeAbsLabel.readShort(inputStream)) + n;
        if (this.targetPc < 0) {
            throw new BadClassFileException();
        }
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        this.mapLabelsPc(nArray, false);
    }

    void mapLabelsPc(int[] nArray, boolean bl) throws BadClassFileException {
        if (this.targetPc >= 0) {
            if (nArray.length - (bl ? 0 : 1) <= this.targetPc || (this.index = nArray[this.targetPc]) < 0) {
                throw new BadClassFileException();
            }
            this.targetPc = -1;
        }
    }

    void incLabelIndices(int n, int n2) {
        if (this.index >= n) {
            this.setNewIndex(this.index + n2);
        }
    }

    void rebuildLabelsPc(int[] nArray) {
        if (this.index < 0 || this.index >= nArray.length) {
            throw new IllegalArgumentException();
        }
        this.targetPc = nArray[this.index];
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.writeRelTo(outputStream, null);
    }

    void writeRelTo(OutputStream outputStream, CodeAbsLabel codeAbsLabel) throws IOException {
        CodeAbsLabel.writeCheckedUShort(outputStream, this.getPc() - (codeAbsLabel != null ? codeAbsLabel.getPc() : 0));
    }

    void writeRelTo(OutputStream outputStream, boolean bl, int n) throws IOException {
        if (bl) {
            CodeAbsLabel.writeInt(outputStream, this.getPc() - n);
        } else {
            int n2 = this.getPc() - n;
            if ((short)n2 != n2) {
                throw new ClassOverflowException();
            }
            CodeAbsLabel.writeShort(outputStream, n2);
        }
    }

    private int getPc() {
        return this.targetPc;
    }

    boolean isEqualTo(CodeAbsLabel codeAbsLabel, int n, int n2, int n3, int[] nArray) {
        int n4 = codeAbsLabel.index - this.index;
        if (n4 != 0) {
            if (codeAbsLabel.index != n3) {
                return n4 == n2 && this.index >= n && codeAbsLabel.index < n3;
            }
            if (nArray[0] != this.index) {
                if (nArray[0] >= 0) {
                    return false;
                }
                nArray[0] = this.index;
            }
        }
        return true;
    }

    boolean isInRange(int n, int n2) {
        return this.index >= n && this.index < n2;
    }

    int getIndex() {
        return this.index;
    }

    void setNewIndex(int n) {
        this.index = n;
        this.targetPc = -1;
    }
}

