/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import net.sf.jadretro.ConstPoolContent;

final class ConstUtfContent
extends ConstPoolContent {
    private String value;

    ConstUtfContent(String string) {
        this.value = string;
    }

    ConstUtfContent(InputStream inputStream) throws IOException {
        this.value = ConstUtfContent.readUTF(inputStream);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        ConstUtfContent.writeUTF(outputStream, this.value);
    }

    boolean isEqualTo(ConstPoolContent constPoolContent) {
        return constPoolContent instanceof ConstUtfContent && this.value.equals(((ConstUtfContent)constPoolContent).value);
    }

    String utfValue() {
        return this.value;
    }

    private static String readUTF(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[ConstUtfContent.readUnsignedShort(inputStream)];
        ConstUtfContent.readFully(inputStream, byArray);
        String string = ConstUtfContent.decodeUTF(byArray);
        if (string == null) {
            throw new UTFDataFormatException();
        }
        return string;
    }

    private static String decodeUTF(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i];
            if (n2 <= 0) {
                if (++i >= n) {
                    return null;
                }
                byte by = byArray[i];
                if ((by & 0xC0) != 128) {
                    return null;
                }
                if ((n2 & 0xE0) == 192) {
                    n2 = (n2 & 0x1F) << 6 | by & 0x3F;
                } else {
                    if (++i >= n || (n2 & 0xF0) != 224) {
                        return null;
                    }
                    byte by2 = byArray[i];
                    if ((by2 & 0xC0) != 128) {
                        return null;
                    }
                    n2 = n2 << 12 | (by & 0x3F) << 6 | by2 & 0x3F;
                }
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    private static void writeUTF(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((n >> 1) + n + 16);
        ConstUtfContent.encodeUTF(byteArrayOutputStream, string);
        int n2 = byteArrayOutputStream.size();
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        ConstUtfContent.writeShort(outputStream, n2);
        byteArrayOutputStream.writeTo(outputStream);
    }

    private static void encodeUTF(ByteArrayOutputStream byteArrayOutputStream, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (n2 == 0 || n2 > 127) {
                if (n2 > 2047) {
                    byteArrayOutputStream.write(n2 >> 12 | 0xE0);
                    byteArrayOutputStream.write(n2 >> 6 & 0x3F | 0x80);
                } else {
                    byteArrayOutputStream.write(n2 >> 6 | 0xC0);
                }
                n2 = n2 & 0x3F | 0x80;
            }
            byteArrayOutputStream.write(n2);
        }
    }
}

