/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ConstantRef;
import net.sf.jadretro.OpByteCode;

final class OpCodeConst
extends OpByteCode {
    private static final int ANEWARRAY = 189;
    private static final int BIPUSH = 16;
    private static final int CHECKCAST = 192;
    private static final int GETSTATIC = 178;
    private static final int INSTANCEOF = 193;
    private static final int INVOKEINTERFACE = 185;
    private static final int INVOKESPECIAL = 183;
    private static final int INVOKESTATIC = 184;
    private static final int INVOKEVIRTUAL = 182;
    private static final int LDC = 18;
    private static final int LDC2_W = 20;
    private static final int LDC_W = 19;
    private static final int MULTIANEWARRAY = 197;
    private static final int NEW = 187;
    private static final int NEWARRAY = 188;
    private static final int PUTFIELD = 181;
    private static final int PUTSTATIC = 179;
    private static final int SIPUSH = 17;
    private int op;
    private ConstantRef poolConst;
    private int intArg;

    private OpCodeConst(int n, ConstantRef constantRef, int n2) {
        this.op = n;
        this.poolConst = constantRef;
        this.intArg = n2;
    }

    private OpCodeConst(int n, ConstantRef constantRef) {
        if (constantRef == null) {
            throw new IllegalArgumentException();
        }
        this.op = n;
        this.poolConst = constantRef;
        this.intArg = 0;
    }

    static OpCodeConst decode(int n, InputStream inputStream, ClassFile classFile) throws IOException {
        if (n == 18) {
            return new OpCodeConst(18, ConstantRef.readAsByteFrom(inputStream, classFile), 0);
        }
        if (n == 17) {
            return new OpCodeConst(17, null, OpCodeConst.readShort(inputStream));
        }
        if (n == 16 || n == 188) {
            return new OpCodeConst(n, null, OpCodeConst.readByte(inputStream));
        }
        if (n == 19 || n == 20 || n >= 178 && n <= 185 || n == 187 || n == 189 || n == 192 || n == 193 || n == 197) {
            ConstantRef constantRef = new ConstantRef(inputStream, classFile, false);
            int n2 = 0;
            if (n == 185 || n == 197) {
                n2 = OpCodeConst.readUnsignedByte(inputStream);
                if (n == 185 && inputStream.read() != 0) {
                    throw new BadClassFileException();
                }
            }
            return new OpCodeConst(n, constantRef, n2);
        }
        return null;
    }

    static OpCodeConst makeInvokestatic(ConstantRef constantRef) {
        return new OpCodeConst(184, constantRef);
    }

    static OpCodeConst makeInvokevirtualSpecial(ConstantRef constantRef, boolean bl) {
        return new OpCodeConst(bl ? 182 : 183, constantRef);
    }

    static OpCodeConst makeLdc(ConstantRef constantRef) {
        return new OpCodeConst(constantRef.isWide() ? 19 : 18, constantRef);
    }

    static OpCodeConst makeNewCheckcast(ConstantRef constantRef, boolean bl) {
        return new OpCodeConst(bl ? 187 : 192, constantRef);
    }

    static OpCodeConst makePutGetstatic(ConstantRef constantRef, boolean bl) {
        return new OpCodeConst(bl ? 179 : 178, constantRef);
    }

    int getLength(int n) {
        return this.op == 185 ? 5 : (this.op == 197 ? 4 : (this.op == 16 || this.op == 18 || this.op == 188 ? 2 : 3));
    }

    void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.op);
        if (this.poolConst != null) {
            if (this.op == 18) {
                this.poolConst.writeAsByteTo(outputStream);
            } else {
                this.poolConst.writeTo(outputStream);
                if (this.op == 185 || this.op == 197) {
                    outputStream.write(this.intArg);
                    if (this.op == 185) {
                        outputStream.write(0);
                    }
                }
            }
        } else if (this.op == 17) {
            OpCodeConst.writeShort(outputStream, this.intArg);
        } else {
            outputStream.write(this.intArg);
        }
    }

    boolean isEqualTo(OpByteCode opByteCode, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Hashtable hashtable) {
        if (!(opByteCode instanceof OpCodeConst)) {
            return false;
        }
        OpCodeConst opCodeConst = (OpCodeConst)opByteCode;
        return this.op == opCodeConst.op && this.intArg == opCodeConst.intArg && (this.poolConst == null || this.poolConst.isEqualTo(opCodeConst.poolConst));
    }

    boolean isCheckcast() {
        return this.op == 192;
    }

    boolean isInvokeMethod() {
        return this.op >= 182 && this.op <= 185;
    }

    boolean isInvokestaticSpecial(boolean bl) {
        return bl ? this.op == 184 : this.op == 183;
    }

    boolean isInvokevirtual() {
        return this.op == 182;
    }

    boolean isLdc() {
        return this.op == 18 || this.op == 19;
    }

    boolean isPutGetstatic(boolean bl) {
        return bl ? this.op == 179 : this.op == 178;
    }

    boolean isPutfield() {
        return this.op == 181;
    }

    boolean isXConstZero() {
        return (this.op == 16 || this.op == 17) && this.intArg == 0;
    }

    ConstantRef getConstRef() {
        return this.poolConst;
    }
}

