/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jadretro.AttrContent;
import net.sf.jadretro.AttributeEntry;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ClassOverflowException;
import net.sf.jadretro.ConstantRef;
import net.sf.jadretro.ExceptionCatch;
import net.sf.jadretro.OpByteCode;
import net.sf.jadretro.OpCodeConst;
import net.sf.jadretro.OpCodeJump;
import net.sf.jadretro.OpCodeSimple;
import net.sf.jadretro.OpCodeSwitch;
import net.sf.jadretro.OpCodeVar;

final class AttrCodeContent
extends AttrContent {
    private static final OpByteCode DUMMY_OPCODE = new OpCodeSimple(0);
    private int maxStack;
    private int maxLocals;
    private final Vector opByteCodes = new Vector();
    private Vector exceptions;
    private Vector attributes;

    AttrCodeContent() {
        this.exceptions = new Vector(1);
        this.attributes = new Vector(0);
    }

    AttrCodeContent(InputStream inputStream, ClassFile classFile) throws IOException {
        this.maxStack = AttrCodeContent.readUnsignedShort(inputStream);
        this.maxLocals = AttrCodeContent.readUnsignedShort(inputStream);
        int[] nArray = this.readCodeFrom(inputStream, classFile);
        int n = AttrCodeContent.readUnsignedShort(inputStream);
        this.exceptions = new Vector(n);
        while (n-- > 0) {
            this.exceptions.addElement(new ExceptionCatch(inputStream, classFile));
        }
        this.attributes = AttrCodeContent.readAttributes(inputStream, classFile);
        this.mapLabelsPcInner(nArray);
    }

    static String nameValue() {
        return "Code";
    }

    private int[] readCodeFrom(InputStream inputStream, ClassFile classFile) throws IOException {
        int n;
        if (this.getOpCodesCount() != 0) {
            throw new BadClassFileException();
        }
        int n2 = AttrCodeContent.readInt(inputStream);
        if (n2 <= 0) {
            throw new BadClassFileException();
        }
        byte[] byArray = new byte[n2];
        AttrCodeContent.readFully(inputStream, byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int[] nArray = new int[byArray.length + 1];
        for (n = nArray.length - 2; n > 0; --n) {
            nArray[n] = -1;
        }
        try {
            while ((n = byteArrayInputStream.available()) > 0) {
                int n3 = AttrCodeContent.readUnsignedByte(byteArrayInputStream);
                OpByteCode opByteCode = OpCodeVar.decode(n3, byteArrayInputStream);
                int n4 = byArray.length - n;
                nArray[n4] = this.opByteCodes.size();
                if (opByteCode == null && (opByteCode = OpCodeJump.decode(n3, byteArrayInputStream, n4)) == null && (opByteCode = OpCodeSwitch.decode(n3, byteArrayInputStream, n4)) == null && (opByteCode = OpCodeConst.decode(n3, byteArrayInputStream, classFile)) == null) {
                    opByteCode = new OpCodeSimple(n3);
                }
                this.opByteCodes.addElement(opByteCode);
            }
        }
        catch (EOFException eOFException) {
            throw new BadClassFileException();
        }
        nArray[byArray.length] = this.opByteCodes.size();
        return nArray;
    }

    private void mapLabelsPcInner(int[] nArray) throws BadClassFileException {
        AttrCodeContent.mapLabelsPcForArray(this.opByteCodes, nArray);
        AttrCodeContent.mapLabelsPcForArray(this.exceptions, nArray);
        AttrCodeContent.mapLabelsPcForArray(this.attributes, nArray);
    }

    private void incLabelIndicesInner(int n, int n2) {
        AttrCodeContent.incLabelIndicesForArray(this.opByteCodes, n, n2);
        AttrCodeContent.incLabelIndicesForArray(this.exceptions, n, n2);
        AttrCodeContent.incLabelIndicesForArray(this.attributes, n, n2);
    }

    private void rebuildLabelsPcInner(int[] nArray) {
        AttrCodeContent.rebuildLabelsPcForArray(this.opByteCodes, nArray);
        AttrCodeContent.rebuildLabelsPcForArray(this.exceptions, nArray);
        AttrCodeContent.rebuildLabelsPcForArray(this.attributes, nArray);
    }

    private int[] evalCodeOffsets() {
        int n = this.opByteCodes.size();
        int[] nArray = new int[n + 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += ((OpByteCode)this.opByteCodes.elementAt(i)).getLength(n2);
        }
        nArray[n] = n2;
        return nArray;
    }

    private void writeCodeTo(OutputStream outputStream) throws IOException {
        int n;
        int n2 = this.opByteCodes.size();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((n2 << 1) + (n2 >> 2) + 16);
        for (n = 0; n < n2; ++n) {
            int n3 = byteArrayOutputStream.size();
            ((OpByteCode)this.opByteCodes.elementAt(n)).writeRelTo(byteArrayOutputStream, n3);
        }
        n = byteArrayOutputStream.size();
        if ((n - 1 & 0xFFFF0000) != 0) {
            throw new ClassOverflowException();
        }
        AttrCodeContent.writeInt(outputStream, n);
        byteArrayOutputStream.writeTo(outputStream);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.rebuildLabelsPcInner(this.evalCodeOffsets());
        AttrCodeContent.writeCheckedUShort(outputStream, this.maxStack);
        AttrCodeContent.writeCheckedUShort(outputStream, this.maxLocals);
        this.writeCodeTo(outputStream);
        AttrCodeContent.writeToForArray(this.exceptions, outputStream);
        AttrCodeContent.writeToForArray(this.attributes, outputStream);
    }

    int maxStack() {
        return this.maxStack;
    }

    void setMaxStack(int n) {
        this.maxStack = n;
    }

    int maxLocals() {
        return this.maxLocals;
    }

    void setMaxLocals(int n) {
        this.maxLocals = n;
    }

    int getCatchesCount() {
        return this.exceptions.size();
    }

    ExceptionCatch getCatch(int n) {
        return (ExceptionCatch)this.exceptions.elementAt(n);
    }

    void addCatch(int n, int n2, int n3, ConstantRef constantRef) {
        this.exceptions.addElement(new ExceptionCatch(n, n2, n3, constantRef));
    }

    void removeCatch(int n) {
        this.exceptions.removeElementAt(n);
    }

    int getAttributesCount() {
        return this.attributes.size();
    }

    AttributeEntry getAttributeAt(int n) {
        return (AttributeEntry)this.attributes.elementAt(n);
    }

    int getOpCodesCount() {
        return this.opByteCodes.size();
    }

    private OpByteCode getOpCodeAt(int n) {
        return n >= 0 && this.opByteCodes.size() > n ? (OpByteCode)this.opByteCodes.elementAt(n) : DUMMY_OPCODE;
    }

    boolean isAthrowAt(int n) {
        return this.getOpCodeAt(n).isAthrow();
    }

    boolean isInvokeMethodAt(int n) {
        return this.getOpCodeAt(n).isInvokeMethod();
    }

    boolean isMonitorexitAt(int n) {
        return this.getOpCodeAt(n).isMonitorexit();
    }

    boolean isTargetInRangeAt(int n, int n2, int n3) {
        return this.getOpCodeAt(n).isTargetInRange(n2, n3);
    }

    boolean isRetAt(int n, int n2) {
        OpByteCode opByteCode = this.getOpCodeAt(n);
        return opByteCode.isRetXLoad(true) && opByteCode.getVarIndex() == n2;
    }

    boolean isXConstZeroAt(int n) {
        return this.getOpCodeAt(n).isXConstZero();
    }

    boolean isXLoadAt(int n) {
        return this.getOpCodeAt(n).isRetXLoad(false);
    }

    boolean isXReturnAt(int n) {
        return this.getOpCodeAt(n).isXReturn();
    }

    int getAstoreAloadVarAt(int n, boolean bl) {
        OpByteCode opByteCode = this.getOpCodeAt(n);
        return opByteCode.isAstoreAload(bl) ? opByteCode.getVarIndex() : -1;
    }

    int getJsrGotoTargetIndexAt(int n, boolean bl) {
        OpByteCode opByteCode = this.getOpCodeAt(n);
        return opByteCode.isJsrGoto(bl) ? opByteCode.getTargetLabel().getIndex() : -1;
    }

    ConstantRef getInvokevirtualRefAt(int n) {
        OpByteCode opByteCode = this.getOpCodeAt(n);
        return opByteCode.isInvokevirtual() ? opByteCode.getConstRef() : null;
    }

    ConstantRef getPutfieldRefAt(int n) {
        OpByteCode opByteCode = this.getOpCodeAt(n);
        return opByteCode.isPutfield() ? opByteCode.getConstRef() : null;
    }

    ConstantRef getPutGetstaticRefAt(int n, boolean bl) {
        OpByteCode opByteCode = this.getOpCodeAt(n);
        return opByteCode.isPutGetstatic(bl) ? opByteCode.getConstRef() : null;
    }

    ConstantRef getConstRefAt(int n) {
        return this.getOpCodeAt(n).getConstRef();
    }

    int findCheckcast(int n) {
        while (this.opByteCodes.size() > n) {
            if (((OpByteCode)this.opByteCodes.elementAt(n)).isCheckcast()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int findLdcClass(int n, int n2) {
        while (n < n2) {
            OpByteCode opByteCode = (OpByteCode)this.opByteCodes.elementAt(n);
            if (opByteCode.isLdc() && opByteCode.getConstRef().isClassConst()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int findInvokestaticSpecial(int n, boolean bl) {
        while (this.opByteCodes.size() > n) {
            if (((OpByteCode)this.opByteCodes.elementAt(n)).isInvokestaticSpecial(bl)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int findPutGetstatic(int n) {
        while (this.opByteCodes.size() > n) {
            OpByteCode opByteCode = (OpByteCode)this.opByteCodes.elementAt(n);
            if (opByteCode.isPutGetstatic(true) || opByteCode.isPutGetstatic(false)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int findRetAload(int n, int n2, boolean bl) {
        while (this.opByteCodes.size() > n) {
            OpByteCode opByteCode = (OpByteCode)this.opByteCodes.elementAt(n);
            if ((bl ? opByteCode.isRetXLoad(true) : opByteCode.isAstoreAload(false)) && opByteCode.getVarIndex() == n2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean isSameCodeRegions(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        int n6 = n2 - n;
        if (n < 0 || n6 < 0 || this.opByteCodes.size() < n3) {
            return false;
        }
        int[] nArray2 = new int[1];
        Hashtable hashtable = new Hashtable();
        for (n5 = n2; n5 < n3; ++n5) {
            if (((OpByteCode)this.opByteCodes.elementAt(n5 - n6)).isEqualTo((OpByteCode)this.opByteCodes.elementAt(n5), n, n6, n3, nArray, nArray2, n4, hashtable)) continue;
            return false;
        }
        if (nArray2[0] < 0) {
            return false;
        }
        if (nArray[0] < 0) {
            return true;
        }
        n5 = n3 - n6;
        if (nArray[0] == n5 || this.getJsrGotoTargetIndexAt(n5, false) == nArray[0]) {
            nArray[0] = -1;
            return true;
        }
        return (nArray[0] < n || nArray[0] > n5) && this.isNewBranchAt(n5);
    }

    private boolean isNewBranchAt(int n) {
        return n == 0 || this.getOpCodeAt(n - 1).isUncondBranch();
    }

    boolean hasBranchesOutsideIntoCode(int n, int n2) {
        block4: {
            int n3 = n + n2;
            if (n2 > 0 && this.opByteCodes.size() >= n3) {
                int n4;
                int n5 = this.exceptions.size();
                for (n4 = 0; n4 < n5; ++n4) {
                    ExceptionCatch exceptionCatch = (ExceptionCatch)this.exceptions.elementAt(n4);
                    if (!exceptionCatch.handler().isInRange(n, n3) || exceptionCatch.start().getIndex() + 1 >= n && exceptionCatch.end().getIndex() <= n3) continue;
                    return true;
                }
                n4 = this.opByteCodes.size();
                do {
                    if (n4 == n3) {
                        n4 = n - 1;
                    }
                    if (--n4 < 0) break block4;
                } while (!((OpByteCode)this.opByteCodes.elementAt(n4)).isTargetInRange(n, n3));
                return true;
            }
        }
        return false;
    }

    void removeCodeAt(int n, int n2) {
        if (n2 != 0) {
            int n3 = n + n2;
            if (n2 > 0) {
                AttrCodeContent.removeLabelsInRangeForArray(this.exceptions, n, n3);
                AttrCodeContent.removeLabelsInRangeForArray(this.attributes, n != 0 || this.opByteCodes.size() == n3 ? n : 1, n3);
                this.incLabelIndicesInner(n3, -n2);
                do {
                    this.opByteCodes.removeElementAt(--n3);
                } while (n < n3);
            } else {
                this.incLabelIndicesInner(n3 + 1, -n2);
                this.insCodeNopsInner(n3, -n2);
            }
        }
    }

    void insertCodeNopsAt(int n, int n2) {
        if (n2 > 0) {
            this.incLabelIndicesInner(n, n2);
            this.insCodeNopsInner(n, n2);
        }
    }

    private void insCodeNopsInner(int n, int n2) {
        do {
            this.opByteCodes.insertElementAt(new OpCodeSimple(0), n);
            ++n;
        } while (--n2 > 0);
    }

    void moveCodeBlockAt(int n, int n2, int n3) {
        this.insertCodeNopsAt(n3, n2);
        if (n >= n3) {
            n += n2;
        }
        for (int i = 0; i < n2; ++i) {
            this.opByteCodes.setElementAt(this.opByteCodes.elementAt(n + i), n3 + i);
        }
        this.removeCodeAt(n, n2);
    }

    void putAreturnAt(int n) {
        this.opByteCodes.setElementAt(OpCodeSimple.makeAreturn(), n);
    }

    void putAthrowAt(int n) {
        this.opByteCodes.setElementAt(OpCodeSimple.makeAthrow(), n);
    }

    void putDupAt(int n) {
        this.opByteCodes.setElementAt(OpCodeSimple.makeDup(), n);
    }

    void putIconstZeroAt(int n) {
        this.opByteCodes.setElementAt(OpCodeSimple.makeIconstZero(), n);
    }

    void putMonitorexitAt(int n) {
        this.opByteCodes.setElementAt(OpCodeSimple.makeMonitorexit(), n);
    }

    void putIfnonnullAt(int n, int n2) {
        this.opByteCodes.setElementAt(OpCodeJump.makeIfnonnull(n2), n);
    }

    void putJsrGotoAt(int n, int n2, boolean bl) {
        this.opByteCodes.setElementAt(OpCodeJump.makeJsrGoto(n2, bl), n);
    }

    void putAstoreAloadAt(int n, int n2, boolean bl) {
        this.opByteCodes.setElementAt(OpCodeVar.makeAstoreAload(n2, bl), n);
    }

    void putRetAt(int n, int n2) {
        this.opByteCodes.setElementAt(OpCodeVar.makeRet(n2), n);
    }

    void putInvokestaticAt(int n, ConstantRef constantRef) {
        this.opByteCodes.setElementAt(OpCodeConst.makeInvokestatic(constantRef), n);
    }

    void putInvokevirtualSpecialAt(int n, ConstantRef constantRef, String string, String string2, boolean bl, ClassFile classFile) {
        this.opByteCodes.setElementAt(OpCodeConst.makeInvokevirtualSpecial(classFile.addNormMethodConst(constantRef, string, string2), bl), n);
    }

    void putLdcClassStringAt(int n, String string, boolean bl, ClassFile classFile) {
        this.opByteCodes.setElementAt(OpCodeConst.makeLdc(classFile.addClassStringConst(string, bl)), n);
    }

    void putNewCheckcastAt(int n, ConstantRef constantRef, boolean bl) {
        this.opByteCodes.setElementAt(OpCodeConst.makeNewCheckcast(constantRef, bl), n);
    }

    void putPutGetstaticAt(int n, ConstantRef constantRef, boolean bl) {
        this.opByteCodes.setElementAt(OpCodeConst.makePutGetstatic(constantRef, bl), n);
    }
}

