/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassEntity;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ConstClassStringContent;
import net.sf.jadretro.ConstFieldMethodNameType;
import net.sf.jadretro.ConstIntContent;
import net.sf.jadretro.ConstLongContent;
import net.sf.jadretro.ConstPoolContent;
import net.sf.jadretro.ConstUtfContent;
import net.sf.jadretro.ConstantRef;

final class ConstantPoolEntry
extends ClassEntity {
    static final int UTF8_TAG = 1;
    static final int INTEGER_TAG = 3;
    static final int FLOAT_TAG = 4;
    static final int LONG_TAG = 5;
    static final int DOUBLE_TAG = 6;
    static final int CLASS_TAG = 7;
    static final int STRING_TAG = 8;
    static final int FIELDREF_TAG = 9;
    static final int METHODREF_TAG = 10;
    static final int IFACEMETHOD_TAG = 11;
    static final int NAMETYPE_TAG = 12;
    static final ConstantPoolEntry EMPTY_ENTRY = new ConstantPoolEntry(0, new ConstIntContent(0));
    private int tag;
    private ConstPoolContent content;

    private ConstantPoolEntry(int n, ConstPoolContent constPoolContent) {
        this.tag = n;
        this.content = constPoolContent;
    }

    ConstantPoolEntry(InputStream inputStream, ClassFile classFile) throws IOException {
        this.tag = ConstantPoolEntry.readUnsignedByte(inputStream);
        this.content = ConstantPoolEntry.decodeContent(inputStream, this.tag, classFile);
    }

    private static ConstPoolContent decodeContent(InputStream inputStream, int n, ClassFile classFile) throws IOException {
        if (n == 7 || n == 8) {
            return new ConstClassStringContent(inputStream, classFile);
        }
        if (n == 9 || n == 10 || n == 11 || n == 12) {
            return new ConstFieldMethodNameType(inputStream, classFile);
        }
        if (n == 3 || n == 4) {
            return new ConstIntContent(inputStream);
        }
        if (n == 5 || n == 6) {
            return new ConstLongContent(inputStream);
        }
        if (n == 1) {
            return new ConstUtfContent(inputStream);
        }
        throw new BadClassFileException();
    }

    static ConstantPoolEntry makeClassString(ConstantRef constantRef, boolean bl) {
        return new ConstantPoolEntry(bl ? 7 : 8, new ConstClassStringContent(constantRef));
    }

    static ConstantPoolEntry makeFieldNormMethod(ConstantRef constantRef, ConstantRef constantRef2, boolean bl) {
        return new ConstantPoolEntry(bl ? 9 : 10, new ConstFieldMethodNameType(constantRef, constantRef2));
    }

    static ConstantPoolEntry makeNameAndType(ConstantRef constantRef, ConstantRef constantRef2) {
        return new ConstantPoolEntry(12, new ConstFieldMethodNameType(constantRef, constantRef2));
    }

    static ConstantPoolEntry makeUtf(String string) {
        return new ConstantPoolEntry(1, new ConstUtfContent(string));
    }

    void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.tag);
        this.content.writeTo(outputStream);
    }

    boolean isEqualTo(ConstantPoolEntry constantPoolEntry) {
        return constantPoolEntry.tag == this.tag && this.content.isEqualTo(constantPoolEntry.content);
    }

    boolean isClassConst() {
        return this.tag == 7;
    }

    boolean isLongOrDouble() {
        return this.tag == 5 || this.tag == 6;
    }

    boolean isNameAndType() {
        return this.tag == 12;
    }

    ConstPoolContent content() {
        return this.content;
    }
}

