/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.sf.jadretro.AccessFlags;
import net.sf.jadretro.AttrCodeContent;
import net.sf.jadretro.AttrContent;
import net.sf.jadretro.AttrRawContent;
import net.sf.jadretro.AttributeEntry;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassEntity;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ConstantRef;

final class FieldMethodEntry
extends ClassEntity {
    private AccessFlags accessFlags;
    private ConstantRef name;
    private ConstantRef descriptor;
    private Vector attributes;

    FieldMethodEntry(AccessFlags accessFlags, ConstantRef constantRef, ConstantRef constantRef2) {
        this.accessFlags = accessFlags;
        this.name = constantRef;
        this.descriptor = constantRef2;
        this.attributes = new Vector(2);
    }

    FieldMethodEntry(InputStream inputStream, ClassFile classFile) throws IOException {
        this.accessFlags = new AccessFlags(inputStream);
        this.name = new ConstantRef(inputStream, classFile, false);
        this.descriptor = new ConstantRef(inputStream, classFile, false);
        this.attributes = FieldMethodEntry.readAttributes(inputStream, classFile);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.accessFlags.writeTo(outputStream);
        this.name.writeTo(outputStream);
        this.descriptor.writeTo(outputStream);
        FieldMethodEntry.writeToForArray(this.attributes, outputStream);
    }

    AccessFlags accessFlags() {
        return this.accessFlags;
    }

    ConstantRef name() {
        return this.name;
    }

    ConstantRef descriptor() {
        return this.descriptor;
    }

    void changeDescriptor(ConstantRef constantRef) {
        this.descriptor = constantRef;
    }

    void addAttribute(AttributeEntry attributeEntry) {
        this.attributes.addElement(attributeEntry);
    }

    boolean hasExceptionsSynthetic(boolean bl) throws BadClassFileException {
        String string = bl ? AttrRawContent.exceptionsName() : AttrRawContent.syntheticName();
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            if (!((AttributeEntry)this.attributes.elementAt(i)).getNameValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    AttrCodeContent findCode() {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttrContent attrContent = ((AttributeEntry)this.attributes.elementAt(i)).content();
            if (!(attrContent instanceof AttrCodeContent)) continue;
            return (AttrCodeContent)attrContent;
        }
        return null;
    }

    int getArgSlotsCount() throws BadClassFileException {
        String string;
        int n;
        int n2 = 0;
        if (!this.accessFlags.isStatic()) {
            ++n2;
        }
        if ((n = (string = this.descriptor.utfValue()).lastIndexOf(41)) <= 0 || string.charAt(0) != '(') {
            throw new BadClassFileException();
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            ++n2;
            if (c == 'D' || c == 'J') {
                ++n2;
                continue;
            }
            while (c == '[') {
                c = string.charAt(++i);
            }
            if (c != 'L' || (i = string.indexOf(59, i + 1)) >= 0 && i < n) continue;
            throw new BadClassFileException();
        }
        return n2;
    }

    boolean isVoidRetType() throws BadClassFileException {
        String string = this.descriptor.utfValue();
        int n = string.length();
        if (n <= 2) {
            throw new BadClassFileException();
        }
        return string.charAt(n - 1) == 'V' && string.charAt(n - 2) == ')';
    }
}

