/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.AccessFlags;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassEntity;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ConstantRef;

final class InnerClassDesc
extends ClassEntity {
    private ConstantRef innerClass;
    private ConstantRef outerClass;
    private ConstantRef innerName;
    private AccessFlags accessFlags;

    InnerClassDesc(InputStream inputStream, ClassFile classFile) throws IOException {
        this.innerClass = new ConstantRef(inputStream, classFile, true);
        this.outerClass = new ConstantRef(inputStream, classFile, true);
        this.innerName = new ConstantRef(inputStream, classFile, true);
        this.accessFlags = new AccessFlags(inputStream);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.innerClass.writeTo(outputStream);
        this.outerClass.writeTo(outputStream);
        this.innerName.writeTo(outputStream);
        this.accessFlags.writeTo(outputStream);
    }

    String getClassNameValue(boolean bl) throws BadClassFileException {
        ConstantRef constantRef = bl ? this.outerClass : this.innerClass;
        return constantRef.isZero() ? null : constantRef.classOrName().utfValue();
    }

    boolean isAnonymousName() {
        return this.innerName.isZero();
    }

    AccessFlags accessFlags() {
        return this.accessFlags;
    }
}

