/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.ClassFile;
import net.sf.jadretro.ClassLabeledEntity;
import net.sf.jadretro.CodeAbsLabel;
import net.sf.jadretro.ConstantRef;

final class LocalVariableDesc
extends ClassLabeledEntity {
    private CodeAbsLabel start;
    private CodeAbsLabel end;
    private ConstantRef name;
    private ConstantRef descriptor;
    private int index;

    LocalVariableDesc(InputStream inputStream, ClassFile classFile) throws IOException {
        this.start = new CodeAbsLabel(inputStream, null);
        this.end = new CodeAbsLabel(inputStream, this.start);
        this.name = new ConstantRef(inputStream, classFile, false);
        this.descriptor = new ConstantRef(inputStream, classFile, false);
        this.index = LocalVariableDesc.readUnsignedShort(inputStream);
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        this.start.mapLabelsPc(nArray, false);
        this.end.mapLabelsPc(nArray, true);
    }

    boolean removeLabelsInRange(int n, int n2) {
        if (this.start.isInRange(n, n2)) {
            if (this.end.isInRange(n, n2 + 1)) {
                return true;
            }
            this.start.setNewIndex(n2);
        } else if (this.end.isInRange(n, n2)) {
            this.end.setNewIndex(n2);
        }
        return false;
    }

    void incLabelIndices(int n, int n2) {
        this.start.incLabelIndices(n, n2);
        this.end.incLabelIndices(n, n2);
    }

    void rebuildLabelsPc(int[] nArray) {
        this.start.rebuildLabelsPc(nArray);
        this.end.rebuildLabelsPc(nArray);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.start.writeTo(outputStream);
        this.end.writeRelTo(outputStream, this.start);
        this.name.writeTo(outputStream);
        this.descriptor.writeTo(outputStream);
        LocalVariableDesc.writeShort(outputStream, this.index);
    }

    ConstantRef descriptor() {
        return this.descriptor;
    }

    void changeDescriptor(ConstantRef constantRef) {
        this.descriptor = constantRef;
    }
}

