/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.CodeAbsLabel;
import net.sf.jadretro.OpByteCode;

final class OpCodeJump
extends OpByteCode {
    private static final int GOTO = 167;
    private static final int GOTO_W = 200;
    private static final int IFEQ = 153;
    private static final int IFNONNULL = 199;
    private static final int IFNULL = 198;
    private static final int JSR = 168;
    private static final int JSR_W = 201;
    private int op;
    private CodeAbsLabel targetLabel;

    private OpCodeJump(int n, CodeAbsLabel codeAbsLabel) {
        this.op = n;
        this.targetLabel = codeAbsLabel;
    }

    static OpCodeJump decode(int n, InputStream inputStream, int n2) throws IOException {
        return n == 200 || n == 201 ? new OpCodeJump(n, new CodeAbsLabel(inputStream, true, n2)) : (n >= 153 && n <= 168 || n == 198 || n == 199 ? new OpCodeJump(n, new CodeAbsLabel(inputStream, false, n2)) : null);
    }

    static OpCodeJump makeIfnonnull(int n) {
        CodeAbsLabel codeAbsLabel = new CodeAbsLabel();
        codeAbsLabel.setNewIndex(n);
        return new OpCodeJump(199, codeAbsLabel);
    }

    static OpCodeJump makeJsrGoto(int n, boolean bl) {
        CodeAbsLabel codeAbsLabel = new CodeAbsLabel();
        codeAbsLabel.setNewIndex(n);
        return new OpCodeJump(bl ? 168 : 167, codeAbsLabel);
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        this.targetLabel.mapLabelsPc(nArray);
    }

    void incLabelIndices(int n, int n2) {
        this.targetLabel.incLabelIndices(n, n2);
    }

    void rebuildLabelsPc(int[] nArray) {
        this.targetLabel.rebuildLabelsPc(nArray);
    }

    int getLength(int n) {
        return this.op == 200 || this.op == 201 ? 5 : 3;
    }

    void writeRelTo(OutputStream outputStream, int n) throws IOException {
        outputStream.write(this.op);
        this.targetLabel.writeRelTo(outputStream, this.op == 200 || this.op == 201, n);
    }

    boolean isEqualTo(OpByteCode opByteCode, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Hashtable hashtable) {
        if (!(opByteCode instanceof OpCodeJump)) {
            return false;
        }
        OpCodeJump opCodeJump = (OpCodeJump)opByteCode;
        return this.op == opCodeJump.op && this.targetLabel.isEqualTo(opCodeJump.targetLabel, n, n2, n3, nArray);
    }

    boolean isJsrGoto(boolean bl) {
        return bl ? this.op == 168 || this.op == 201 : this.op == 167 || this.op == 200;
    }

    CodeAbsLabel getTargetLabel() {
        return this.targetLabel;
    }

    boolean isTargetInRange(int n, int n2) {
        return this.targetLabel.isInRange(n, n2);
    }

    boolean isUncondBranch() {
        return this.op == 167 || this.op == 200;
    }
}

